/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.feed.http;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.feed.AbstractFeed;
import brooklyn.event.feed.AttributePollHandler;
import brooklyn.event.feed.DelegatingPollHandler;
import brooklyn.event.feed.Poller;
import brooklyn.event.feed.http.HttpPollConfig;
import brooklyn.util.http.HttpTool;
import brooklyn.util.http.HttpToolResponse;
import brooklyn.util.time.Duration;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpFeed
extends AbstractFeed {
    public static final Logger log = LoggerFactory.getLogger(HttpFeed.class);
    public static final ConfigKey<SetMultimap<HttpPollIdentifier, HttpPollConfig<?>>> POLLS = ConfigKeys.newConfigKey(new TypeToken<SetMultimap<HttpPollIdentifier, HttpPollConfig<?>>>(){}, "polls");

    public static Builder builder() {
        return new Builder();
    }

    public HttpFeed() {
    }

    protected HttpFeed(Builder builder) {
        this.setConfig(ONLY_IF_SERVICE_UP, builder.onlyIfServiceUp);
        ImmutableMap baseHeaders = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull((Object)builder.headers, (Object)"headers")));
        HashMultimap polls = HashMultimap.create();
        for (HttpPollConfig config : builder.polls) {
            HttpPollConfig configCopy = new HttpPollConfig(config);
            if (configCopy.getPeriod() < 0L) {
                configCopy.period(builder.period);
            }
            String method = config.getMethod();
            Map<String, String> headers = config.buildHeaders((Map<String, String>)baseHeaders);
            byte[] body = config.getBody();
            Duration connectionTimeout = config.getConnectionTimeout();
            Duration socketTimeout = config.getSocketTimeout();
            Optional credentials = Optional.fromNullable((Object)builder.credentials);
            Supplier baseUriProvider = builder.baseUriProvider;
            if (builder.baseUri != null) {
                if (baseUriProvider != null) {
                    throw new IllegalStateException("Not permitted to supply baseUri and baseUriProvider");
                }
                ImmutableMap baseUriVars = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull((Object)builder.baseUriVars, (Object)"baseUriVars")));
                URI uri = config.buildUri(builder.baseUri, (Map<String, String>)baseUriVars);
                baseUriProvider = Suppliers.ofInstance((Object)uri);
            } else if (!builder.baseUriVars.isEmpty()) {
                throw new IllegalStateException("Not permitted to supply URI vars when using a URI provider; pass the vars to the provider instead");
            }
            Preconditions.checkNotNull((Object)baseUriProvider);
            polls.put((Object)new HttpPollIdentifier(method, baseUriProvider, headers, body, credentials, connectionTimeout, socketTimeout), configCopy);
        }
        this.setConfig(POLLS, polls);
        this.initUniqueTag(builder.uniqueTag, polls.values());
    }

    @Override
    protected void preStart() {
        SetMultimap<HttpPollIdentifier, HttpPollConfig<?>> polls = this.getConfig(POLLS);
        for (final HttpPollIdentifier pollInfo : polls.keySet()) {
            Callable<HttpToolResponse> pollJob;
            final HttpClient httpClient = this.createHttpClient(pollInfo);
            Set configs = polls.get((Object)pollInfo);
            long minPeriod = Integer.MAX_VALUE;
            LinkedHashSet handlers = Sets.newLinkedHashSet();
            for (HttpPollConfig config : configs) {
                handlers.add(new AttributePollHandler(config, this.entity, this));
                if (config.getPeriod() <= 0L) continue;
                minPeriod = Math.min(minPeriod, config.getPeriod());
            }
            if (pollInfo.method.equals("get")) {
                pollJob = new Callable<HttpToolResponse>(){

                    @Override
                    public HttpToolResponse call() throws Exception {
                        if (log.isTraceEnabled()) {
                            log.trace("http polling for {} sensors at {}", (Object)HttpFeed.this.entity, (Object)pollInfo);
                        }
                        return HttpTool.httpGet(httpClient, (URI)pollInfo.uriProvider.get(), pollInfo.headers);
                    }
                };
            } else if (pollInfo.method.equals("post")) {
                pollJob = new Callable<HttpToolResponse>(){

                    @Override
                    public HttpToolResponse call() throws Exception {
                        if (log.isTraceEnabled()) {
                            log.trace("http polling for {} sensors at {}", (Object)HttpFeed.this.entity, (Object)pollInfo);
                        }
                        return HttpTool.httpPost(httpClient, (URI)pollInfo.uriProvider.get(), pollInfo.headers, pollInfo.body);
                    }
                };
            } else if (pollInfo.method.equals("head")) {
                pollJob = new Callable<HttpToolResponse>(){

                    @Override
                    public HttpToolResponse call() throws Exception {
                        if (log.isTraceEnabled()) {
                            log.trace("http polling for {} sensors at {}", (Object)HttpFeed.this.entity, (Object)pollInfo);
                        }
                        return HttpTool.httpHead(httpClient, (URI)pollInfo.uriProvider.get(), pollInfo.headers);
                    }
                };
            } else {
                throw new IllegalStateException("Unexpected http method: " + pollInfo.method);
            }
            this.getPoller().scheduleAtFixedRate(pollJob, new DelegatingPollHandler(handlers), minPeriod);
        }
    }

    private HttpClient createHttpClient(HttpPollIdentifier pollIdentifier) {
        URI uri = (URI)pollIdentifier.uriProvider.get();
        HttpTool.HttpClientBuilder builder = HttpTool.httpClientBuilder().trustAll().laxRedirect(true);
        if (uri != null) {
            builder.uri(uri);
        }
        if (uri != null) {
            builder.credential(pollIdentifier.credentials);
        }
        if (pollIdentifier.connectionTimeout != null) {
            builder.connectionTimeout(pollIdentifier.connectionTimeout);
        }
        if (pollIdentifier.socketTimeout != null) {
            builder.socketTimeout(pollIdentifier.socketTimeout);
        }
        return builder.build();
    }

    protected Poller<HttpToolResponse> getPoller() {
        return super.getPoller();
    }

    private static class HttpPollIdentifier {
        final String method;
        final Supplier<URI> uriProvider;
        final Map<String, String> headers;
        final byte[] body;
        final Optional<Credentials> credentials;
        final Duration connectionTimeout;
        final Duration socketTimeout;

        private HttpPollIdentifier(String method, Supplier<URI> uriProvider, Map<String, String> headers, byte[] body, Optional<Credentials> credentials, Duration connectionTimeout, Duration socketTimeout) {
            this.method = ((String)Preconditions.checkNotNull((Object)method, (Object)"method")).toLowerCase();
            this.uriProvider = (Supplier)Preconditions.checkNotNull(uriProvider, (Object)"uriProvider");
            this.headers = (Map)Preconditions.checkNotNull(headers, (Object)"headers");
            this.body = body;
            this.credentials = (Optional)Preconditions.checkNotNull(credentials, (Object)"credentials");
            this.connectionTimeout = connectionTimeout;
            this.socketTimeout = socketTimeout;
            if (!this.method.equals("get") && !this.method.equals("post")) {
                throw new IllegalArgumentException("Unsupported HTTP method (only supports GET and POST): " + method);
            }
            if (body != null && method.equalsIgnoreCase("get")) {
                throw new IllegalArgumentException("Must not set body for http GET method");
            }
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.method, this.uriProvider, this.headers, this.body, this.credentials});
        }

        public boolean equals(Object other) {
            if (!(other instanceof HttpPollIdentifier)) {
                return false;
            }
            HttpPollIdentifier o = (HttpPollIdentifier)other;
            return Objects.equal((Object)this.method, (Object)o.method) && Objects.equal(this.uriProvider, o.uriProvider) && Objects.equal(this.headers, o.headers) && Objects.equal((Object)this.body, (Object)o.body) && Objects.equal(this.credentials, o.credentials);
        }
    }

    public static class Builder {
        private EntityLocal entity;
        private boolean onlyIfServiceUp = false;
        private Supplier<URI> baseUriProvider;
        private Duration period = Duration.millis((Number)500);
        private List<HttpPollConfig<?>> polls = Lists.newArrayList();
        private URI baseUri;
        private Map<String, String> baseUriVars = Maps.newLinkedHashMap();
        private Map<String, String> headers = Maps.newLinkedHashMap();
        private boolean suspended = false;
        private Credentials credentials;
        private String uniqueTag;
        private volatile boolean built;

        public Builder entity(EntityLocal val) {
            this.entity = val;
            return this;
        }

        public Builder onlyIfServiceUp() {
            return this.onlyIfServiceUp(true);
        }

        public Builder onlyIfServiceUp(boolean onlyIfServiceUp) {
            this.onlyIfServiceUp = onlyIfServiceUp;
            return this;
        }

        public Builder baseUri(Supplier<URI> val) {
            if (this.baseUri != null && val != null) {
                throw new IllegalStateException("Builder cannot take both a URI and a URI Provider");
            }
            this.baseUriProvider = val;
            return this;
        }

        public Builder baseUri(URI val) {
            if (this.baseUriProvider != null && val != null) {
                throw new IllegalStateException("Builder cannot take both a URI and a URI Provider");
            }
            this.baseUri = val;
            return this;
        }

        public Builder baseUrl(URL val) {
            return this.baseUri(URI.create(val.toString()));
        }

        public Builder baseUri(String val) {
            return this.baseUri(URI.create(val));
        }

        public Builder baseUriVars(Map<String, String> vals) {
            this.baseUriVars.putAll(vals);
            return this;
        }

        public Builder baseUriVar(String key, String val) {
            this.baseUriVars.put(key, val);
            return this;
        }

        public Builder headers(Map<String, String> vals) {
            this.headers.putAll(vals);
            return this;
        }

        public Builder header(String key, String val) {
            this.headers.put(key, val);
            return this;
        }

        public Builder period(Duration duration) {
            this.period = duration;
            return this;
        }

        public Builder period(long millis) {
            return this.period(millis, TimeUnit.MILLISECONDS);
        }

        public Builder period(long val, TimeUnit units) {
            return this.period(Duration.of((long)val, (TimeUnit)units));
        }

        public Builder poll(HttpPollConfig<?> config) {
            this.polls.add(config);
            return this;
        }

        public Builder suspended() {
            return this.suspended(true);
        }

        public Builder suspended(boolean startsSuspended) {
            this.suspended = startsSuspended;
            return this;
        }

        public Builder credentials(String username, String password) {
            this.credentials = new UsernamePasswordCredentials(username, password);
            return this;
        }

        public Builder credentialsIfNotNull(String username, String password) {
            if (username != null && password != null) {
                this.credentials = new UsernamePasswordCredentials(username, password);
            }
            return this;
        }

        public Builder uniqueTag(String uniqueTag) {
            this.uniqueTag = uniqueTag;
            return this;
        }

        public HttpFeed build() {
            this.built = true;
            HttpFeed result = new HttpFeed(this);
            result.setEntity((EntityLocal)Preconditions.checkNotNull((Object)this.entity, (Object)"entity"));
            if (this.suspended) {
                result.suspend();
            }
            result.start();
            return result;
        }

        protected void finalize() {
            if (!this.built) {
                log.warn("HttpFeed.Builder created, but build() never called");
            }
        }
    }
}

