/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.feed.function;

import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.PollConfig;
import brooklyn.util.GroovyJavaMethods;
import brooklyn.util.guava.Functionals;
import brooklyn.util.javalang.JavaClassNames;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import groovy.lang.Closure;
import java.util.concurrent.Callable;

public class FunctionPollConfig<S, T>
extends PollConfig<S, T, FunctionPollConfig<S, T>> {
    private Callable<?> callable;

    public static <T> FunctionPollConfig<?, T> forSensor(AttributeSensor<T> sensor) {
        return new FunctionPollConfig(sensor);
    }

    public FunctionPollConfig(AttributeSensor<T> sensor) {
        super(sensor);
    }

    public FunctionPollConfig(FunctionPollConfig<S, T> other) {
        super(other);
        this.callable = other.callable;
    }

    public Callable<? extends Object> getCallable() {
        return this.callable;
    }

    public <newS> FunctionPollConfig<newS, T> callable(Callable<? extends newS> val) {
        this.callable = (Callable)Preconditions.checkNotNull(val, (Object)"callable");
        return this;
    }

    public <newS> FunctionPollConfig<newS, T> supplier(Supplier<? extends newS> val) {
        this.callable = Functionals.callable((Supplier)((Supplier)Preconditions.checkNotNull(val, (Object)"supplier")));
        return this;
    }

    private <newS> FunctionPollConfig<newS, T> supplierLegacy(final Supplier<? extends newS> val) {
        Preconditions.checkNotNull(val, (Object)"supplier");
        this.callable = new Callable<newS>(){

            @Override
            public newS call() throws Exception {
                return val.get();
            }
        };
        return this;
    }

    public FunctionPollConfig<S, T> closure(Closure<?> val) {
        this.callable = GroovyJavaMethods.callableFromClosure((Closure)((Closure)Preconditions.checkNotNull(val, (Object)"closure")));
        return this;
    }

    @Override
    protected String toStringBaseName() {
        return "fn";
    }

    @Override
    protected String toStringPollSource() {
        if (this.callable == null) {
            return null;
        }
        String cs = this.callable.toString();
        if (!cs.contains("" + Integer.toHexString(this.callable.hashCode()))) {
            return cs;
        }
        return JavaClassNames.simpleClassName(this.callable);
    }
}

