/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.feed;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.feed.PollHandler;
import brooklyn.management.Task;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.task.DynamicSequentialTask;
import brooklyn.util.task.ScheduledTask;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.Duration;
import com.google.common.base.Objects;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Poller<V> {
    public static final Logger log = LoggerFactory.getLogger(Poller.class);
    private final EntityLocal entity;
    private final boolean onlyIfServiceUp;
    private final Set<Callable<?>> oneOffJobs = new LinkedHashSet();
    private final Set<PollJob<V>> pollJobs = new LinkedHashSet<PollJob<V>>();
    private final Set<Task<?>> oneOffTasks = new LinkedHashSet();
    private final Set<ScheduledTask> tasks = new LinkedHashSet<ScheduledTask>();
    private volatile boolean started = false;

    @Deprecated
    public Poller(EntityLocal entity) {
        this(entity, false);
    }

    public Poller(EntityLocal entity, boolean onlyIfServiceUp) {
        this.entity = entity;
        this.onlyIfServiceUp = onlyIfServiceUp;
    }

    public void submit(Callable<?> job) {
        if (this.started) {
            throw new IllegalStateException("Cannot submit additional tasks after poller has started");
        }
        this.oneOffJobs.add(job);
    }

    public void scheduleAtFixedRate(Callable<V> job, PollHandler<? super V> handler, long period) {
        this.scheduleAtFixedRate(job, handler, Duration.millis((Number)period));
    }

    public void scheduleAtFixedRate(Callable<V> job, PollHandler<? super V> handler, Duration period) {
        if (this.started) {
            throw new IllegalStateException("Cannot schedule additional tasks after poller has started");
        }
        PollJob<? super V> foo = new PollJob<V>(job, handler, period);
        this.pollJobs.add(foo);
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug("Starting poll for {} (using {})", new Object[]{this.entity, this});
        }
        if (this.started) {
            throw new IllegalStateException(String.format("Attempt to start poller %s of entity %s when already running", this, this.entity));
        }
        this.started = true;
        for (Callable<?> callable : this.oneOffJobs) {
            Task task = Tasks.builder().dynamic(false).body(callable).name("Poll").description("One-time poll job " + callable).build();
            this.oneOffTasks.add(((EntityInternal)this.entity).getExecutionContext().submit(task));
        }
        for (final PollJob pollJob : this.pollJobs) {
            final String scheduleName = pollJob.handler.getDescription();
            if (pollJob.pollPeriod.compareTo(Duration.ZERO) > 0) {
                Callable pollingTaskFactory = new Callable<Task<?>>(){

                    @Override
                    public Task<?> call() {
                        DynamicSequentialTask<Void> task = new DynamicSequentialTask<Void>((Map<?, ?>)MutableMap.of((Object)"displayName", (Object)scheduleName, (Object)"entity", (Object)Poller.this.entity), new Callable<Void>(){

                            @Override
                            public Void call() {
                                if (Poller.this.onlyIfServiceUp && !Boolean.TRUE.equals(Poller.this.entity.getAttribute(Attributes.SERVICE_UP))) {
                                    return null;
                                }
                                pollJob.wrappedJob.run();
                                return null;
                            }
                        });
                        BrooklynTaskTags.setTransient(task);
                        return task;
                    }
                };
                ScheduledTask task = new ScheduledTask((Map)MutableMap.of((Object)"period", (Object)pollJob.pollPeriod, (Object)"displayName", (Object)("scheduled:" + scheduleName)), pollingTaskFactory);
                this.tasks.add(Entities.submit((Entity)this.entity, task));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Activating poll (but leaving off, as period {}) for {} (using {})", new Object[]{pollJob.pollPeriod, this.entity, this});
        }
    }

    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug("Stopping poll for {} (using {})", new Object[]{this.entity, this});
        }
        if (!this.started) {
            throw new IllegalStateException(String.format("Attempt to stop poller %s of entity %s when not running", this, this.entity));
        }
        this.started = false;
        for (Task<?> task : this.oneOffTasks) {
            if (task == null) continue;
            task.cancel(true);
        }
        for (ScheduledTask scheduledTask : this.tasks) {
            if (scheduledTask == null) continue;
            scheduledTask.cancel();
        }
        this.oneOffTasks.clear();
        this.tasks.clear();
    }

    public boolean isRunning() {
        boolean hasActiveTasks = false;
        for (Task task : this.tasks) {
            if (!task.isBegun() || task.isDone()) continue;
            hasActiveTasks = true;
            break;
        }
        if (!this.started && hasActiveTasks) {
            log.warn("Poller should not be running, but has active tasks, tasks: " + this.tasks);
        }
        return this.started && hasActiveTasks;
    }

    protected boolean isEmpty() {
        return this.pollJobs.isEmpty();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("entity", (Object)this.entity).toString();
    }

    private static class PollJob<V> {
        final PollHandler<? super V> handler;
        final Duration pollPeriod;
        final Runnable wrappedJob;
        private boolean loggedPreviousException = false;

        PollJob(final Callable<V> job, final PollHandler<? super V> handler, Duration period) {
            this.handler = handler;
            this.pollPeriod = period;
            this.wrappedJob = new Runnable(){

                @Override
                public void run() {
                    try {
                        Object val = job.call();
                        PollJob.this.loggedPreviousException = false;
                        if (handler.checkSuccess(val)) {
                            handler.onSuccess(val);
                        } else {
                            handler.onFailure(val);
                        }
                    }
                    catch (Exception e) {
                        if (PollJob.this.loggedPreviousException) {
                            if (log.isTraceEnabled()) {
                                log.trace("PollJob for {}, repeated consecutive failures, handling {} using {}", new Object[]{job, e, handler});
                            }
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug("PollJob for {} handling {} using {}", new Object[]{job, e, handler});
                            }
                            PollJob.this.loggedPreviousException = true;
                        }
                        handler.onException(e);
                    }
                }
            };
        }
    }
}

