/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.feed;

import brooklyn.event.feed.AttributePollHandler;
import brooklyn.event.feed.PollHandler;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class DelegatingPollHandler<V>
implements PollHandler<V> {
    private final List<AttributePollHandler<? super V>> delegates;

    public DelegatingPollHandler(Iterable<AttributePollHandler<? super V>> delegates) {
        this.delegates = ImmutableList.copyOf(delegates);
    }

    @Override
    public boolean checkSuccess(V val) {
        for (AttributePollHandler<V> delegate : this.delegates) {
            if (delegate.checkSuccess(val)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onSuccess(V val) {
        for (AttributePollHandler<V> delegate : this.delegates) {
            delegate.onSuccess(val);
        }
    }

    @Override
    public void onFailure(V val) {
        for (AttributePollHandler<V> delegate : this.delegates) {
            delegate.onFailure(val);
        }
    }

    @Override
    public void onException(Exception exception) {
        for (AttributePollHandler<V> delegate : this.delegates) {
            delegate.onException(exception);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.getDescription() + "]";
    }

    @Override
    public String getDescription() {
        if (this.delegates.isEmpty()) {
            return "(empty delegate list)";
        }
        if (this.delegates.size() == 1) {
            return this.delegates.get(0).getDescription();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int count = 0;
        for (AttributePollHandler<V> delegate : this.delegates) {
            if (count > 0) {
                sb.append("; ");
            }
            sb.append(delegate.getDescription());
            if (count > 2) {
                sb.append("; ...");
                break;
            }
            ++count;
        }
        sb.append("]");
        return sb.toString();
    }
}

