/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.feed;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.AbstractFeed;
import brooklyn.event.feed.FeedConfig;
import brooklyn.event.feed.PollHandler;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.Duration;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributePollHandler<V>
implements PollHandler<V> {
    public static final Logger log = LoggerFactory.getLogger(AttributePollHandler.class);
    private final FeedConfig<V, ?, ?> config;
    private final EntityLocal entity;
    private final AttributeSensor sensor;
    private final AbstractFeed feed;
    private Duration logWarningGraceTimeOnStartup = Duration.THIRTY_SECONDS;
    private Duration logWarningGraceTime = Duration.millis((Number)0);
    private volatile Long lastSuccessTime = null;
    private volatile Long currentProblemStartTime = null;
    private volatile boolean currentProblemLoggedAsWarning = false;
    private volatile boolean lastWasProblem = false;

    public AttributePollHandler(FeedConfig<V, ?, ?> config, EntityLocal entity, AbstractFeed feed) {
        this.config = (FeedConfig)Preconditions.checkNotNull(config, (Object)"config");
        this.entity = (EntityLocal)Preconditions.checkNotNull((Object)entity, (Object)"entity");
        this.sensor = (AttributeSensor)Preconditions.checkNotNull(config.getSensor(), (Object)"sensor");
        this.feed = (AbstractFeed)Preconditions.checkNotNull((Object)feed, (Object)"feed");
    }

    @Override
    public boolean checkSuccess(V val) {
        return !this.config.hasCheckSuccessHandler() || this.config.getCheckSuccess().apply(val);
    }

    @Override
    public void onSuccess(V val) {
        block7: {
            if (this.lastWasProblem) {
                if (this.currentProblemLoggedAsWarning) {
                    log.info("Success (following previous problem) reading " + this.getBriefDescription());
                } else {
                    log.debug("Success (following previous problem) reading " + this.getBriefDescription());
                }
                this.lastWasProblem = false;
                this.currentProblemStartTime = null;
                this.currentProblemLoggedAsWarning = false;
            }
            this.lastSuccessTime = System.currentTimeMillis();
            if (log.isTraceEnabled()) {
                log.trace("poll for {} got: {}", new Object[]{this.getBriefDescription(), val});
            }
            try {
                this.setSensor(this.transformValueOnSuccess(val));
            }
            catch (Exception e) {
                if (this.feed.isConnected()) {
                    log.warn("unable to compute " + this.getBriefDescription() + "; on val=" + val, (Throwable)e);
                }
                if (!log.isDebugEnabled()) break block7;
                log.debug("unable to compute " + this.getBriefDescription() + "; val=" + val + " (when inactive)", (Throwable)e);
            }
        }
    }

    protected Object transformValueOnSuccess(V val) {
        return this.config.hasSuccessHandler() ? this.config.getOnSuccess().apply(val) : val;
    }

    @Override
    public void onFailure(V val) {
        block5: {
            if (!this.config.hasFailureHandler()) {
                this.onException(new Exception("checkSuccess of " + this + " for " + this.getBriefDescription() + " was false but poller has no failure handler"));
            } else {
                this.logProblem("failure", val);
                try {
                    this.setSensor(this.config.hasFailureHandler() ? this.config.getOnFailure().apply(val) : val);
                }
                catch (Exception e) {
                    if (this.feed.isConnected()) {
                        log.warn("Error computing " + this.getBriefDescription() + "; val=" + val + ": " + e, (Throwable)e);
                    }
                    if (!log.isDebugEnabled()) break block5;
                    log.debug("Error computing " + this.getBriefDescription() + "; val=" + val + " (when inactive)", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void onException(Exception exception) {
        block7: {
            if (!this.feed.isConnected()) {
                if (log.isTraceEnabled()) {
                    log.trace("Read of {} in {} gave exception (while not connected or not yet connected): {}", new Object[]{this, this.getBriefDescription(), exception});
                }
            } else {
                this.logProblem("exception", exception);
            }
            if (this.config.hasExceptionHandler()) {
                try {
                    this.setSensor(this.config.getOnException().apply((Object)exception));
                }
                catch (Exception e) {
                    if (this.feed.isConnected()) {
                        log.warn("unable to compute " + this.getBriefDescription() + "; on exception=" + exception, (Throwable)e);
                    }
                    if (!log.isDebugEnabled()) break block7;
                    log.debug("unable to compute " + this.getBriefDescription() + "; exception=" + exception + " (when inactive)", (Throwable)e);
                }
            }
        }
    }

    protected void logProblem(String type, Object val) {
        if (this.lastWasProblem && this.currentProblemLoggedAsWarning) {
            if (log.isTraceEnabled()) {
                log.trace("Recurring {} reading {} in {}: {}", new Object[]{type, this, this.getBriefDescription(), val});
            }
        } else {
            long expiryTime;
            long nowTime = System.currentTimeMillis();
            Long currentProblemStartTimeCache = this.currentProblemStartTime;
            long l = this.lastSuccessTime != null && !this.isTransitioningOrStopped() ? this.lastSuccessTime + this.logWarningGraceTime.toMilliseconds() : (expiryTime = currentProblemStartTimeCache != null ? currentProblemStartTimeCache + this.logWarningGraceTimeOnStartup.toMilliseconds() : nowTime + this.logWarningGraceTimeOnStartup.toMilliseconds());
            if (!this.lastWasProblem) {
                if (expiryTime <= nowTime) {
                    this.currentProblemLoggedAsWarning = true;
                    if (this.entity == null || !Entities.isNoLongerManaged((Entity)this.entity)) {
                        log.warn("Read of " + this.getBriefDescription() + " gave " + type + ": " + val);
                    } else {
                        log.debug("Read of " + this.getBriefDescription() + " gave " + type + ": " + val);
                    }
                    if (log.isDebugEnabled() && val instanceof Throwable) {
                        log.debug("Trace for " + type + " reading " + this.getBriefDescription() + ": " + val, (Throwable)val);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Read of " + this.getBriefDescription() + " gave " + type + " (in grace period): " + val);
                }
                this.lastWasProblem = true;
                this.currentProblemStartTime = nowTime;
            } else if (expiryTime <= nowTime) {
                this.currentProblemLoggedAsWarning = true;
                log.warn("Read of " + this.getBriefDescription() + " gave " + type + " (grace period expired, occurring for " + Duration.millis((Number)(nowTime - currentProblemStartTimeCache)) + (this.config.hasExceptionHandler() ? "" : ", no exception handler set for sensor") + ")" + ": " + val);
                if (log.isDebugEnabled() && val instanceof Throwable) {
                    log.debug("Trace for " + type + " reading " + this.getBriefDescription() + ": " + val, (Throwable)val);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Recurring {} reading {} in {} (still in grace period): {}", new Object[]{type, this, this.getBriefDescription(), val});
            }
        }
    }

    protected boolean isTransitioningOrStopped() {
        if (this.entity == null) {
            return false;
        }
        Lifecycle.Transition expected = (Lifecycle.Transition)this.entity.getAttribute(Attributes.SERVICE_STATE_EXPECTED);
        if (expected == null) {
            return false;
        }
        return expected.getState() == Lifecycle.STARTING || expected.getState() == Lifecycle.STOPPING || expected.getState() == Lifecycle.STOPPED;
    }

    protected void setSensor(Object v) {
        if (Entities.isNoLongerManaged((Entity)this.entity)) {
            if (Tasks.isInterrupted()) {
                return;
            }
            log.warn("" + this.entity + " is not managed; feed " + this + " setting " + this.sensor + " to " + v + " at this time is not supported (" + Tasks.current() + ")");
        }
        if (v != FeedConfig.UNCHANGED) {
            if (v == FeedConfig.REMOVE) {
                ((EntityInternal)this.entity).removeAttribute(this.sensor);
            } else if (this.sensor != FeedConfig.NO_SENSOR) {
                this.entity.setAttribute(this.sensor, TypeCoercions.coerce(v, this.sensor.getType()));
            }
        }
    }

    public String toString() {
        return super.toString() + "[" + this.getDescription() + "]";
    }

    @Override
    public String getDescription() {
        return this.sensor.getName() + " @ " + this.entity.getId() + " <- " + this.config;
    }

    protected String getBriefDescription() {
        return "" + this.entity + "->" + (this.sensor == FeedConfig.NO_SENSOR ? "(dynamic sensors)" : "" + this.sensor);
    }
}

