/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.basic;

import brooklyn.config.render.RendererHints;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensor;
import brooklyn.util.net.UserAndHostAndPort;
import brooklyn.util.text.StringFunctions;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.google.common.reflect.TypeToken;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import javax.annotation.Nullable;

public class Sensors {
    @Beta
    public static <T> Builder<T> builder(TypeToken<T> type, String name) {
        return new Builder<T>().type(type).name(name);
    }

    @Beta
    public static <T> Builder<T> builder(Class<T> type, String name) {
        return new Builder<T>().type(type).name(name);
    }

    public static <T> AttributeSensor<T> newSensor(Class<T> type, String name) {
        return new BasicAttributeSensor<T>(type, name);
    }

    public static <T> AttributeSensor<T> newSensor(Class<T> type, String name, String description) {
        return new BasicAttributeSensor<T>(type, name, description);
    }

    public static <T> AttributeSensor<T> newSensor(TypeToken<T> type, String name, String description) {
        return new BasicAttributeSensor<T>(type, name, description);
    }

    public static AttributeSensor<String> newStringSensor(String name) {
        return Sensors.newSensor(String.class, name);
    }

    public static AttributeSensor<String> newStringSensor(String name, String description) {
        return Sensors.newSensor(String.class, name, description);
    }

    public static AttributeSensor<Integer> newIntegerSensor(String name) {
        return Sensors.newSensor(Integer.class, name);
    }

    public static AttributeSensor<Integer> newIntegerSensor(String name, String description) {
        return Sensors.newSensor(Integer.class, name, description);
    }

    public static AttributeSensor<Long> newLongSensor(String name) {
        return Sensors.newSensor(Long.class, name);
    }

    public static AttributeSensor<Long> newLongSensor(String name, String description) {
        return Sensors.newSensor(Long.class, name, description);
    }

    public static AttributeSensor<Double> newDoubleSensor(String name) {
        return Sensors.newSensor(Double.class, name);
    }

    public static AttributeSensor<Double> newDoubleSensor(String name, String description) {
        return Sensors.newSensor(Double.class, name, description);
    }

    public static AttributeSensor<Boolean> newBooleanSensor(String name) {
        return Sensors.newSensor(Boolean.class, name);
    }

    public static AttributeSensor<Boolean> newBooleanSensor(String name, String description) {
        return Sensors.newSensor(Boolean.class, name, description);
    }

    public static <T> AttributeSensor<T> newSensorRenamed(String newName, AttributeSensor<T> sensor) {
        return new BasicAttributeSensor(sensor.getTypeToken(), newName, sensor.getDescription());
    }

    public static <T> AttributeSensor<T> newSensorWithPrefix(String prefix, AttributeSensor<T> sensor) {
        return Sensors.newSensorRenamed(prefix + sensor.getName(), sensor);
    }

    static {
        RendererHints.register(Duration.class, RendererHints.displayValue(Time.fromDurationToTimeStringRounded()));
        RendererHints.register(HostAndPort.class, RendererHints.displayValue(StringFunctions.toStringFunction()));
        RendererHints.register(UserAndHostAndPort.class, RendererHints.displayValue(StringFunctions.toStringFunction()));
        RendererHints.register(InetAddress.class, RendererHints.displayValue(new Function<InetAddress, String>(){

            public String apply(@Nullable InetAddress input) {
                return input == null ? null : input.getHostAddress();
            }
        }));
        RendererHints.register(URL.class, RendererHints.displayValue(StringFunctions.toStringFunction()));
        RendererHints.register(URL.class, RendererHints.openWithUrl(StringFunctions.toStringFunction()));
        RendererHints.register(URI.class, RendererHints.displayValue(StringFunctions.toStringFunction()));
        RendererHints.register(URI.class, RendererHints.openWithUrl(StringFunctions.toStringFunction()));
    }

    @Beta
    public static class Builder<T> {
        private String name;
        private TypeToken<T> type;
        private String description;
        private AttributeSensor.SensorPersistenceMode persistence;

        protected Builder() {
        }

        public Builder<T> name(String val) {
            this.name = (String)Preconditions.checkNotNull((Object)val, (Object)"name");
            return this;
        }

        public Builder<T> type(Class<T> val) {
            return this.type(TypeToken.of(val));
        }

        public Builder<T> type(TypeToken<T> val) {
            this.type = (TypeToken)Preconditions.checkNotNull(val, (Object)"type");
            return this;
        }

        public Builder<T> description(String val) {
            this.description = val;
            return this;
        }

        public Builder<T> persistence(AttributeSensor.SensorPersistenceMode val) {
            this.persistence = val;
            return this;
        }

        public AttributeSensor<T> build() {
            return new BasicAttributeSensor<T>(this.type, this.name, this.description, this.persistence);
        }
    }
}

