/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.basic;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.BrooklynConfigKeys;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.internal.BrooklynInitialization;
import brooklyn.location.Location;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.PortRange;
import brooklyn.location.PortSupplier;
import brooklyn.location.basic.Locations;
import brooklyn.management.ManagementContext;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.guava.Maybe;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortAttributeSensorAndConfigKey
extends AttributeSensorAndConfigKey<PortRange, Integer> {
    private static final long serialVersionUID = 4680651022807491321L;
    public static final Logger LOG = LoggerFactory.getLogger(PortAttributeSensorAndConfigKey.class);

    public PortAttributeSensorAndConfigKey(String name) {
        this(name, name, null);
    }

    public PortAttributeSensorAndConfigKey(String name, String description) {
        this(name, description, null);
    }

    public PortAttributeSensorAndConfigKey(String name, String description, Object defaultValue) {
        super(PortRange.class, Integer.class, name, description, defaultValue);
    }

    public PortAttributeSensorAndConfigKey(PortAttributeSensorAndConfigKey orig, Object defaultValue) {
        super(orig, TypeCoercions.coerce(defaultValue, PortRange.class));
    }

    @Override
    protected Integer convertConfigToSensor(PortRange value, Entity entity) {
        if (value == null) {
            return null;
        }
        Collection locations = entity.getLocations();
        if (!locations.isEmpty()) {
            Maybe lo = Locations.findUniqueMachineLocation(locations);
            if (!lo.isPresent()) {
                Iterator li = Iterables.filter((Iterable)locations, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(MachineProvisioningLocation.class))).iterator();
                if (li.hasNext()) {
                    lo = Maybe.of(li.next());
                }
                if (li.hasNext()) {
                    lo = Maybe.absent();
                }
            }
            if (!lo.isPresent() && locations.size() == 1) {
                lo = Maybe.of(locations.iterator().next());
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Convert config to sensor for {} found locations: {}. Selected: {}", new Object[]{entity, locations, lo});
            }
            if (lo.isPresent()) {
                Location l = (Location)lo.get();
                Optional locationRunning = Optional.fromNullable((Object)l.getConfig(BrooklynConfigKeys.SKIP_ENTITY_START_IF_RUNNING));
                Optional entityRunning = Optional.fromNullable((Object)entity.getConfig(BrooklynConfigKeys.SKIP_ENTITY_START_IF_RUNNING));
                Optional locationInstalled = Optional.fromNullable((Object)l.getConfig(BrooklynConfigKeys.SKIP_ENTITY_INSTALLATION));
                Optional entityInstalled = Optional.fromNullable((Object)entity.getConfig(BrooklynConfigKeys.SKIP_ENTITY_INSTALLATION));
                Optional entityStarted = Optional.fromNullable((Object)entity.getConfig(BrooklynConfigKeys.SKIP_ENTITY_START));
                boolean skipCheck = (Boolean)locationRunning.or(entityRunning).or(locationInstalled).or(entityInstalled).or(entityStarted).or((Object)false);
                if (l instanceof PortSupplier) {
                    int p = ((PortSupplier)l).obtainPort(value);
                    if (p != -1) {
                        LOG.debug("{}: choosing port {} for {}", new Object[]{entity, p, this.getName()});
                        return p;
                    }
                    if (!skipCheck) {
                        int rangeSize = Iterables.size((Iterable)value);
                        if (rangeSize == 0) {
                            LOG.warn("{}: no port available for {} (empty range {})", new Object[]{entity, this.getName(), value});
                        } else if (rangeSize == 1) {
                            Integer pp = (Integer)value.iterator().next();
                            if (pp > 1024) {
                                LOG.warn("{}: port {} not available for {}", new Object[]{entity, pp, this.getName()});
                            } else {
                                LOG.warn("{}: port {} not available for {} (root may be required?)", new Object[]{entity, pp, this.getName()});
                            }
                        } else {
                            LOG.warn("{}: no port available for {} (tried range {})", new Object[]{entity, this.getName(), value});
                        }
                        return null;
                    }
                }
                Integer v = value.isEmpty() ? null : (Integer)value.iterator().next();
                LOG.debug("{}: choosing port {} (unconfirmed) for {}", new Object[]{entity, v, this.getName()});
                return v;
            }
            LOG.warn("{}: ports not applicable, or not yet applicable, because has multiple locations {}; ignoring ", new Object[]{entity, locations, this.getName()});
        } else {
            LOG.warn("{}: ports not applicable, or not yet applicable, bacause has no locations; ignoring {}", (Object)entity, (Object)this.getName());
        }
        return null;
    }

    @Override
    protected Integer convertConfigToSensor(PortRange value, ManagementContext managementContext) {
        LOG.warn("ports not applicable, because given managementContext rather than entity; ignoring {}", (Object)this.getName());
        return null;
    }

    static {
        BrooklynInitialization.initAll();
    }
}

