/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.basic;

import brooklyn.config.ConfigKey;
import brooklyn.event.basic.AbstractStructuredConfigKey;
import brooklyn.event.basic.StructuredConfigKey;
import brooklyn.management.ExecutionContext;
import brooklyn.util.collections.Jsonya;
import brooklyn.util.collections.MutableMap;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapConfigKey<V>
extends AbstractStructuredConfigKey<Map<String, V>, Map<String, Object>, V> {
    private static final long serialVersionUID = -6126481503795562602L;
    private static final Logger log = LoggerFactory.getLogger(MapConfigKey.class);

    public MapConfigKey(Class<V> subType, String name) {
        this(subType, name, name, null);
    }

    public MapConfigKey(Class<V> subType, String name, String description) {
        this(subType, name, description, null);
    }

    public MapConfigKey(Class<V> subType, String name, String description, Map<String, V> defaultValue) {
        super(Map.class, subType, name, description, defaultValue);
    }

    @Override
    public ConfigKey<V> subKey(String subName) {
        return super.subKey(subName);
    }

    @Override
    public ConfigKey<V> subKey(String subName, String description) {
        return super.subKey(subName, description);
    }

    @Override
    protected Map<String, Object> extractValueMatchingThisKey(Object potentialBase, ExecutionContext exec, boolean coerce) throws InterruptedException, ExecutionException {
        if (coerce) {
            potentialBase = this.resolveValue(potentialBase, exec);
        }
        if (potentialBase == null) {
            return null;
        }
        if (potentialBase instanceof Map) {
            return Maps.newLinkedHashMap((Map)((Map)potentialBase));
        }
        log.warn("Unable to extract " + this.getName() + " as Map; it is " + potentialBase.getClass().getName() + " " + potentialBase);
        return null;
    }

    @Override
    protected Map<String, Object> merge(Map<String, Object> base, Map<String, Object> subkeys, boolean unmodifiable) {
        Object result = MutableMap.copyOf(base).add(subkeys);
        if (unmodifiable) {
            result = Collections.unmodifiableMap(result);
        }
        return result;
    }

    @Override
    public Object applyValueToMap(Object value, Map target) {
        if (value == null) {
            return null;
        }
        if (value instanceof StructuredConfigKey.StructuredModification) {
            return ((StructuredConfigKey.StructuredModification)value).applyToKeyInMap(this, target);
        }
        if (value instanceof Map.Entry) {
            return this.applyEntryValueToMap((Map.Entry)value, target);
        }
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Cannot set non-map entries " + value + " on " + this);
        }
        MutableMap result = new MutableMap();
        Iterator i$ = ((Map)value).entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entry;
            Map.Entry entryT = entry = i$.next();
            result.put(entryT.getKey(), this.applyEntryValueToMap(entryT, target));
        }
        if (((Map)value).isEmpty() && !this.isSet(target)) {
            target.put(this, MutableMap.of());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object applyEntryValueToMap(Map.Entry value, Map target) {
        Object k = value.getKey();
        if (!this.acceptsSubkeyStronglyTyped(k)) {
            if (k instanceof ConfigKey) {
                k = this.subKey(((ConfigKey)k).getName());
            } else if (k instanceof String) {
                k = this.subKey((String)k);
            } else {
                if (k instanceof Supplier) {
                    Object mapAtRoot = target.get(this);
                    if (mapAtRoot == null) {
                        mapAtRoot = new LinkedHashMap();
                        target.put(this, mapAtRoot);
                    }
                    if (mapAtRoot instanceof Map) {
                        if (mapAtRoot instanceof ConcurrentMap) {
                            return ((Map)mapAtRoot).put(k, value.getValue());
                        }
                        Object object = mapAtRoot;
                        synchronized (object) {
                            return ((Map)mapAtRoot).put(k, value.getValue());
                        }
                    }
                }
                log.warn("Unexpected subkey " + k + " being inserted into " + this + "; ignoring");
                k = null;
            }
        }
        if (k != null) {
            return target.put(k, value.getValue());
        }
        return null;
    }

    public static class MapModificationBase<V>
    extends LinkedHashMap<String, V>
    implements MapModification<V> {
        private static final long serialVersionUID = -1670820613292286486L;
        private final boolean clearFirst;

        public MapModificationBase(Map<String, V> delegate, boolean clearFirst) {
            super(delegate);
            this.clearFirst = clearFirst;
        }

        @Override
        public Object applyToKeyInMap(MapConfigKey<V> key, Map target) {
            if (this.clearFirst) {
                MapConfigKey<V> clearing = StructuredConfigKey.StructuredModifications.clearing();
                clearing.applyToKeyInMap(key, target);
            }
            return key.applyValueToMap(new LinkedHashMap(this), target);
        }
    }

    public static class MapModifications
    extends StructuredConfigKey.StructuredModifications {
        public static final <V> MapModification<V> put(Map<String, V> itemsToPutInMapReplacing) {
            return new MapModificationBase<V>(itemsToPutInMapReplacing, false);
        }

        public static final <V> MapModification<V> set(Map<String, V> itemsToPutInMapAfterClearing) {
            return new MapModificationBase<V>(itemsToPutInMapAfterClearing, true);
        }

        public static final <V> MapModification<V> add(Map<String, V> itemsToAdd) {
            return new MapModificationBase<V>((Map)itemsToAdd, false){
                private static final long serialVersionUID = 1L;

                @Override
                public Object applyToKeyInMap(MapConfigKey<V> key, Map target) {
                    return key.applyValueToMap(Jsonya.of((Map)((Map)key.rawValue(target))).add((Object)this, new Object[0]).getRootMap(), target);
                }
            };
        }
    }

    public static interface MapModification<V>
    extends StructuredConfigKey.StructuredModification<MapConfigKey<V>>,
    Map<String, V> {
    }
}

