/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.basic;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.event.AttributeSensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.management.SubscriptionHandle;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.management.TaskFactory;
import brooklyn.util.GroovyJavaMethods;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.CompoundRuntimeException;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.exceptions.NotManagedException;
import brooklyn.util.exceptions.RuntimeTimeoutException;
import brooklyn.util.guava.Functionals;
import brooklyn.util.guava.Maybe;
import brooklyn.util.task.BasicExecutionContext;
import brooklyn.util.task.BasicTask;
import brooklyn.util.task.DeferredSupplier;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.ParallelTask;
import brooklyn.util.task.TaskInternal;
import brooklyn.util.task.Tasks;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DependentConfiguration.class);

    private DependentConfiguration() {
    }

    public static <T> Task<T> attributeWhenReady(Entity source, AttributeSensor<T> sensor) {
        return DependentConfiguration.attributeWhenReady(source, sensor, GroovyJavaMethods.truthPredicate());
    }

    public static <T> Task<T> attributeWhenReady(Entity source, AttributeSensor<T> sensor, Closure<Boolean> ready) {
        Predicate readyPredicate = ready != null ? GroovyJavaMethods.predicateFromClosure(ready) : GroovyJavaMethods.truthPredicate();
        return DependentConfiguration.attributeWhenReady(source, sensor, readyPredicate);
    }

    public static <T> Task<T> attributeWhenReady(Entity source, AttributeSensor<T> sensor, Predicate<? super T> ready) {
        Builder<? super T, ? super T> builder = DependentConfiguration.builder().attributeWhenReady(source, sensor);
        if (ready != null) {
            builder.readiness(ready);
        }
        return builder.build();
    }

    public static <T, V> Task<V> attributePostProcessedWhenReady(Entity source, AttributeSensor<T> sensor, Closure<Boolean> ready, Closure<V> postProcess) {
        Predicate readyPredicate = ready != null ? GroovyJavaMethods.predicateFromClosure(ready) : GroovyJavaMethods.truthPredicate();
        Function postProcessFunction = GroovyJavaMethods.functionFromClosure(postProcess);
        return DependentConfiguration.attributePostProcessedWhenReady(source, sensor, readyPredicate, postProcessFunction);
    }

    public static <T, V> Task<V> attributePostProcessedWhenReady(Entity source, AttributeSensor<T> sensor, Closure<V> postProcess) {
        return DependentConfiguration.attributePostProcessedWhenReady(source, sensor, GroovyJavaMethods.truthPredicate(), GroovyJavaMethods.functionFromClosure(postProcess));
    }

    public static <T> Task<T> valueWhenAttributeReady(Entity source, AttributeSensor<T> sensor, T value) {
        return DependentConfiguration.attributePostProcessedWhenReady(source, sensor, GroovyJavaMethods.truthPredicate(), Functions.constant(value));
    }

    public static <T, V> Task<V> valueWhenAttributeReady(Entity source, AttributeSensor<T> sensor, Function<? super T, V> valueProvider) {
        return DependentConfiguration.attributePostProcessedWhenReady(source, sensor, GroovyJavaMethods.truthPredicate(), valueProvider);
    }

    public static <T, V> Task<V> valueWhenAttributeReady(Entity source, AttributeSensor<T> sensor, Closure<V> valueProvider) {
        return DependentConfiguration.attributePostProcessedWhenReady(source, sensor, GroovyJavaMethods.truthPredicate(), valueProvider);
    }

    public static <T, V> Task<V> attributePostProcessedWhenReady(Entity source, AttributeSensor<T> sensor, Predicate<? super T> ready, Closure<V> postProcess) {
        return DependentConfiguration.attributePostProcessedWhenReady(source, sensor, ready, GroovyJavaMethods.functionFromClosure(postProcess));
    }

    public static <T, V> Task<V> attributePostProcessedWhenReady(Entity source, AttributeSensor<T> sensor, Predicate<? super T> ready, Function<? super T, V> postProcess) {
        Builder<? super T, ? super T> builder1 = DependentConfiguration.builder().attributeWhenReady(source, sensor);
        Builder<Object, Object> builder = postProcess != null ? builder1.postProcess(postProcess) : builder1;
        if (ready != null) {
            builder.readiness(ready);
        }
        return builder.build();
    }

    public static <T> T waitInTaskForAttributeReady(Entity source, AttributeSensor<T> sensor, Predicate<? super T> ready) {
        return DependentConfiguration.waitInTaskForAttributeReady(source, sensor, ready, ImmutableList.of());
    }

    public static <T> T waitInTaskForAttributeReady(Entity source, AttributeSensor<T> sensor, Predicate<? super T> ready, List<AttributeAndSensorCondition<?>> abortConditions) {
        String blockingDetails = "Waiting for ready from " + source + " " + sensor + " (subscription)";
        return DependentConfiguration.waitInTaskForAttributeReady(source, sensor, ready, abortConditions, blockingDetails);
    }

    public static <T> T waitInTaskForAttributeReady(Entity source, AttributeSensor<T> sensor, Predicate<? super T> ready, List<AttributeAndSensorCondition<?>> abortConditions, String blockingDetails) {
        return (T)new WaitInTaskForAttributeReady(source, sensor, ready, abortConditions, blockingDetails).call();
    }

    @Deprecated
    public static <T> Task<T> whenDone(Callable<T> job) {
        return new BasicTask<T>((Map<?, ?>)MutableMap.of((Object)"tag", (Object)"whenDone", (Object)"displayName", (Object)"waiting for job"), job);
    }

    public static <U, T> Task<T> transform(Task<U> task, Function<U, T> transformer) {
        return DependentConfiguration.transform((Map)MutableMap.of((Object)"displayName", (Object)("transforming " + task)), task, transformer);
    }

    public static <U, T> Task<T> transform(Task<U> task, Closure transformer) {
        return DependentConfiguration.transform(task, GroovyJavaMethods.functionFromClosure((Closure)transformer));
    }

    public static <U, T> Task<T> transform(Map flags, final TaskAdaptable<U> task, final Function<U, T> transformer) {
        return new BasicTask(flags, new Callable<T>(){

            @Override
            public T call() throws Exception {
                if (!task.asTask().isSubmitted()) {
                    BasicExecutionContext.getCurrentExecutionContext().submit(task);
                }
                return transformer.apply(task.asTask().get());
            }
        });
    }

    public static <U, T> Task<T> transformMultiple(Function<List<U>, T> transformer, TaskAdaptable<U> ... tasks) {
        return DependentConfiguration.transformMultiple((Map)MutableMap.of((Object)"displayName", (Object)"transforming multiple"), transformer, tasks);
    }

    public static <U, T> Task<T> transformMultiple(Closure transformer, TaskAdaptable<U> ... tasks) {
        return DependentConfiguration.transformMultiple(GroovyJavaMethods.functionFromClosure((Closure)transformer), tasks);
    }

    public static <U, T> Task<T> transformMultiple(Map flags, Closure transformer, TaskAdaptable<U> ... tasks) {
        return DependentConfiguration.transformMultiple(flags, GroovyJavaMethods.functionFromClosure((Closure)transformer), tasks);
    }

    public static <U, T> Task<T> transformMultiple(Map flags, Function<List<U>, T> transformer, TaskAdaptable<U> ... tasks) {
        return DependentConfiguration.transformMultiple(flags, transformer, Arrays.asList(tasks));
    }

    public static <U, T> Task<T> transformMultiple(Map flags, final Function<List<U>, T> transformer, Collection<? extends TaskAdaptable<U>> tasks) {
        if (tasks.size() == 1) {
            return DependentConfiguration.transform(flags, (TaskAdaptable)Iterables.getOnlyElement(tasks), new Function<U, T>(){

                @Nullable
                public T apply(@Nullable U input) {
                    return transformer.apply((Object)ImmutableList.of(input));
                }
            });
        }
        return DependentConfiguration.transform(flags, new ParallelTask((Collection<? extends Object>)((Collection<Object>)tasks)), transformer);
    }

    public static Task<String> formatString(final String spec, final Object ... args) {
        ArrayList taskArgs = Lists.newArrayList();
        for (Object arg : args) {
            if (arg instanceof TaskAdaptable) {
                taskArgs.add((TaskAdaptable)arg);
                continue;
            }
            if (!(arg instanceof TaskFactory)) continue;
            taskArgs.add(((TaskFactory)arg).newTask());
        }
        return DependentConfiguration.transformMultiple((Map)MutableMap.of((Object)"displayName", (Object)("formatting '" + spec + "' with " + taskArgs.size() + " task" + (taskArgs.size() != 1 ? "s" : ""))), new Function<List<Object>, String>(){

            public String apply(List<Object> input) {
                Iterator<Object> tri = input.iterator();
                Object[] vv = new Object[args.length];
                int i = 0;
                for (Object arg : args) {
                    vv[i] = arg instanceof TaskAdaptable || arg instanceof TaskFactory ? tri.next() : (arg instanceof DeferredSupplier ? ((DeferredSupplier)arg).get() : arg);
                    ++i;
                }
                return String.format(spec, vv);
            }
        }, taskArgs);
    }

    public static <T> Task<List<T>> listAttributesWhenReady(AttributeSensor<T> sensor, Iterable<Entity> entities) {
        return DependentConfiguration.listAttributesWhenReady(sensor, entities, GroovyJavaMethods.truthPredicate());
    }

    public static <T> Task<List<T>> listAttributesWhenReady(AttributeSensor<T> sensor, Iterable<Entity> entities, Closure<Boolean> readiness) {
        Predicate readinessPredicate = readiness != null ? GroovyJavaMethods.predicateFromClosure(readiness) : GroovyJavaMethods.truthPredicate();
        return DependentConfiguration.listAttributesWhenReady(sensor, entities, readinessPredicate);
    }

    public static <T> Task<List<T>> listAttributesWhenReady(AttributeSensor<T> sensor, Iterable<Entity> entities, Predicate<? super T> readiness) {
        if (readiness == null) {
            readiness = GroovyJavaMethods.truthPredicate();
        }
        return DependentConfiguration.builder().attributeWhenReadyFromMultiple(entities, sensor, readiness).build();
    }

    public static <T> T waitForTask(Task<T> t, Entity context) throws InterruptedException {
        return DependentConfiguration.waitForTask(t, context, null);
    }

    public static <T> T waitForTask(Task<T> t, Entity context, String contextMessage) throws InterruptedException {
        try {
            return (T)Tasks.resolveValue(t, Object.class, ((EntityInternal)context).getExecutionContext(), contextMessage);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static ProtoBuilder builder() {
        return new ProtoBuilder();
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }

    @Beta
    public static class MultiBuilder<T, V, V2> {
        protected final String name;
        protected final String descriptionBase;
        protected final Builder<T, V> builder;
        protected final List<AttributeAndSensorCondition<?>> multiSource = Lists.newArrayList();
        protected Function<? super List<V>, V2> postProcessFromMultiple;

        @Beta
        protected MultiBuilder(Iterable<? extends Entity> sources, AttributeSensor<T> sensor) {
            this(sources, sensor, GroovyJavaMethods.truthPredicate());
        }

        @Beta
        protected MultiBuilder(Iterable<? extends Entity> sources, AttributeSensor<T> sensor, Predicate<? super T> readiness) {
            this.builder = new Builder(null, sensor);
            this.builder.readiness(readiness);
            for (Entity s : (Iterable)Preconditions.checkNotNull(sources, (Object)"sources")) {
                this.multiSource.add(new AttributeAndSensorCondition<T>(s, sensor, readiness));
            }
            this.name = "waiting on " + sensor.getName();
            this.descriptionBase = "waiting on " + sensor.getName() + " " + readiness + " from " + Iterables.size(sources) + " entit" + Strings.ies(sources);
        }

        public <V2b> MultiBuilder<T, V, V2b> postProcessFromMultiple(Function<? super List<V>, V2b> val) {
            this.postProcessFromMultiple = (Function)Preconditions.checkNotNull(val, (Object)"postProcessFromMulitple");
            return this;
        }

        public MultiBuilder<T, V, Boolean> postProcessFromMultiple(Predicate<? super List<V>> val) {
            return this.postProcessFromMultiple(Functions.forPredicate(val));
        }

        public <V1> MultiBuilder<T, V1, V2> postProcess(Closure<V1> val) {
            this.builder.postProcess(val);
            return this;
        }

        public <V1> MultiBuilder<T, V1, V2> postProcess(Function<? super T, V1> val) {
            this.builder.postProcess(val);
            return this;
        }

        public <T2> MultiBuilder<T, V, V2> abortIf(Entity source, AttributeSensor<T2> sensor) {
            this.builder.abortIf(source, sensor);
            return this;
        }

        public <T2> MultiBuilder<T, V, V2> abortIf(Entity source, AttributeSensor<T2> sensor, Predicate<? super T2> predicate) {
            this.builder.abortIf(source, sensor, predicate);
            return this;
        }

        public MultiBuilder<T, V, V2> abortIfOnFire() {
            this.builder.abortIfOnFire();
            return this;
        }

        public MultiBuilder<T, V, V2> blockingDetails(String val) {
            this.builder.blockingDetails(val);
            return this;
        }

        public MultiBuilder<T, V, V2> timeout(Duration val) {
            this.builder.timeout(val);
            return this;
        }

        public MultiBuilder<T, V, V2> onTimeoutReturn(V val) {
            this.builder.onTimeoutReturn(val);
            return this;
        }

        public MultiBuilder<T, V, V2> onTimeoutThrow() {
            this.builder.onTimeoutThrow();
            return this;
        }

        public MultiBuilder<T, V, V2> onUnmanagedReturn(V val) {
            this.builder.onUnmanagedReturn(val);
            return this;
        }

        public MultiBuilder<T, V, V2> onUnmanagedThrow() {
            this.builder.onUnmanagedThrow();
            return this;
        }

        public Task<V2> build() {
            MutableList tasks = MutableList.of();
            for (AttributeAndSensorCondition<?> source : this.multiSource) {
                this.builder.source(source.source);
                this.builder.sensor(source.sensor);
                this.builder.readiness(source.predicate);
                tasks.add(this.builder.build());
            }
            final Task parallelTask = Tasks.builder().parallel(true).addAll((Iterable<TaskAdaptable<?>>)tasks).name(this.name).description(this.descriptionBase + (this.builder.timeout != null ? ", timeout " + this.builder.timeout : "")).build();
            if (this.postProcessFromMultiple == null) {
                return parallelTask;
            }
            return Tasks.builder().name(this.name).description(this.descriptionBase).tag("attributeWhenReady").body(new Callable<V2>(){

                @Override
                public V2 call() throws Exception {
                    List prePostProgress = (List)DynamicTasks.queue(parallelTask).get();
                    return DynamicTasks.queue(Tasks.builder().name("post-processing").description("Applying " + MultiBuilder.this.postProcessFromMultiple).body(Functionals.callable(MultiBuilder.this.postProcessFromMultiple, (Object)prePostProgress)).build()).get();
                }
            }).build();
        }
    }

    public static class Builder<T, V> {
        protected Entity source;
        protected AttributeSensor<T> sensor;
        protected Predicate<? super T> readiness;
        protected Function<? super T, ? extends V> postProcess;
        protected List<AttributeAndSensorCondition<?>> abortSensorConditions = Lists.newArrayList();
        protected String blockingDetails;
        protected Duration timeout;
        protected Maybe<V> onTimeout;
        protected boolean ignoreUnmanaged = false;
        protected Maybe<V> onUnmanaged;

        protected Builder(Entity source, AttributeSensor<T> sensor) {
            this.source = source;
            this.sensor = sensor;
        }

        public <T2> Builder<T2, T2> attributeWhenReady(Entity source, AttributeSensor<T2> sensor) {
            this.source = (Entity)Preconditions.checkNotNull((Object)source, (Object)"source");
            this.sensor = (AttributeSensor)Preconditions.checkNotNull(sensor, (Object)"sensor");
            this.abortIfOnFire();
            return this;
        }

        public Builder<T, V> readiness(Closure<Boolean> val) {
            this.readiness = GroovyJavaMethods.predicateFromClosure((Closure)((Closure)Preconditions.checkNotNull(val, (Object)"val")));
            return this;
        }

        public Builder<T, V> readiness(Predicate<? super T> val) {
            this.readiness = (Predicate)Preconditions.checkNotNull(val, (Object)"ready");
            return this;
        }

        public <V2> Builder<T, V2> postProcess(Closure<V2> val) {
            this.postProcess = GroovyJavaMethods.functionFromClosure((Closure)((Closure)Preconditions.checkNotNull(val, (Object)"postProcess")));
            return this;
        }

        public <V2> Builder<T, V2> postProcess(Function<? super T, V2> val) {
            this.postProcess = (Function)Preconditions.checkNotNull(val, (Object)"postProcess");
            return this;
        }

        public <T2> Builder<T, V> abortIf(Entity source, AttributeSensor<T2> sensor) {
            return this.abortIf(source, sensor, GroovyJavaMethods.truthPredicate());
        }

        public <T2> Builder<T, V> abortIf(Entity source, AttributeSensor<T2> sensor, Predicate<? super T2> predicate) {
            this.abortSensorConditions.add(new AttributeAndSensorCondition<T2>(source, sensor, predicate));
            return this;
        }

        public Builder<T, V> abortIfOnFire() {
            this.abortIf(this.source, Attributes.SERVICE_STATE_ACTUAL, Predicates.equalTo((Object)((Object)Lifecycle.ON_FIRE)));
            return this;
        }

        public Builder<T, V> blockingDetails(String val) {
            this.blockingDetails = val;
            return this;
        }

        public Builder<T, V> timeout(Duration val) {
            this.timeout = val;
            return this;
        }

        public Builder<T, V> onTimeoutReturn(V val) {
            this.onTimeout = Maybe.of(val);
            return this;
        }

        public Builder<T, V> onTimeoutThrow() {
            this.onTimeout = Maybe.absent();
            return this;
        }

        public Builder<T, V> onUnmanagedReturn(V val) {
            this.onUnmanaged = Maybe.of(val);
            return this;
        }

        public Builder<T, V> onUnmanagedThrow() {
            this.onUnmanaged = Maybe.absent();
            return this;
        }

        @Deprecated
        public Builder<T, V> onUnmanagedContinue() {
            this.ignoreUnmanaged = true;
            return this;
        }

        protected Builder<T, V> source(Entity source) {
            this.source = source;
            return this;
        }

        protected Builder<T, V> sensor(AttributeSensor<? extends T> sensor) {
            this.sensor = sensor;
            return this;
        }

        public Task<V> build() {
            this.validate();
            return Tasks.builder().dynamic(false).name("waiting on " + this.sensor.getName()).description("Waiting on sensor " + this.sensor.getName() + " from " + this.source).tag("attributeWhenReady").body(new WaitInTaskForAttributeReady(this)).build();
        }

        public V runNow() {
            this.validate();
            return new WaitInTaskForAttributeReady(this).call();
        }

        private void validate() {
            Preconditions.checkNotNull((Object)this.source, (Object)"Entity source");
            Preconditions.checkNotNull(this.sensor, (Object)"Sensor");
            if (this.readiness == null) {
                this.readiness = GroovyJavaMethods.truthPredicate();
            }
            if (this.postProcess == null) {
                this.postProcess = Functions.identity();
            }
        }
    }

    @Beta
    public static class ProtoBuilder {
        public <T2> Builder<T2, T2> attributeWhenReady(Entity source, AttributeSensor<T2> sensor) {
            return new Builder(source, sensor).abortIfOnFire();
        }

        public <T2> Builder<T2, T2> attributeWhenReadyAllowingOnFire(Entity source, AttributeSensor<T2> sensor) {
            return new Builder(source, sensor);
        }

        @Beta
        public <T> MultiBuilder<T, T, List<T>> attributeWhenReadyFromMultiple(Iterable<? extends Entity> sources, AttributeSensor<T> sensor) {
            return this.attributeWhenReadyFromMultiple(sources, sensor, GroovyJavaMethods.truthPredicate());
        }

        @Beta
        public <T> MultiBuilder<T, T, List<T>> attributeWhenReadyFromMultiple(Iterable<? extends Entity> sources, AttributeSensor<T> sensor, Predicate<? super T> readiness) {
            return new MultiBuilder(sources, sensor, readiness);
        }
    }

    public static class AttributeAndSensorCondition<T> {
        protected final Entity source;
        protected final AttributeSensor<T> sensor;
        protected final Predicate<? super T> predicate;

        public AttributeAndSensorCondition(Entity source, AttributeSensor<T> sensor, Predicate<? super T> predicate) {
            this.source = (Entity)Preconditions.checkNotNull((Object)source, (Object)"source");
            this.sensor = (AttributeSensor)Preconditions.checkNotNull(sensor, (Object)"sensor");
            this.predicate = (Predicate)Preconditions.checkNotNull(predicate, (Object)"predicate");
        }
    }

    protected static class WaitInTaskForAttributeReady<T, V>
    implements Callable<V> {
        private static final boolean DEFAULT_IGNORE_UNMANAGED = false;
        protected final Entity source;
        protected final AttributeSensor<T> sensor;
        protected final Predicate<? super T> ready;
        protected final List<AttributeAndSensorCondition<?>> abortSensorConditions;
        protected final String blockingDetails;
        protected final Function<? super T, ? extends V> postProcess;
        protected final Duration timeout;
        protected final Maybe<V> onTimeout;
        protected final boolean ignoreUnmanaged;
        protected final Maybe<V> onUnmanaged;

        protected WaitInTaskForAttributeReady(Builder<T, V> builder) {
            this.source = builder.source;
            this.sensor = builder.sensor;
            this.ready = builder.readiness;
            this.abortSensorConditions = builder.abortSensorConditions;
            this.blockingDetails = builder.blockingDetails;
            this.postProcess = builder.postProcess;
            this.timeout = builder.timeout;
            this.onTimeout = builder.onTimeout;
            this.ignoreUnmanaged = builder.ignoreUnmanaged;
            this.onUnmanaged = builder.onUnmanaged;
        }

        private WaitInTaskForAttributeReady(Entity source, AttributeSensor<T> sensor, Predicate<? super T> ready, List<AttributeAndSensorCondition<?>> abortConditions, String blockingDetails) {
            this.source = source;
            this.sensor = sensor;
            this.ready = ready;
            this.abortSensorConditions = abortConditions;
            this.blockingDetails = blockingDetails;
            this.timeout = Duration.PRACTICALLY_FOREVER;
            this.onTimeout = Maybe.absent();
            this.ignoreUnmanaged = false;
            this.onUnmanaged = Maybe.absent();
            this.postProcess = null;
        }

        protected V postProcess(T value) {
            if (this.postProcess != null) {
                return (V)this.postProcess.apply(value);
            }
            return (V)value;
        }

        protected boolean ready(T value) {
            if (this.ready != null) {
                return this.ready.apply(value);
            }
            return GroovyJavaMethods.truth(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V call() {
            block39: {
                block38: {
                    block35: {
                        block36: {
                            value = this.source.getAttribute(this.sensor);
                            if (this.ready(value)) {
                                return this.postProcess(value);
                            }
                            abortionExceptions = Lists.newCopyOnWriteArrayList();
                            start = System.currentTimeMillis();
                            for (AttributeAndSensorCondition<?> abortCondition : this.abortSensorConditions) {
                                abortValue = abortCondition.source.getAttribute(abortCondition.sensor);
                                if (!abortCondition.predicate.apply(abortValue)) continue;
                                abortionExceptions.add(new Exception("Abort due to " + abortCondition.source + " -> " + abortCondition.sensor));
                            }
                            if (abortionExceptions.size() > 0) {
                                throw new CompoundRuntimeException("Aborted waiting for ready from " + this.source + " " + this.sensor, (Iterable)abortionExceptions);
                            }
                            current = (TaskInternal)Tasks.current();
                            if (current == null) {
                                throw new IllegalStateException("Should only be invoked in a running task");
                            }
                            entity = BrooklynTaskTags.getTargetOrContextEntity(current);
                            if (entity == null) {
                                throw new IllegalStateException("Should only be invoked in a running task with an entity tag; " + current + " has no entity tag (" + current.getStatusDetail(false) + ")");
                            }
                            publishedValues = new LinkedList<E>();
                            semaphore = new Semaphore(0);
                            subscription = null;
                            abortSubscriptions = Lists.newArrayList();
                            try {
                                subscription = ((EntityInternal)entity).getSubscriptionContext().subscribe(this.source, this.sensor, (SensorEventListener)new SensorEventListener<T>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void onEvent(SensorEvent<T> event) {
                                        LinkedList linkedList = publishedValues;
                                        synchronized (linkedList) {
                                            publishedValues.add(event.getValue());
                                        }
                                        semaphore.release();
                                    }
                                });
                                for (final AttributeAndSensorCondition<?> abortCondition : this.abortSensorConditions) {
                                    abortSubscriptions.add(((EntityInternal)entity).getSubscriptionContext().subscribe(abortCondition.source, abortCondition.sensor, (SensorEventListener)new SensorEventListener<Object>(){

                                        public void onEvent(SensorEvent<Object> event) {
                                            if (abortCondition.predicate.apply(event.getValue())) {
                                                abortionExceptions.add(new Exception("Abort due to " + abortCondition.source + " -> " + abortCondition.sensor));
                                                semaphore.release();
                                            }
                                        }
                                    }));
                                    abortValue = abortCondition.source.getAttribute(abortCondition.sensor);
                                    if (!abortCondition.predicate.apply(abortValue)) continue;
                                    abortionExceptions.add(new Exception("Abort due to " + abortCondition.source + " -> " + abortCondition.sensor));
                                }
                                if (abortionExceptions.size() > 0) {
                                    throw new CompoundRuntimeException("Aborted waiting for ready from " + this.source + " " + this.sensor, (Iterable)abortionExceptions);
                                }
                                timer = this.timeout != null ? this.timeout.countdownTimer() : null;
                                maxPeriod = Duration.millis((Number)200);
                                nextPeriod = Duration.millis((Number)10);
lbl39:
                                // 2 sources

                                while (!this.ready(value = this.source.getAttribute(this.sensor))) {
                                    if (timer == null) ** GOTO lbl78
                                    if (timer.getDurationRemaining().isShorterThan(nextPeriod)) {
                                        nextPeriod = timer.getDurationRemaining();
                                    }
                                    if (!timer.isExpired()) ** GOTO lbl78
                                    if (this.onTimeout.isPresent()) {
                                        var14_14 /* !! */  = this.onTimeout.get();
                                        if (subscription == null) break block35;
                                        break block36;
                                    }
                                    ** GOTO lbl-1000
                                }
                                ** GOTO lbl117
                            }
                            catch (InterruptedException e) {
                                try {
                                    throw Exceptions.propagate((Throwable)e);
                                }
                                catch (Throwable var19_21) {
                                    if (subscription != null) {
                                        ((EntityInternal)entity).getSubscriptionContext().unsubscribe(subscription);
                                    }
                                    i$ = abortSubscriptions.iterator();
                                    while (true) {
                                        if (!i$.hasNext()) {
                                            throw var19_21;
                                        }
                                        handle = (SubscriptionHandle)i$.next();
                                        ((EntityInternal)entity).getSubscriptionContext().unsubscribe(handle);
                                    }
                                }
                            }
                        }
                        ((EntityInternal)entity).getSubscriptionContext().unsubscribe(subscription);
                    }
                    i$ = abortSubscriptions.iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                            return var14_14 /* !! */ ;
                        }
                        handle = (SubscriptionHandle)i$.next();
                        ((EntityInternal)entity).getSubscriptionContext().unsubscribe(handle);
                    }
lbl-1000:
                    // 1 sources

                    {
                        throw new RuntimeTimeoutException("Unsatisfied after " + Duration.sinceUtc((long)start));
lbl78:
                        // 2 sources

                        prevBlockingDetails = current.setBlockingDetails(this.blockingDetails);
                        try {
                            if (semaphore.tryAcquire(nextPeriod.toMilliseconds(), TimeUnit.MILLISECONDS)) {
                                semaphore.release();
                                semaphore.drainPermits();
                            }
                        }
                        finally {
                            current.setBlockingDetails(prevBlockingDetails);
                        }
                        do {
                            i$ = publishedValues;
                            synchronized (i$) {
                                if (publishedValues.isEmpty()) {
                                    break;
                                }
                                value = publishedValues.pop();
                            }
                        } while (!this.ready(value));
                        if (this.ignoreUnmanaged || !Entities.isNoLongerManaged(entity)) ** GOTO lbl113
                        if (!this.onUnmanaged.isPresent()) ** GOTO lbl-1000
                        i$ = this.onUnmanaged.get();
                        if (subscription == null) break block38;
                    }
                    ((EntityInternal)entity).getSubscriptionContext().unsubscribe(subscription);
                }
                i$ = abortSubscriptions.iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        return (V)i$;
                    }
                    handle = (SubscriptionHandle)i$.next();
                    ((EntityInternal)entity).getSubscriptionContext().unsubscribe(handle);
                }
lbl-1000:
                // 1 sources

                {
                    throw new NotManagedException((Object)entity);
lbl113:
                    // 1 sources

                    if (abortionExceptions.size() > 0) {
                        throw new CompoundRuntimeException("Aborted waiting for ready from " + this.source + " " + this.sensor, (Iterable)abortionExceptions);
                    }
                    nextPeriod = nextPeriod.times(2L).upperBound(maxPeriod);
                    ** GOTO lbl39
lbl117:
                    // 1 sources

                    if (DependentConfiguration.access$100().isDebugEnabled()) {
                        DependentConfiguration.access$100().debug("Attribute-ready for {} in entity {}", this.sensor, (Object)this.source);
                    }
                    var14_14 /* !! */  = this.postProcess(value);
                    if (subscription == null) break block39;
                }
                ((EntityInternal)entity).getSubscriptionContext().unsubscribe(subscription);
            }
            i$ = abortSubscriptions.iterator();
            while (true) {
                if (!i$.hasNext()) {
                    return var14_14 /* !! */ ;
                }
                handle = (SubscriptionHandle)i$.next();
                ((EntityInternal)entity).getSubscriptionContext().unsubscribe(handle);
            }
        }
    }
}

