/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.basic;

import brooklyn.config.ConfigInheritance;
import brooklyn.config.ConfigKey;
import brooklyn.management.ExecutionContext;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.TypeTokens;
import brooklyn.util.internal.ConfigKeySelfExtracting;
import brooklyn.util.task.Tasks;
import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicConfigKey<T>
implements ConfigKeySelfExtracting<T>,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(BasicConfigKey.class);
    private static final long serialVersionUID = -1762014059150215376L;
    private static final Splitter dots = Splitter.on((char)'.');
    private String name;
    private TypeToken<T> typeToken;
    private Class<? super T> type;
    private String description;
    private T defaultValue;
    private boolean reconfigurable;
    private ConfigInheritance inheritance;

    public static <T> Builder<T> builder(TypeToken<T> type) {
        return new Builder<T>().type(type);
    }

    public static <T> Builder<T> builder(Class<T> type) {
        return new Builder<T>().type(type);
    }

    public static <T> Builder<T> builder(TypeToken<T> type, String name) {
        return new Builder<T>().type(type).name(name);
    }

    public static <T> Builder<T> builder(Class<T> type, String name) {
        return new Builder<T>().type(type).name(name);
    }

    public static <T> Builder<T> builder(ConfigKey<T> key) {
        return new Builder().name((String)Preconditions.checkNotNull((Object)key.getName(), (Object)"name")).type((TypeToken)Preconditions.checkNotNull((Object)key.getTypeToken(), (Object)"type")).description(key.getDescription()).defaultValue(key.getDefaultValue()).reconfigurable(key.isReconfigurable()).inheritance(key.getInheritance());
    }

    public BasicConfigKey() {
    }

    public BasicConfigKey(Class<T> type, String name) {
        this(TypeToken.of(type), name);
    }

    public BasicConfigKey(Class<T> type, String name, String description) {
        this(TypeToken.of(type), name, description);
    }

    public BasicConfigKey(Class<T> type, String name, String description, T defaultValue) {
        this(TypeToken.of(type), name, description, defaultValue);
    }

    public BasicConfigKey(TypeToken<T> type, String name) {
        this(type, name, name, null);
    }

    public BasicConfigKey(TypeToken<T> type, String name, String description) {
        this(type, name, description, null);
    }

    public BasicConfigKey(TypeToken<T> type, String name, String description, T defaultValue) {
        this.description = description;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.type = TypeTokens.getRawTypeIfRaw((TypeToken)((TypeToken)Preconditions.checkNotNull(type, (Object)"type")));
        this.typeToken = TypeTokens.getTypeTokenIfNotRaw(type);
        this.defaultValue = defaultValue;
        this.reconfigurable = false;
    }

    protected BasicConfigKey(Builder<T> builder) {
        this.name = (String)Preconditions.checkNotNull((Object)((Builder)builder).name, (Object)"name");
        this.type = TypeTokens.getRawTypeIfRaw((TypeToken)((TypeToken)Preconditions.checkNotNull((Object)((Builder)builder).type, (Object)"type")));
        this.typeToken = TypeTokens.getTypeTokenIfNotRaw((TypeToken)((Builder)builder).type);
        this.description = ((Builder)builder).description;
        this.defaultValue = ((Builder)builder).defaultValue;
        this.reconfigurable = ((Builder)builder).reconfigurable;
        this.inheritance = ((Builder)builder).inheritance;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.getType().getName();
    }

    public Class<? super T> getType() {
        return TypeTokens.getRawType(this.typeToken, this.type);
    }

    public TypeToken<T> getTypeToken() {
        return TypeTokens.getTypeToken(this.typeToken, this.type);
    }

    public String getDescription() {
        return this.description;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean isReconfigurable() {
        return this.reconfigurable;
    }

    @Nullable
    public ConfigInheritance getInheritance() {
        return this.inheritance;
    }

    public Collection<String> getNameParts() {
        return Lists.newArrayList((Iterable)dots.split((CharSequence)this.name));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BasicConfigKey)) {
            return false;
        }
        BasicConfigKey o = (BasicConfigKey)obj;
        return Objects.equal((Object)this.name, (Object)o.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public String toString() {
        return String.format("%s[ConfigKey:%s]", this.name, this.getTypeName());
    }

    @Override
    public T extractValue(Map<?, ?> vals, ExecutionContext exec) {
        Object v = vals.get(this);
        try {
            return (T)this.resolveValue(v, exec);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public boolean isSet(Map<?, ?> vals) {
        return vals.containsKey(this);
    }

    protected Object resolveValue(Object v, ExecutionContext exec) throws ExecutionException, InterruptedException {
        if (v instanceof Collection || v instanceof Map) {
            return Tasks.resolveDeepValue(v, Object.class, exec, "config " + this.name);
        }
        return Tasks.resolveValue(v, this.getType(), exec, "config " + this.name);
    }

    public static class BasicConfigKeyOverwriting<T>
    extends BasicConfigKey<T> {
        private static final long serialVersionUID = -3458116971918128018L;
        private final ConfigKey<T> parentKey;

        @Beta
        public BasicConfigKeyOverwriting(Builder<T> builder, ConfigKey<T> parent) {
            super(builder);
            this.parentKey = parent;
            Preconditions.checkArgument((boolean)Objects.equal((Object)((Builder)builder).name, (Object)parent.getName()), (Object)"Builder must use key of the same name.");
        }

        public BasicConfigKeyOverwriting(ConfigKey<T> key, T defaultValue) {
            this(BasicConfigKeyOverwriting.builder(key).defaultValue(defaultValue), key);
        }

        public BasicConfigKeyOverwriting(ConfigKey<T> key, String newDescription, T defaultValue) {
            this(BasicConfigKeyOverwriting.builder(key).description(newDescription).defaultValue(defaultValue), key);
        }

        public ConfigKey<T> getParentKey() {
            return this.parentKey;
        }
    }

    public static class Builder<T> {
        private String name;
        private TypeToken<T> type;
        private String description;
        private T defaultValue;
        private boolean reconfigurable;
        private ConfigInheritance inheritance;

        public Builder<T> name(String val) {
            this.name = val;
            return this;
        }

        public Builder<T> type(Class<T> val) {
            this.type = TypeToken.of(val);
            return this;
        }

        public Builder<T> type(TypeToken<T> val) {
            this.type = val;
            return this;
        }

        public Builder<T> description(String val) {
            this.description = val;
            return this;
        }

        public Builder<T> defaultValue(T val) {
            this.defaultValue = val;
            return this;
        }

        public Builder<T> reconfigurable(boolean val) {
            this.reconfigurable = val;
            return this;
        }

        public Builder<T> inheritance(ConfigInheritance val) {
            this.inheritance = val;
            return this;
        }

        public BasicConfigKey<T> build() {
            return new BasicConfigKey(this);
        }
    }
}

