/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.basic;

import brooklyn.config.ConfigKey;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.event.basic.StructuredConfigKey;
import brooklyn.event.basic.SubElementConfigKey;
import brooklyn.management.ExecutionContext;
import brooklyn.util.exceptions.Exceptions;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public abstract class AbstractStructuredConfigKey<T, RawT, V>
extends BasicConfigKey<T>
implements StructuredConfigKey {
    private static final long serialVersionUID = 7806267541029428561L;
    public final Class<V> subType;

    public AbstractStructuredConfigKey(Class<T> type, Class<V> subType, String name, String description, T defaultValue) {
        super(type, name, description, defaultValue);
        this.subType = subType;
    }

    protected ConfigKey<V> subKey(String subName) {
        return this.subKey(subName, "sub-element of " + this.getName() + ", named " + subName);
    }

    protected ConfigKey<V> subKey(String subName, String description) {
        return new SubElementConfigKey<Object>(this, this.subType, this.getName() + "." + subName, description, null);
    }

    protected static String getKeyName(Object contender) {
        if (contender == null) {
            return null;
        }
        if (contender instanceof ConfigKey) {
            return ((ConfigKey)contender).getName();
        }
        return contender.toString();
    }

    @Override
    public boolean acceptsKeyMatch(Object contender) {
        return this.getName().equalsIgnoreCase(AbstractStructuredConfigKey.getKeyName(contender));
    }

    @Override
    public boolean acceptsSubkey(Object contender) {
        return contender != null && AbstractStructuredConfigKey.getKeyName(contender).startsWith(this.getName() + ".");
    }

    public String extractSubKeyName(Object o) {
        String name = AbstractStructuredConfigKey.getKeyName(o);
        assert (name.startsWith(this.getName() + "."));
        return name.substring(this.getName().length() + 1);
    }

    @Override
    public boolean acceptsSubkeyStronglyTyped(Object contender) {
        return contender instanceof SubElementConfigKey && this.acceptsKeyMatch(((SubElementConfigKey)contender).parent);
    }

    @Override
    public boolean isSet(Map<?, ?> vals) {
        if (vals.containsKey(this)) {
            return true;
        }
        for (Object contender : vals.keySet()) {
            if (!this.acceptsKeyMatch(contender) && !this.acceptsSubkey(contender)) continue;
            return true;
        }
        return false;
    }

    protected RawT extractValue(Map<?, ?> vals, ExecutionContext exec, boolean coerce, boolean unmodifiable) {
        RawT base = null;
        LinkedHashMap subkeys = Maps.newLinkedHashMap();
        for (Map.Entry<?, ?> entry : vals.entrySet()) {
            Object value;
            Object k = entry.getKey();
            if (this.acceptsKeyMatch(k)) {
                try {
                    base = this.extractValueMatchingThisKey(entry.getValue(), exec, coerce);
                }
                catch (Exception e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            if (!this.acceptsSubkey(k)) continue;
            String subKeyName = this.extractSubKeyName(k);
            if (coerce) {
                SubElementConfigKey kk = k instanceof SubElementConfigKey ? (SubElementConfigKey)k : (SubElementConfigKey)this.subKey(subKeyName);
                value = kk.extractValue((Map)vals, exec);
            } else {
                value = vals.get(k);
            }
            subkeys.put(subKeyName, value);
        }
        return this.merge(base, subkeys, unmodifiable);
    }

    @Override
    public T extractValue(Map<?, ?> vals, ExecutionContext exec) {
        return (T)this.extractValue(vals, exec, true, true);
    }

    public RawT rawValue(Map<?, ?> vals) {
        return this.extractValue(vals, null, false, false);
    }

    protected abstract RawT extractValueMatchingThisKey(Object var1, ExecutionContext var2, boolean var3) throws InterruptedException, ExecutionException;

    protected abstract RawT merge(RawT var1, Map<String, Object> var2, boolean var3);
}

