/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.basic;

import brooklyn.config.ConfigKey;
import brooklyn.event.basic.AbstractStructuredConfigKey;
import brooklyn.event.basic.StructuredConfigKey;
import brooklyn.event.basic.SubElementConfigKey;
import brooklyn.management.ExecutionContext;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.text.Identifiers;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCollectionConfigKey<T, RawT extends Collection<Object>, V>
extends AbstractStructuredConfigKey<T, RawT, V> {
    private static final long serialVersionUID = 8225955960120637643L;
    private static final Logger log = LoggerFactory.getLogger(AbstractCollectionConfigKey.class);

    public AbstractCollectionConfigKey(Class<T> type, Class<V> subType, String name, String description, T defaultValue) {
        super(type, subType, name, description, defaultValue);
    }

    public ConfigKey<V> subKey() {
        String subName = Identifiers.makeRandomId((int)8);
        return new SubElementConfigKey<Object>(this, this.subType, this.getName() + "." + subName, "element of " + this.getName() + ", uid " + subName, null);
    }

    protected abstract RawT merge(boolean var1, Iterable<?> ... var2);

    @Override
    protected RawT merge(RawT base, Map<String, Object> subkeys, boolean unmodifiable) {
        return this.merge(unmodifiable, new Iterable[]{base, subkeys.values()});
    }

    @Override
    protected RawT extractValueMatchingThisKey(Object potentialBase, ExecutionContext exec, boolean coerce) throws InterruptedException, ExecutionException {
        if (coerce) {
            potentialBase = this.resolveValue(potentialBase, exec);
        }
        if (potentialBase == null) {
            return null;
        }
        if (potentialBase instanceof Map) {
            return this.merge(false, ((Map)potentialBase).values());
        }
        if (potentialBase instanceof Collection) {
            return this.merge(false, (Collection)potentialBase);
        }
        log.warn("Unable to extract " + this.getName() + " as Collection; it is " + potentialBase.getClass().getName() + " " + potentialBase);
        return null;
    }

    @Override
    public Object applyValueToMap(Object value, Map target) {
        return this.applyValueToMap(value, target, false);
    }

    protected Object applyValueToMap(Object value, Map target, boolean isInCollection) {
        if (value instanceof StructuredConfigKey.StructuredModification) {
            return ((StructuredConfigKey.StructuredModification)value).applyToKeyInMap(this, target);
        }
        if (value instanceof Iterable && !isInCollection) {
            boolean isSet = this.isSet(target);
            if (isSet) {
                String warning = "Discouraged undecorated setting of a collection to in-use StructuredConfigKey " + this + ": use SetModification.{set,add}. " + "Defaulting to 'add'. Look at debug logging for call stack.";
                log.warn(warning);
                if (log.isDebugEnabled()) {
                    log.debug("Trace for: " + warning, new Throwable("Trace for: " + warning));
                }
            }
            Iterable valueI = (Iterable)value;
            for (Object v : valueI) {
                this.applyValueToMap(v, target, true);
            }
            if (Iterables.isEmpty((Iterable)valueI) && !isSet) {
                target.put(this, MutableSet.of());
            }
            return null;
        }
        if (value instanceof TaskAdaptable) {
            boolean isSet = this.isSet(target);
            if (isSet) {
                String warning = "Discouraged undecorated setting of a task to in-use StructuredConfigKey " + this + ": use SetModification.{set,add}. " + "Defaulting to 'add'. Look at debug logging for call stack.";
                log.warn(warning);
                if (log.isDebugEnabled()) {
                    log.debug("Trace for: " + warning, new Throwable("Trace for: " + warning));
                }
            }
            target.put(this.subKey(), value);
            return null;
        }
        target.put(this.subKey(), value);
        return null;
    }
}

