/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.trait;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.effector.Effectors;
import brooklyn.entity.trait.Startable;
import brooklyn.location.Location;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.CompoundRuntimeException;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.TaskTags;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartableMethods {
    public static final Logger log = LoggerFactory.getLogger(StartableMethods.class);

    private StartableMethods() {
    }

    public static void start(EntityLocal e, Collection<? extends Location> locations) {
        log.debug("Starting entity " + e + " at " + locations);
        DynamicTasks.queueIfPossible(StartableMethods.startingChildren((Entity)e, locations)).orSubmitAsync((Entity)e).getTask().getUnchecked();
    }

    public static void stop(EntityLocal e) {
        log.debug("Stopping entity " + e);
        DynamicTasks.queueIfPossible(StartableMethods.stoppingChildren((Entity)e)).orSubmitAsync((Entity)e).getTask().getUnchecked();
        if (log.isDebugEnabled()) {
            log.debug("Stopped entity " + e);
        }
    }

    public static void restart(EntityLocal e) {
        log.debug("Restarting entity " + e);
        DynamicTasks.queueIfPossible(StartableMethods.restartingChildren((Entity)e)).orSubmitAsync((Entity)e).getTask().getUnchecked();
        if (log.isDebugEnabled()) {
            log.debug("Restarted entity " + e);
        }
    }

    /*
     * Exception decompiling
     */
    private static <T extends Entity> Iterable<T> filterStartableManagedEntities(Iterable<T> contenders) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void stopSequentially(Iterable<? extends Startable> entities) {
        ArrayList exceptions = Lists.newArrayList();
        ArrayList failedEntities = Lists.newArrayList();
        for (Startable startable : entities) {
            if (!Entities.isManaged((Entity)startable)) {
                log.debug("Not stopping {} because it is not managed; continuing", (Object)startable);
                continue;
            }
            try {
                TaskAdaptable<Void> task = TaskTags.markInessential(Effectors.invocation((Entity)startable, Startable.STOP, Collections.emptyMap()));
                DynamicTasks.submit(task, (Entity)startable).getUnchecked();
            }
            catch (Exception e) {
                log.warn("Error stopping " + startable + "; continuing with shutdown", (Throwable)e);
                exceptions.add(e);
                failedEntities.add(startable);
            }
        }
        if (exceptions.size() > 0) {
            throw new CompoundRuntimeException("Error stopping " + (failedEntities.size() > 1 ? "entities" : "entity") + ": " + failedEntities, (Iterable)exceptions);
        }
    }

    public static TaskAdaptable<?> startingChildren(Entity entity) {
        return StartableMethods.startingChildren(entity, entity.getLocations());
    }

    public static TaskAdaptable<?> startingChildren(Entity entity, Location location) {
        return StartableMethods.startingChildren(entity, Collections.singleton(location));
    }

    public static TaskAdaptable<?> startingChildren(Entity entity, Iterable<? extends Location> locations) {
        return Effectors.invocation(Startable.START, MutableMap.of((Object)"locations", locations), StartableMethods.filterStartableManagedEntities(entity.getChildren()));
    }

    public static TaskAdaptable<?> stoppingChildren(Entity entity) {
        return Effectors.invocation(Startable.STOP, Collections.emptyMap(), StartableMethods.filterStartableManagedEntities(entity.getChildren()));
    }

    public static TaskAdaptable<?> restartingChildren(Entity entity, ConfigBag parameters) {
        return Effectors.invocation(Startable.RESTART, parameters.getAllConfig(), StartableMethods.filterStartableManagedEntities(entity.getChildren()));
    }

    public static TaskAdaptable<?> restartingChildren(Entity entity) {
        return StartableMethods.restartingChildren(entity, ConfigBag.EMPTY);
    }
}

