/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.trait;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.annotation.EffectorParam;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.MethodEffector;
import brooklyn.entity.effector.EffectorBody;
import brooklyn.entity.effector.Effectors;
import brooklyn.event.AttributeSensor;
import brooklyn.location.Location;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.task.Tasks;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Startable {
    public static final AttributeSensor<Boolean> SERVICE_UP = Attributes.SERVICE_UP;
    public static final Effector<Void> START = Effectors.effector(new MethodEffector(Startable.class, "start")).parameter(StartEffectorBody.LOCATIONS).impl(new StartEffectorBody()).build();
    public static final Effector<Void> STOP = Effectors.effector(new MethodEffector(Startable.class, "stop")).impl(new StopEffectorBody()).build();
    public static final Effector<Void> RESTART = Effectors.effector(new MethodEffector(Startable.class, "restart")).impl(new RestartEffectorBody()).build();

    @brooklyn.entity.annotation.Effector(description="Start the process/service represented by an entity")
    public void start(@EffectorParam(name="locations") Collection<? extends Location> var1);

    @brooklyn.entity.annotation.Effector(description="Stop the process/service represented by an entity")
    public void stop();

    @brooklyn.entity.annotation.Effector(description="Restart the process/service represented by an entity")
    public void restart();

    public static class RestartEffectorBody
    extends EffectorBody<Void> {
        private static final Logger log = LoggerFactory.getLogger(Startable.class);

        @Override
        public Void call(ConfigBag parameters) {
            if (!parameters.isEmpty()) {
                log.warn("Parameters " + parameters + " not supported for call to " + this.entity() + " - " + Tasks.current());
            }
            return (Void)new MethodEffector(Startable.class, "restart").call((Entity)this.entity(), parameters.getAllConfig());
        }
    }

    public static class StopEffectorBody
    extends EffectorBody<Void> {
        private static final Logger log = LoggerFactory.getLogger(Startable.class);

        @Override
        public Void call(ConfigBag parameters) {
            if (!parameters.isEmpty()) {
                log.warn("Parameters " + parameters + " not supported for call to " + this.entity() + " - " + Tasks.current());
            }
            return (Void)new MethodEffector(Startable.class, "stop").call((Entity)this.entity(), parameters.getAllConfig());
        }
    }

    public static class StartEffectorBody
    extends EffectorBody<Void> {
        public static final ConfigKey<Object> LOCATIONS = ConfigKeys.newConfigKey(Object.class, "locations", "The location or locations to start in, as a string, a location object, a list of strings, or a list of location objects");

        @Override
        public Void call(ConfigBag parameters) {
            parameters.put(LOCATIONS, this.entity().getManagementContext().getLocationRegistry().resolveList(parameters.get(LOCATIONS)));
            return (Void)new MethodEffector(Startable.class, "start").call((Entity)this.entity(), parameters.getAllConfig());
        }
    }
}

