/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.transformer.impl;

import brooklyn.entity.rebind.transformer.RawDataTransformer;
import com.google.common.annotations.Beta;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

@Beta
public class XsltTransformer
implements RawDataTransformer {
    private final TransformerFactory factory = TransformerFactory.newInstance();
    private final String xsltContent;

    public XsltTransformer(String xsltContent) {
        this.xsltContent = xsltContent;
    }

    @Override
    public String transform(String input) throws IOException, URISyntaxException, TransformerException {
        StreamSource xslt = new StreamSource(new ByteArrayInputStream(this.xsltContent.getBytes()));
        Transformer transformer = this.factory.newTransformer(xslt);
        StreamSource text = new StreamSource(new ByteArrayInputStream(input.getBytes()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(input.length());
        transformer.transform(text, new StreamResult(baos));
        return new String(baos.toByteArray());
    }
}

