/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.transformer.impl;

import brooklyn.entity.rebind.dto.BrooklynMementoImpl;
import brooklyn.entity.rebind.transformer.BrooklynMementoTransformer;
import brooklyn.mementos.BrooklynMemento;
import brooklyn.mementos.EntityMemento;
import brooklyn.mementos.LocationMemento;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Beta
public class DeleteOrphanedLocationsTransformer
implements BrooklynMementoTransformer {
    @Override
    public BrooklynMemento transform(BrooklynMemento input) throws Exception {
        Set<String> referencedLocationIds = this.findReferencedLocationIds(input);
        LinkedHashSet unreferencedLocationIds = Sets.newLinkedHashSet();
        LinkedList toCheck = Lists.newLinkedList((Iterable)input.getLocationIds());
        while (!toCheck.isEmpty()) {
            String locationId = (String)toCheck.remove(0);
            MutableList locationsInHierarchy = MutableList.builder().add((Object)locationId).addAll(this.findLocationAncestors(input, locationId)).addAll(this.findLocationDescendents(input, locationId)).build();
            if (!this.containsAny((Collection<?>)referencedLocationIds, (Iterable<?>)locationsInHierarchy)) {
                unreferencedLocationIds.addAll(locationsInHierarchy);
            }
            toCheck.removeAll((Collection<?>)locationsInHierarchy);
        }
        return BrooklynMementoImpl.builder().applicationIds(input.getApplicationIds()).topLevelLocationIds((Collection<String>)MutableSet.builder().addAll((Iterable)input.getTopLevelLocationIds()).removeAll((Iterable)unreferencedLocationIds).build()).entities(input.getEntityMementos()).locations((Map<String, LocationMemento>)MutableMap.builder().putAll(input.getLocationMementos()).removeAll((Iterable)unreferencedLocationIds).build()).policies(input.getPolicyMementos()).enrichers(input.getEnricherMementos()).catalogItems(input.getCatalogItemMementos()).build();
    }

    public boolean containsAny(Collection<?> container, Iterable<?> contenders) {
        for (Object contender : contenders) {
            if (!container.contains(contender)) continue;
            return true;
        }
        return false;
    }

    public Set<String> findReferencedLocationIds(BrooklynMemento input) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (EntityMemento entity : input.getEntityMementos().values()) {
            result.addAll(entity.getLocations());
        }
        return result;
    }

    public Set<String> findLocationAncestors(BrooklynMemento input, String locationId) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        String parentId = null;
        do {
            LocationMemento memento;
            if ((parentId = (memento = input.getLocationMemento(locationId)).getParent()) == null) continue;
            result.add(parentId);
        } while (parentId != null);
        return result;
    }

    public Set<String> findLocationDescendents(BrooklynMemento input, String locationId) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        LinkedList tovisit = Lists.newLinkedList();
        tovisit.add(locationId);
        while (!tovisit.isEmpty()) {
            LocationMemento memento = input.getLocationMemento((String)tovisit.remove(0));
            List children = memento.getChildren();
            result.addAll(children);
            tovisit.addAll(children);
        }
        return result;
    }
}

