/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.transformer;

import brooklyn.entity.rebind.transformer.CompoundTransformer;
import brooklyn.entity.rebind.transformer.RawDataTransformer;
import brooklyn.util.ResourceUtils;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.text.TemplateProcessor;
import brooklyn.util.yaml.Yamls;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class CompoundTransformerLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CompoundTransformerLoader.class);

    public static CompoundTransformer load(String contents) {
        CompoundTransformer.Builder builder = CompoundTransformer.builder();
        Iterable toplevel = Yamls.parseAll((String)contents);
        Collection rules = (Collection)Iterables.getOnlyElement((Iterable)toplevel);
        for (Object obj : rules) {
            Map map = (Map)obj;
            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(map.entrySet());
            CompoundTransformerLoader.addRule(builder, (String)entry.getKey(), (Map)entry.getValue());
        }
        LOG.info("Loaded " + rules.size() + " transforms");
        return builder.build();
    }

    private static void addRule(CompoundTransformer.Builder builder, String name, Map<?, ?> args) {
        if (name.equals("renameClass")) {
            String oldVal = (String)args.get("old_val");
            String newVal = (String)args.get("new_val");
            builder.renameClass(oldVal, newVal);
        } else if (name.equals("renameClassTag")) {
            String oldVal = (String)args.get("old_val");
            String newVal = (String)args.get("new_val");
            builder.renameClassTag(oldVal, newVal);
        } else if (name.equals("renameType")) {
            String oldVal = (String)args.get("old_val");
            String newVal = (String)args.get("new_val");
            builder.renameType(oldVal, newVal);
        } else if (name.equals("renameField")) {
            String clazz = (String)args.get("class_name");
            String oldVal = (String)args.get("old_val");
            String newVal = (String)args.get("new_val");
            builder.renameField(clazz, oldVal, newVal);
        } else if (name.equals("catalogItemId")) {
            builder.changeCatalogItemId((String)args.get("old_symbolic_name"), CompoundTransformerLoader.checkString(args.get("old_version"), "old_version"), (String)args.get("new_symbolic_name"), CompoundTransformerLoader.checkString(args.get("new_version"), "new_version"));
        } else if (name.equals("xslt")) {
            String url = (String)args.get("url");
            Map substitutions = (Map)args.get("substitutions");
            String xsltTemplate = ResourceUtils.create(CompoundTransformer.class).getResourceAsString(url);
            String xslt = TemplateProcessor.processTemplateContents(xsltTemplate, (Map<String, ? extends Object>)(substitutions == null ? ImmutableMap.of() : substitutions));
            builder.xsltTransformer(xslt);
        } else if (name.equals("rawDataTransformer")) {
            String type = (String)args.get("type");
            try {
                Class<?> clazz = CompoundTransformerLoader.class.getClassLoader().loadClass(type);
                builder.rawDataTransformer((RawDataTransformer)clazz.newInstance());
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        } else {
            throw new IllegalStateException("Unsupported transform '" + name + "' (" + args + ")");
        }
    }

    private static String checkString(Object object, String name) {
        if (object != null && !(object instanceof String)) {
            throw new IllegalArgumentException("Argument '" + name + "' must be a string; numbers may need explicit quoting in YAML.");
        }
        return (String)object;
    }
}

