/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.transformer;

import brooklyn.entity.rebind.BrooklynObjectType;
import brooklyn.entity.rebind.RebindExceptionHandler;
import brooklyn.entity.rebind.persister.BrooklynMementoPersisterToObjectStore;
import brooklyn.entity.rebind.transformer.RawDataTransformer;
import brooklyn.entity.rebind.transformer.impl.XsltTransformer;
import brooklyn.mementos.BrooklynMementoRawData;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.text.Strings;
import brooklyn.util.text.TemplateProcessor;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;

@Beta
public class CompoundTransformer {
    public static final CompoundTransformer NOOP = CompoundTransformer.builder().build();
    private final Multimap<BrooklynObjectType, RawDataTransformer> rawDataTransformers;

    public static Builder builder() {
        return new Builder();
    }

    protected CompoundTransformer(Builder builder) {
        this.rawDataTransformers = builder.rawDataTransformers;
    }

    public BrooklynMementoRawData transform(BrooklynMementoPersisterToObjectStore reader, RebindExceptionHandler exceptionHandler) throws Exception {
        BrooklynMementoRawData rawData = reader.loadMementoRawData(exceptionHandler);
        return this.transform(rawData);
    }

    public BrooklynMementoRawData transform(BrooklynMementoRawData rawData) throws Exception {
        MutableMap entities = MutableMap.copyOf((Map)rawData.getEntities());
        MutableMap locations = MutableMap.copyOf((Map)rawData.getLocations());
        MutableMap policies = MutableMap.copyOf((Map)rawData.getPolicies());
        MutableMap enrichers = MutableMap.copyOf((Map)rawData.getEnrichers());
        MutableMap feeds = MutableMap.copyOf((Map)rawData.getFeeds());
        MutableMap catalogItems = MutableMap.copyOf((Map)rawData.getCatalogItems());
        for (BrooklynObjectType type : BrooklynObjectType.values()) {
            Collection transformers = this.rawDataTransformers.get((Object)type);
            block10: for (RawDataTransformer transformer : transformers) {
                switch (type) {
                    case ENTITY: {
                        for (Map.Entry entry : entities.entrySet()) {
                            entry.setValue(transformer.transform((String)entry.getValue()));
                        }
                        continue block10;
                    }
                    case LOCATION: {
                        for (Map.Entry entry : locations.entrySet()) {
                            entry.setValue(transformer.transform((String)entry.getValue()));
                        }
                        continue block10;
                    }
                    case POLICY: {
                        for (Map.Entry entry : policies.entrySet()) {
                            entry.setValue(transformer.transform((String)entry.getValue()));
                        }
                        continue block10;
                    }
                    case ENRICHER: {
                        for (Map.Entry entry : enrichers.entrySet()) {
                            entry.setValue(transformer.transform((String)entry.getValue()));
                        }
                        continue block10;
                    }
                    case FEED: {
                        for (Map.Entry entry : feeds.entrySet()) {
                            entry.setValue(transformer.transform((String)entry.getValue()));
                        }
                        continue block10;
                    }
                    case CATALOG_ITEM: {
                        for (Map.Entry entry : catalogItems.entrySet()) {
                            entry.setValue(transformer.transform((String)entry.getValue()));
                        }
                        continue block10;
                    }
                    case UNKNOWN: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected brooklyn object type " + type);
                    }
                }
            }
        }
        return BrooklynMementoRawData.builder().entities((Map)entities).locations((Map)locations).policies((Map)policies).enrichers((Map)enrichers).feeds((Map)feeds).catalogItems((Map)catalogItems).build();
    }

    @VisibleForTesting
    Multimap<BrooklynObjectType, RawDataTransformer> getRawDataTransformers() {
        return ArrayListMultimap.create(this.rawDataTransformers);
    }

    public static class Builder {
        private final Multimap<BrooklynObjectType, RawDataTransformer> rawDataTransformers = ArrayListMultimap.create();

        public Builder rawDataTransformer(RawDataTransformer val) {
            for (BrooklynObjectType type : BrooklynObjectType.values()) {
                this.rawDataTransformer(type, val);
            }
            return this;
        }

        public Builder rawDataTransformer(BrooklynObjectType type, RawDataTransformer val) {
            this.rawDataTransformers.put(Preconditions.checkNotNull((Object)type, (Object)"type"), Preconditions.checkNotNull((Object)val, (Object)"val"));
            return this;
        }

        public Builder xsltTransformer(String xslt) {
            XsltTransformer xsltTransformer = new XsltTransformer(xslt);
            for (BrooklynObjectType type : BrooklynObjectType.values()) {
                this.rawDataTransformer(type, xsltTransformer);
            }
            return this;
        }

        public Builder xsltTransformer(BrooklynObjectType type, String xslt) {
            XsltTransformer xsltTransformer = new XsltTransformer(xslt);
            this.rawDataTransformer(type, xsltTransformer);
            return this;
        }

        protected Builder xsltTransformerFromXsltFreemarkerTemplateUrl(String templateUrl, Map<String, String> vars) {
            String xsltTemplate = ResourceUtils.create(this).getResourceAsString(templateUrl);
            String xslt = TemplateProcessor.processTemplateContents(xsltTemplate, vars);
            return this.xsltTransformer(xslt);
        }

        protected Builder xsltTransformerRecursiveCopyWithExtraRules(String ... rules) {
            String xsltTemplate = ResourceUtils.create(this).getResourceAsString("classpath://brooklyn/entity/rebind/transformer/recursiveCopyWithExtraRules.xslt");
            String xslt = TemplateProcessor.processTemplateContents(xsltTemplate, (Map<String, ? extends Object>)ImmutableMap.of((Object)"extra_rules", (Object)Strings.join((Object[])rules, (String)"\n")));
            return this.xsltTransformer(xslt);
        }

        public Builder xmlReplaceItem(String xpathToMatch, String newValue) {
            return this.xsltTransformerRecursiveCopyWithExtraRules("<xsl:template match=\"" + xpathToMatch + "\">" + newValue + "</xsl:template>");
        }

        public Builder xmlRenameTag(String xpathToMatch, String newValue) {
            return this.xmlReplaceItem(xpathToMatch, "<" + newValue + ">" + "<xsl:apply-templates select=\"@*|node()\" />" + "</" + newValue + ">");
        }

        public Builder xmlChangeAttribute(String xpathToMatch, String newValue) {
            return this.xmlReplaceItem(xpathToMatch, "<xsl:attribute name='{local-name()}'>" + newValue + "</xsl:attribute>");
        }

        public Builder renameType(String oldVal, String newVal) {
            return this.xmlReplaceItem("type/text()[.='" + this.toXstreamClassnameFormat(oldVal) + "']", this.toXstreamClassnameFormat(newVal));
        }

        public Builder renameClassTag(String oldVal, String newVal) {
            return this.xmlRenameTag(this.toXstreamClassnameFormat(oldVal), this.toXstreamClassnameFormat(newVal));
        }

        public Builder renameField(String clazz, String oldVal, String newVal) {
            return this.xmlRenameTag(this.toXstreamClassnameFormat(clazz) + "/" + this.toXstreamClassnameFormat(oldVal), this.toXstreamClassnameFormat(newVal));
        }

        public Builder changeCatalogItemId(String oldSymbolicName, String oldVersion, String newSymbolicName, String newVersion) {
            if (oldVersion == null) {
                return this.changeCatalogItemId(oldSymbolicName, newSymbolicName, newVersion);
            }
            return this.xmlReplaceItem("catalogItemId/text()[.='" + (String)Preconditions.checkNotNull((Object)oldSymbolicName, (Object)"old_symbolic_name") + ":" + (String)Preconditions.checkNotNull((Object)oldVersion, (Object)"old_version") + "']", (String)Preconditions.checkNotNull((Object)newSymbolicName, (Object)"new_symbolic_name") + ":" + (String)Preconditions.checkNotNull((Object)newVersion, (Object)"new_version"));
        }

        public Builder changeCatalogItemId(String oldSymbolicName, String newSymbolicName, String newVersion) {
            return this.xmlReplaceItem("catalogItemId/text()[starts-with(.,'" + (String)Preconditions.checkNotNull((Object)oldSymbolicName, (Object)"old_symbolic_name") + ":')]", (String)Preconditions.checkNotNull((Object)newSymbolicName, (Object)"new_symbolic_name") + ":" + (String)Preconditions.checkNotNull((Object)newVersion, (Object)"new_version"));
        }

        public Builder renameClass(String oldName, String newName) {
            return this.renameClassTag(oldName, newName).xmlChangeAttribute("//@class[.='" + oldName + "']", newName).renameType(oldName, newName);
        }

        private String toXstreamClassnameFormat(String val) {
            return val.contains("$") ? val.replace("$", "_-") : val;
        }

        public CompoundTransformer build() {
            return new CompoundTransformer(this);
        }
    }
}

