/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.persister;

import brooklyn.basic.AbstractBrooklynObjectSpec;
import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogBundleDto;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.Feed;
import brooklyn.entity.basic.BasicParameterType;
import brooklyn.entity.effector.EffectorAndBody;
import brooklyn.entity.effector.EffectorTasks;
import brooklyn.entity.rebind.dto.BasicCatalogItemMemento;
import brooklyn.entity.rebind.dto.BasicEnricherMemento;
import brooklyn.entity.rebind.dto.BasicEntityMemento;
import brooklyn.entity.rebind.dto.BasicFeedMemento;
import brooklyn.entity.rebind.dto.BasicLocationMemento;
import brooklyn.entity.rebind.dto.BasicPolicyMemento;
import brooklyn.entity.rebind.dto.MutableBrooklynMemento;
import brooklyn.entity.rebind.persister.CatalogItemLibrariesConverter;
import brooklyn.entity.rebind.persister.MementoSerializer;
import brooklyn.entity.trait.Identifiable;
import brooklyn.event.basic.BasicAttributeSensor;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import brooklyn.management.Task;
import brooklyn.management.classloading.BrooklynClassLoadingContext;
import brooklyn.management.classloading.BrooklynClassLoadingContextSequential;
import brooklyn.management.classloading.ClassLoaderFromBrooklynClassLoadingContext;
import brooklyn.management.classloading.JavaBrooklynClassLoadingContext;
import brooklyn.mementos.BrooklynMementoPersister;
import brooklyn.policy.Enricher;
import brooklyn.policy.Policy;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.text.Strings;
import brooklyn.util.xstream.XmlSerializer;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.core.ReferencingMarshallingContext;
import com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.path.PathTrackingReader;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.IOException;
import java.io.Writer;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlMementoSerializer<T>
extends XmlSerializer<T>
implements MementoSerializer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(XmlMementoSerializer.class);
    private final ClassLoader classLoader;
    private BrooklynMementoPersister.LookupContext lookupContext;
    static boolean loggedTaskWarning = false;
    Stack<BrooklynClassLoadingContext> contexts = new Stack();
    Stack<ClassLoader> cls = new Stack();
    AtomicReference<Thread> xstreamLockOwner = new AtomicReference();
    int lockCount;

    public XmlMementoSerializer(ClassLoader classLoader) {
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader");
        this.xstream.setClassLoader(this.classLoader);
        this.xstream.alias("brooklyn", MutableBrooklynMemento.class);
        this.xstream.alias("entity", BasicEntityMemento.class);
        this.xstream.alias("location", BasicLocationMemento.class);
        this.xstream.alias("policy", BasicPolicyMemento.class);
        this.xstream.alias("feed", BasicFeedMemento.class);
        this.xstream.alias("enricher", BasicEnricherMemento.class);
        this.xstream.alias("configKey", BasicConfigKey.class);
        this.xstream.alias("catalogItem", BasicCatalogItemMemento.class);
        this.xstream.alias("bundle", CatalogBundleDto.class);
        this.xstream.alias("attributeSensor", BasicAttributeSensor.class);
        this.xstream.alias("effector", Effector.class);
        this.xstream.addDefaultImplementation(EffectorAndBody.class, Effector.class);
        this.xstream.alias("parameter", BasicParameterType.class);
        this.xstream.addDefaultImplementation(EffectorTasks.EffectorBodyTaskFactory.class, EffectorTasks.EffectorTaskFactory.class);
        this.xstream.alias("entityRef", Entity.class);
        this.xstream.alias("locationRef", Location.class);
        this.xstream.alias("policyRef", Policy.class);
        this.xstream.alias("enricherRef", Enricher.class);
        this.xstream.registerConverter((SingleValueConverter)new LocationConverter());
        this.xstream.registerConverter((SingleValueConverter)new PolicyConverter());
        this.xstream.registerConverter((SingleValueConverter)new EnricherConverter());
        this.xstream.registerConverter((SingleValueConverter)new EntityConverter());
        this.xstream.registerConverter((SingleValueConverter)new FeedConverter());
        this.xstream.registerConverter((SingleValueConverter)new CatalogItemConverter());
        this.xstream.registerConverter((Converter)new SpecConverter());
        this.xstream.registerConverter((Converter)new ManagementContextConverter());
        this.xstream.registerConverter((Converter)new TaskConverter(this.xstream.getMapper()));
        this.xstream.aliasField("registeredTypeName", BasicCatalogItemMemento.class, "symbolicName");
        this.xstream.registerLocalConverter(BasicCatalogItemMemento.class, "libraries", (Converter)new CatalogItemLibrariesConverter());
    }

    @Override
    protected MapperWrapper wrapMapper(MapperWrapper next) {
        MapperWrapper mapper = super.wrapMapper(next);
        mapper = new CustomMapper((Mapper)mapper, Entity.class, "entityProxy");
        mapper = new CustomMapper((Mapper)mapper, Location.class, "locationProxy");
        return mapper;
    }

    @Override
    public void serialize(Object object, Writer writer) {
        super.serialize(object, writer);
        try {
            writer.append("\n");
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public void setLookupContext(BrooklynMementoPersister.LookupContext lookupContext) {
        this.lookupContext = (BrooklynMementoPersister.LookupContext)Preconditions.checkNotNull((Object)lookupContext, (Object)"lookupContext");
    }

    @Override
    public void unsetLookupContext() {
        this.lookupContext = null;
    }

    protected void pushXstreamCustomClassLoader(BrooklynClassLoadingContext clcNew) {
        this.acquireXstreamLock();
        Object oldClc = !this.contexts.isEmpty() ? this.contexts.peek() : JavaBrooklynClassLoadingContext.create(this.lookupContext.lookupManagementContext(), this.xstream.getClassLoader());
        BrooklynClassLoadingContextSequential clcMerged = new BrooklynClassLoadingContextSequential(this.lookupContext.lookupManagementContext(), new BrooklynClassLoadingContext[]{oldClc, clcNew});
        this.contexts.push(clcMerged);
        this.cls.push(this.xstream.getClassLoader());
        ClassLoader newCL = ClassLoaderFromBrooklynClassLoadingContext.of(clcMerged);
        this.xstream.setClassLoader(newCL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void popXstreamCustomClassLoader() {
        AtomicReference<Thread> atomicReference = this.xstreamLockOwner;
        synchronized (atomicReference) {
            this.releaseXstreamLock();
            this.xstream.setClassLoader(this.cls.pop());
            this.contexts.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquireXstreamLock() {
        AtomicReference<Thread> atomicReference = this.xstreamLockOwner;
        synchronized (atomicReference) {
            while (!this.xstreamLockOwner.compareAndSet(null, Thread.currentThread()) && !Thread.currentThread().equals(this.xstreamLockOwner.get())) {
                try {
                    this.xstreamLockOwner.wait(1000L);
                }
                catch (InterruptedException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            ++this.lockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseXstreamLock() {
        AtomicReference<Thread> atomicReference = this.xstreamLockOwner;
        synchronized (atomicReference) {
            if (this.lockCount <= 0) {
                throw new IllegalStateException("xstream not locked");
            }
            if (--this.lockCount == 0) {
                if (!this.xstreamLockOwner.compareAndSet(Thread.currentThread(), null)) {
                    Thread oldOwner = this.xstreamLockOwner.getAndSet(null);
                    throw new IllegalStateException("xstream was locked by " + oldOwner + " but unlock attempt by " + Thread.currentThread());
                }
                this.xstreamLockOwner.notifyAll();
            }
        }
    }

    public class SpecConverter
    extends ReflectionConverter {
        Object instance;

        SpecConverter() {
            super(XmlMementoSerializer.this.xstream.getMapper(), XmlMementoSerializer.this.xstream.getReflectionProvider());
        }

        public boolean canConvert(Class type) {
            return AbstractBrooklynObjectSpec.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            if (source == null) {
                return;
            }
            AbstractBrooklynObjectSpec spec = (AbstractBrooklynObjectSpec)source;
            String catalogItemId = spec.getCatalogItemId();
            if (Strings.isNonBlank((CharSequence)catalogItemId)) {
                writer.startNode("catalogItemId");
                writer.setValue(catalogItemId);
                writer.endNode();
                super.marshal(source, writer, context);
            } else {
                super.marshal(source, writer, context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String catalogItemId = null;
            this.instantiateNewInstanceSettingCache(reader, context);
            if (reader instanceof PathTrackingReader && "catalogItemId".equals(((PathTrackingReader)reader).peekNextChild())) {
                reader.moveDown();
                catalogItemId = reader.getValue();
                reader.moveUp();
            }
            boolean customLoaderSet = false;
            try {
                if (Strings.isNonBlank(catalogItemId)) {
                    if (XmlMementoSerializer.this.lookupContext == null) {
                        throw new NullPointerException("lookupContext required to load catalog item " + catalogItemId);
                    }
                    CatalogItem<?, ?> cat = CatalogUtils.getCatalogItemOptionalVersion(XmlMementoSerializer.this.lookupContext.lookupManagementContext(), catalogItemId);
                    if (cat == null) {
                        throw new NoSuchElementException("catalog item: " + catalogItemId);
                    }
                    BrooklynClassLoadingContext clcNew = CatalogUtils.newClassLoadingContext(XmlMementoSerializer.this.lookupContext.lookupManagementContext(), cat);
                    XmlMementoSerializer.this.pushXstreamCustomClassLoader(clcNew);
                    customLoaderSet = true;
                }
                AbstractBrooklynObjectSpec result = (AbstractBrooklynObjectSpec)super.unmarshal(reader, context);
                result.catalogItemId(catalogItemId);
                AbstractBrooklynObjectSpec abstractBrooklynObjectSpec = result;
                return abstractBrooklynObjectSpec;
            }
            finally {
                this.instance = null;
                if (customLoaderSet) {
                    XmlMementoSerializer.this.popXstreamCustomClassLoader();
                }
            }
        }

        protected Object instantiateNewInstance(HierarchicalStreamReader reader, UnmarshallingContext context) {
            if (this.instance == null) {
                throw new IllegalStateException("Instance should be created and cached");
            }
            return this.instance;
        }

        protected void instantiateNewInstanceSettingCache(HierarchicalStreamReader reader, UnmarshallingContext context) {
            this.instance = super.instantiateNewInstance(reader, context);
        }
    }

    public class ManagementContextConverter
    implements Converter {
        public boolean canConvert(Class type) {
            return ManagementContext.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return XmlMementoSerializer.this.lookupContext.lookupManagementContext();
        }
    }

    public class TaskConverter
    implements Converter {
        private final Mapper mapper;

        TaskConverter(Mapper mapper) {
            this.mapper = mapper;
        }

        public boolean canConvert(Class type) {
            return Task.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            if (source == null) {
                return;
            }
            if (((Task)source).isDone() && !((Task)source).isError()) {
                try {
                    context.convertAnother(((Task)source).get());
                }
                catch (InterruptedException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.warn("Unexpected exception getting done (and non-error) task result for " + source + "; continuing: " + e, (Throwable)e);
                }
            } else {
                if (!loggedTaskWarning) {
                    LOG.warn("Intercepting and skipping request to serialize a Task" + (context instanceof ReferencingMarshallingContext ? " at " + ((ReferencingMarshallingContext)context).currentPath() : "") + " (only logging this once): " + source);
                    loggedTaskWarning = true;
                }
                return;
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            if (reader.hasMoreChildren()) {
                Class type = HierarchicalStreams.readClassType((HierarchicalStreamReader)reader, (Mapper)this.mapper);
                reader.moveDown();
                Object result = context.convertAnother(null, type);
                reader.moveUp();
                return result;
            }
            return null;
        }
    }

    public class CatalogItemConverter
    extends IdentifiableConverter<CatalogItem> {
        CatalogItemConverter() {
            super(CatalogItem.class);
        }

        @Override
        protected CatalogItem<?, ?> lookup(String id) {
            return XmlMementoSerializer.this.lookupContext.lookupCatalogItem(id);
        }
    }

    public class EntityConverter
    extends IdentifiableConverter<Entity> {
        EntityConverter() {
            super(Entity.class);
        }

        @Override
        protected Entity lookup(String id) {
            return XmlMementoSerializer.this.lookupContext.lookupEntity(id);
        }
    }

    public class FeedConverter
    extends IdentifiableConverter<Feed> {
        FeedConverter() {
            super(Feed.class);
        }

        @Override
        protected Feed lookup(String id) {
            return XmlMementoSerializer.this.lookupContext.lookupFeed(id);
        }
    }

    public class EnricherConverter
    extends IdentifiableConverter<Enricher> {
        EnricherConverter() {
            super(Enricher.class);
        }

        @Override
        protected Enricher lookup(String id) {
            return XmlMementoSerializer.this.lookupContext.lookupEnricher(id);
        }
    }

    public class PolicyConverter
    extends IdentifiableConverter<Policy> {
        PolicyConverter() {
            super(Policy.class);
        }

        @Override
        protected Policy lookup(String id) {
            return XmlMementoSerializer.this.lookupContext.lookupPolicy(id);
        }
    }

    public class LocationConverter
    extends IdentifiableConverter<Location> {
        LocationConverter() {
            super(Location.class);
        }

        @Override
        protected Location lookup(String id) {
            return XmlMementoSerializer.this.lookupContext.lookupLocation(id);
        }
    }

    public abstract class IdentifiableConverter<IT extends Identifiable>
    implements SingleValueConverter {
        private final Class<IT> clazz;

        IdentifiableConverter(Class<IT> clazz) {
            this.clazz = clazz;
        }

        public boolean canConvert(Class type) {
            boolean result = this.clazz.isAssignableFrom(type);
            return result;
        }

        public String toString(Object obj) {
            return obj == null ? null : ((Identifiable)obj).getId();
        }

        public Object fromString(String str) {
            if (XmlMementoSerializer.this.lookupContext == null) {
                LOG.warn("Cannot unmarshal from persisted xml {} {}; no lookup context supplied!", (Object)this.clazz.getSimpleName(), (Object)str);
                return null;
            }
            return this.lookup(str);
        }

        protected abstract IT lookup(String var1);
    }

    public class CustomMapper
    extends MapperWrapper {
        private final Class<?> clazz;
        private final String alias;

        public CustomMapper(Mapper wrapped, Class<?> clazz, String alias) {
            super(wrapped);
            this.clazz = (Class)Preconditions.checkNotNull(clazz, (Object)"clazz");
            this.alias = (String)Preconditions.checkNotNull((Object)alias, (Object)"alias");
        }

        public String getAlias() {
            return this.alias;
        }

        public String serializedClass(Class type) {
            if (type != null && this.clazz.isAssignableFrom(type)) {
                return this.alias;
            }
            return super.serializedClass(type);
        }

        public Class<?> realClass(String elementName) {
            if (elementName.equals(this.alias)) {
                return this.clazz;
            }
            return super.realClass(elementName);
        }
    }
}

