/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.persister;

import brooklyn.entity.rebind.persister.PersistenceObjectStore;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.javalang.JavaClassNames;
import brooklyn.util.time.Duration;
import java.util.Comparator;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class StoreObjectAccessorLocking
implements PersistenceObjectStore.StoreObjectAccessorWithLock {
    ReadWriteLock lock = new ReentrantReadWriteLock(true);
    Set<Thread> queuedReaders = new ConcurrentSkipListSet<Thread>(new ThreadComparator());
    Set<Thread> queuedWriters = new ConcurrentSkipListSet<Thread>(new ThreadComparator());
    final PersistenceObjectStore.StoreObjectAccessor delegate;

    public StoreObjectAccessorLocking(PersistenceObjectStore.StoreObjectAccessor delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get() {
        try {
            this.queuedReaders.add(Thread.currentThread());
            this.lock.readLock().lockInterruptibly();
            try {
                String string = this.delegate.get();
                this.lock.readLock().unlock();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    this.lock.readLock().unlock();
                    throw throwable;
                }
                catch (InterruptedException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }
        finally {
            this.queuedReaders.remove(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes() {
        try {
            this.queuedReaders.add(Thread.currentThread());
            this.lock.readLock().lockInterruptibly();
            try {
                byte[] byArray = this.delegate.getBytes();
                this.lock.readLock().unlock();
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    this.lock.readLock().unlock();
                    throw throwable;
                }
                catch (InterruptedException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }
        finally {
            this.queuedReaders.remove(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        try {
            this.queuedReaders.add(Thread.currentThread());
            this.lock.readLock().lockInterruptibly();
            try {
                boolean bl = this.delegate.exists();
                this.lock.readLock().unlock();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    this.lock.readLock().unlock();
                    throw throwable;
                }
                catch (InterruptedException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }
        finally {
            this.queuedReaders.remove(Thread.currentThread());
        }
    }

    protected boolean hasScheduledPutOrDeleteWithNoRead() {
        return !this.queuedWriters.isEmpty() && this.queuedReaders.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String val) {
        try {
            this.queuedWriters.add(Thread.currentThread());
            this.lock.writeLock().lockInterruptibly();
            try {
                this.queuedWriters.remove(Thread.currentThread());
                if (this.hasScheduledPutOrDeleteWithNoRead()) {
                    return;
                }
                this.delegate.put(val);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            this.queuedWriters.remove(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(String val) {
        try {
            this.lock.writeLock().lockInterruptibly();
            try {
                if (this.hasScheduledPutOrDeleteWithNoRead()) {
                    return;
                }
                this.delegate.append(val);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        try {
            this.queuedWriters.add(Thread.currentThread());
            this.lock.writeLock().lockInterruptibly();
            try {
                this.queuedWriters.remove(Thread.currentThread());
                if (this.hasScheduledPutOrDeleteWithNoRead()) {
                    return;
                }
                this.delegate.delete();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            this.queuedWriters.remove(Thread.currentThread());
        }
    }

    @Override
    public void waitForCurrentWrites(Duration timeout) throws InterruptedException, TimeoutException {
        try {
            boolean locked = this.lock.readLock().tryLock(timeout.toMillisecondsRoundingUp(), TimeUnit.MILLISECONDS);
            if (!locked) {
                throw new TimeoutException("Timeout waiting for writes of " + this.delegate + " after " + timeout);
            }
            this.lock.readLock().unlock();
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public Date getLastModifiedDate() {
        return this.delegate.getLastModifiedDate();
    }

    @Override
    public ReadWriteLock getLockObject() {
        return this.lock;
    }

    public String toString() {
        return JavaClassNames.simpleClassName((Object)this) + ":" + this.delegate.toString();
    }

    protected static class ThreadComparator
    implements Comparator<Thread> {
        protected ThreadComparator() {
        }

        @Override
        public int compare(Thread o1, Thread o2) {
            if (o1.getId() < o2.getId()) {
                return -1;
            }
            if (o1.getId() > o2.getId()) {
                return 1;
            }
            return 0;
        }
    }
}

