/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.persister;

import brooklyn.entity.rebind.persister.MementoSerializer;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Stopwatch;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MementoFileWriterSync<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MementoFileWriterSync.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final File file;
    private final File tmpFile;
    private final MementoSerializer<? super T> serializer;
    private final AtomicLong modCount = new AtomicLong();

    public MementoFileWriterSync(File file, MementoSerializer<? super T> serializer) {
        this(file, serializer, "tmp");
    }

    public MementoFileWriterSync(File file, MementoSerializer<? super T> serializer, String tmpFileSuffix) {
        this.file = file;
        this.serializer = serializer;
        this.tmpFile = new File(file.getParentFile(), file.getName() + "." + tmpFileSuffix);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void write(T val) {
        try {
            this.lock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            Files.write((CharSequence)this.serializer.toString(val), (File)this.tmpFile, (Charset)Charsets.UTF_8);
            Files.move((File)this.tmpFile, (File)this.file);
            this.modCount.incrementAndGet();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Wrote {}, took {}; modified file {} times", new Object[]{this.file, Time.makeTimeStringRounded((Stopwatch)stopwatch), this.modCount});
            }
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void append(T val) {
        try {
            this.lock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            Files.append((CharSequence)this.serializer.toString(val), (File)this.file, (Charset)Charsets.UTF_8);
            this.modCount.incrementAndGet();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Wrote {}, took {}; modified file {} times", new Object[]{this.file, Time.makeTimeStringRounded((Stopwatch)stopwatch), this.modCount});
            }
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        try {
            this.lock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.file.delete();
            this.tmpFile.delete();
            this.modCount.incrementAndGet();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Deleted {}, took {}; modified file {} times", new Object[]{this.file, Time.makeTimeStringRounded((Stopwatch)stopwatch), this.modCount});
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @VisibleForTesting
    public void waitForWriteCompleted(Duration timeout) throws InterruptedException, TimeoutException {
        boolean locked = this.lock.writeLock().tryLock(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
        if (!locked) {
            throw new TimeoutException("Timeout waiting for lock on " + this.file);
        }
        this.lock.writeLock().unlock();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("file", (Object)this.file).toString();
    }
}

