/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.persister;

import brooklyn.entity.rebind.persister.MementoSerializer;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Stopwatch;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MementoFileWriter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MementoFileWriter.class);
    private final File file;
    private final File tmpFile;
    private final ListeningExecutorService executor;
    private final MementoSerializer<? super T> serializer;
    private final AtomicBoolean executing = new AtomicBoolean();
    private final AtomicReference<T> requireWrite = new AtomicReference();
    private final AtomicBoolean requireDelete = new AtomicBoolean();
    private final AtomicBoolean deleted = new AtomicBoolean();
    private final AtomicLong modCount = new AtomicLong();

    public MementoFileWriter(File file, ListeningExecutorService executor, MementoSerializer<? super T> serializer) {
        this.file = file;
        this.executor = executor;
        this.serializer = serializer;
        this.tmpFile = new File(file.getParentFile(), file.getName() + ".tmp");
    }

    public void write(T val) {
        this.requireWrite.set(val);
        if (this.requireDelete.get() || this.deleted.get()) {
            LOG.warn("Not writing {}, because already deleted", (Object)this.file);
        } else if (this.executing.compareAndSet(false, true)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Submitting write task for {}", (Object)this.file);
            }
            this.writeAsync();
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Execution already in-progress for {}; recorded write-requirement; returning", (Object)this.file);
        }
    }

    public void delete() {
        if (this.deleted.get() || this.requireDelete.get()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Duplicate call to delete {}; ignoring", (Object)this.file);
            }
            return;
        }
        this.requireWrite.set(null);
        this.requireDelete.set(true);
        if (this.executing.compareAndSet(false, true)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Submitting delete task for {}", (Object)this.file);
            }
            this.deleteAsync();
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Execution already in-progress for {}; recorded delete-requirement; returning", (Object)this.file);
        }
    }

    @VisibleForTesting
    public void waitForWriteCompleted(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.waitForWriteCompleted(Duration.of((long)timeout, (TimeUnit)unit));
    }

    @VisibleForTesting
    public void waitForWriteCompleted(Duration timeout) throws InterruptedException, TimeoutException {
        long timeoutMillis = timeout.toMilliseconds();
        long startTime = System.currentTimeMillis();
        long maxEndtime = timeoutMillis > 0L ? startTime + timeoutMillis : (timeoutMillis < 0L ? startTime : Long.MAX_VALUE);
        long origModCount = this.modCount.get();
        while (this.modCount.get() <= origModCount + 1L) {
            if (this.requireWrite.get() == null && !this.executing.get()) {
                return;
            }
            if (System.currentTimeMillis() > maxEndtime) {
                throw new TimeoutException("Timeout waiting for pending complete of rebind-periodic-delta, after " + Time.makeTimeStringRounded((Duration)timeout));
            }
            Thread.sleep(10L);
        }
        return;
    }

    private void deleteAsync() {
        ListenableFuture future = this.executor.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                try {
                    MementoFileWriter.this.deleteNow();
                    return null;
                }
                catch (Throwable t) {
                    if (MementoFileWriter.this.executor.isShutdown()) {
                        LOG.debug("Error deleting " + MementoFileWriter.this.file + " (but executor shutdown)", t);
                        return null;
                    }
                    LOG.error("Error deleting " + MementoFileWriter.this.file, t);
                    throw Exceptions.propagate((Throwable)t);
                }
            }
        });
        this.addPostExecListener(future);
    }

    private void writeAsync() {
        ListenableFuture future = this.executor.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                try {
                    MementoFileWriter.this.writeNow();
                    return null;
                }
                catch (Throwable t) {
                    if (MementoFileWriter.this.executor.isShutdown()) {
                        LOG.debug("Error writing to " + MementoFileWriter.this.file + " (but executor shutdown)", t);
                        return null;
                    }
                    LOG.error("Error writing to " + MementoFileWriter.this.file, t);
                    throw Exceptions.propagate((Throwable)t);
                }
            }
        });
        this.addPostExecListener(future);
    }

    private void addPostExecListener(ListenableFuture<?> future) {
        future.addListener(new Runnable(){

            @Override
            public void run() {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Write complete for {}", (Object)MementoFileWriter.this.file);
                }
                try {
                    MementoFileWriter.this.executing.set(false);
                    if (MementoFileWriter.this.requireDelete.get()) {
                        if (MementoFileWriter.this.executing.compareAndSet(false, true)) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Submitting delete-task for {} (in post-exec) due to recorded delete-requirement", (Object)MementoFileWriter.this.file);
                            }
                            MementoFileWriter.this.deleteAsync();
                        } else if (LOG.isTraceEnabled()) {
                            LOG.trace("Delete-requirement for {} (in post-exec) handled by other thread; returning", (Object)MementoFileWriter.this.file);
                        }
                    } else if (MementoFileWriter.this.requireWrite.get() != null) {
                        if (MementoFileWriter.this.executing.compareAndSet(false, true)) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Submitting write task for {} (in post-exec) due to recorded write-requirement", (Object)MementoFileWriter.this.file);
                            }
                            MementoFileWriter.this.writeAsync();
                        } else if (LOG.isTraceEnabled()) {
                            LOG.trace("Write-requirement for {} (in post-exec) handled by other thread; returning", (Object)MementoFileWriter.this.file);
                        }
                    } else if (LOG.isTraceEnabled()) {
                        LOG.trace("No pending exec-requirements for {}", (Object)MementoFileWriter.this.file);
                    }
                }
                catch (Throwable t) {
                    if (MementoFileWriter.this.executor.isShutdown()) {
                        LOG.debug("Error in post-exec for " + MementoFileWriter.this.file + " (but executor shutdown)", t);
                        return;
                    }
                    LOG.error("Error in post-exec for " + MementoFileWriter.this.file, t);
                    throw Exceptions.propagate((Throwable)t);
                }
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNow() throws IOException {
        Object val = this.requireWrite.getAndSet(null);
        Object object = new Object();
        synchronized (object) {
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        Files.write((CharSequence)this.serializer.toString(val), (File)this.tmpFile, (Charset)Charsets.UTF_8);
        Files.move((File)this.tmpFile, (File)this.file);
        this.modCount.incrementAndGet();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Wrote {}, took {}; modified file {} times", new Object[]{this.file, Time.makeTimeStringRounded((Stopwatch)stopwatch), this.modCount});
        }
    }

    private void deleteNow() throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Deleting {} and {}", (Object)this.file, (Object)this.tmpFile);
        }
        this.deleted.set(true);
        this.requireDelete.set(false);
        this.file.delete();
        this.tmpFile.delete();
        this.modCount.incrementAndGet();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("file", (Object)this.file).toString();
    }
}

