/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.persister;

import brooklyn.entity.rebind.persister.FileBasedObjectStore;
import brooklyn.entity.rebind.persister.PersistenceObjectStore;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.io.FileUtil;
import brooklyn.util.text.Strings;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedStoreObjectAccessor
implements PersistenceObjectStore.StoreObjectAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedStoreObjectAccessor.class);
    private final File file;
    private final File tmpFile;

    public FileBasedStoreObjectAccessor(File file, String tmpExtension) {
        this.file = file;
        this.tmpFile = new File(file.getParentFile(), file.getName() + (Strings.isBlank((CharSequence)tmpExtension) ? ".tmp" : tmpExtension));
    }

    @Override
    public String get() {
        try {
            if (!this.exists()) {
                return null;
            }
            return Files.asCharSource((File)this.file, (Charset)Charsets.UTF_8).read();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public byte[] getBytes() {
        try {
            if (!this.exists()) {
                return null;
            }
            return Files.asByteSource((File)this.file).read();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public void put(String val) {
        try {
            if (val == null) {
                val = "";
            }
            FileUtil.setFilePermissionsTo600((File)this.tmpFile);
            Files.write((CharSequence)val, (File)this.tmpFile, (Charset)Charsets.UTF_8);
            FileBasedObjectStore.moveFile(this.tmpFile, this.file);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public void append(String val) {
        try {
            if (val == null) {
                val = "";
            }
            FileUtil.setFilePermissionsTo600((File)this.file);
            Files.append((CharSequence)val, (File)this.file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public void delete() {
        if (!this.file.delete()) {
            if (!this.file.exists()) {
                LOG.debug("Unable to delete " + this.file.getAbsolutePath() + ". Probably did not exist.");
            } else {
                LOG.warn("Unable to delete " + this.file.getAbsolutePath() + ". Probably still locked.");
            }
        }
        if (this.tmpFile.exists() && !this.tmpFile.delete()) {
            LOG.warn("Unable to delete " + this.tmpFile.getAbsolutePath() + ". Probably still locked.");
        }
    }

    @Override
    public Date getLastModifiedDate() {
        long result = this.file.lastModified();
        if (result == 0L) {
            return null;
        }
        return new Date(result);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("file", (Object)this.file).toString();
    }
}

