/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.persister;

import brooklyn.entity.rebind.BrooklynObjectType;
import brooklyn.entity.rebind.PersistenceExceptionHandler;
import brooklyn.entity.rebind.RebindExceptionHandler;
import brooklyn.entity.rebind.dto.BrooklynMementoImpl;
import brooklyn.entity.rebind.dto.BrooklynMementoManifestImpl;
import brooklyn.entity.rebind.persister.BrooklynMementoPersisterToObjectStore;
import brooklyn.entity.rebind.persister.MementoFileWriter;
import brooklyn.entity.rebind.persister.MementoSerializer;
import brooklyn.entity.rebind.persister.RetryingMementoSerializer;
import brooklyn.entity.rebind.persister.XmlMementoSerializer;
import brooklyn.mementos.BrooklynMemento;
import brooklyn.mementos.BrooklynMementoManifest;
import brooklyn.mementos.BrooklynMementoPersister;
import brooklyn.mementos.BrooklynMementoRawData;
import brooklyn.mementos.CatalogItemMemento;
import brooklyn.mementos.EnricherMemento;
import brooklyn.mementos.EntityMemento;
import brooklyn.mementos.LocationMemento;
import brooklyn.mementos.PolicyMemento;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import brooklyn.util.xstream.XmlUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BrooklynMementoPersisterToMultiFile
implements BrooklynMementoPersister {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynMementoPersisterToMultiFile.class);
    private static final int SHUTDOWN_TIMEOUT_MS = 10000;
    private final File dir;
    private final File entitiesDir;
    private final File locationsDir;
    private final File policiesDir;
    private final File enrichersDir;
    private final File catalogItemsDir;
    private final ConcurrentMap<String, MementoFileWriter<EntityMemento>> entityWriters = new ConcurrentHashMap<String, MementoFileWriter<EntityMemento>>();
    private final ConcurrentMap<String, MementoFileWriter<LocationMemento>> locationWriters = new ConcurrentHashMap<String, MementoFileWriter<LocationMemento>>();
    private final ConcurrentMap<String, MementoFileWriter<PolicyMemento>> policyWriters = new ConcurrentHashMap<String, MementoFileWriter<PolicyMemento>>();
    private final ConcurrentMap<String, MementoFileWriter<EnricherMemento>> enricherWriters = new ConcurrentHashMap<String, MementoFileWriter<EnricherMemento>>();
    private final ConcurrentMap<String, MementoFileWriter<CatalogItemMemento>> catalogItemWriters = new ConcurrentHashMap<String, MementoFileWriter<CatalogItemMemento>>();
    private final MementoSerializer<Object> serializer;
    private final ListeningExecutorService executor;
    private static final int MAX_SERIALIZATION_ATTEMPTS = 5;
    private volatile boolean running = true;

    public BrooklynMementoPersisterToMultiFile(File dir, ClassLoader classLoader) {
        this.dir = (File)Preconditions.checkNotNull((Object)dir, (Object)"dir");
        XmlMementoSerializer rawSerializer = new XmlMementoSerializer(classLoader);
        this.serializer = new RetryingMementoSerializer<Object>(rawSerializer, 5);
        BrooklynMementoPersisterToMultiFile.checkDirIsAccessible(dir);
        this.entitiesDir = new File(dir, "entities");
        this.entitiesDir.mkdir();
        BrooklynMementoPersisterToMultiFile.checkDirIsAccessible(this.entitiesDir);
        this.locationsDir = new File(dir, "locations");
        this.locationsDir.mkdir();
        BrooklynMementoPersisterToMultiFile.checkDirIsAccessible(this.locationsDir);
        this.policiesDir = new File(dir, "policies");
        this.policiesDir.mkdir();
        BrooklynMementoPersisterToMultiFile.checkDirIsAccessible(this.policiesDir);
        this.enrichersDir = new File(dir, "enrichers");
        this.enrichersDir.mkdir();
        BrooklynMementoPersisterToMultiFile.checkDirIsAccessible(this.enrichersDir);
        this.catalogItemsDir = new File(dir, "catalog");
        this.catalogItemsDir.mkdir();
        BrooklynMementoPersisterToMultiFile.checkDirIsAccessible(this.catalogItemsDir);
        File planeDir = new File(dir, "plane");
        planeDir.mkdir();
        BrooklynMementoPersisterToMultiFile.checkDirIsAccessible(planeDir);
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        LOG.info("Memento-persister will use directory {}", (Object)dir);
    }

    public void enableWriteAccess() {
    }

    public void disableWriteAccess(boolean graceful) {
        this.stop(graceful);
    }

    public void stop(boolean graceful) {
        this.running = false;
        if (graceful) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(10000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        } else {
            this.executor.shutdownNow();
        }
    }

    public BrooklynMementoRawData loadMementoRawData(RebindExceptionHandler exceptionHandler) {
        return null;
    }

    public BrooklynMementoManifest loadMementoManifest(RebindExceptionHandler exceptionHandler) throws IOException {
        return this.loadMementoManifest(null, exceptionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrooklynMementoManifest loadMementoManifest(BrooklynMementoRawData mementoData, RebindExceptionHandler exceptionHandler) throws IOException {
        File[] catalogItemFiles;
        File[] enricherFiles;
        File[] policyFiles;
        File[] locationFiles;
        File[] entityFiles;
        if (!this.running) {
            throw new IllegalStateException("Persister not running; cannot load memento manifest from " + this.dir);
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().endsWith(".tmp");
            }
        };
        try {
            entityFiles = this.entitiesDir.listFiles(fileFilter);
            locationFiles = this.locationsDir.listFiles(fileFilter);
            policyFiles = this.policiesDir.listFiles(fileFilter);
            enricherFiles = this.enrichersDir.listFiles(fileFilter);
            catalogItemFiles = this.catalogItemsDir.listFiles(fileFilter);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            exceptionHandler.onLoadMementoFailed(BrooklynObjectType.UNKNOWN, "Failed to list files", e);
            throw new IllegalStateException("Failed to list memento files in " + this.dir, e);
        }
        LOG.info("Loading memento manifest from {}; {} entities, {} locations, {} policies, {} enrichers", new Object[]{this.dir, entityFiles.length, locationFiles.length, policyFiles.length, enricherFiles.length});
        BrooklynMementoManifestImpl.Builder builder = BrooklynMementoManifestImpl.builder();
        try {
            String type;
            String id;
            String contents;
            for (File file : entityFiles) {
                try {
                    contents = this.readFile(file);
                    id = (String)XmlUtil.xpath(contents, "/entity/id");
                    type = (String)XmlUtil.xpath(contents, "/entity/type");
                    String parentId = (String)XmlUtil.xpath(contents, "/entity/parent");
                    String catalogItemId = (String)XmlUtil.xpath(contents, "/entity/catalogItemId");
                    builder.entity(id, type, Strings.emptyToNull((String)parentId), Strings.emptyToNull((String)catalogItemId));
                }
                catch (Exception e) {
                    exceptionHandler.onLoadMementoFailed(BrooklynObjectType.ENTITY, "File " + file, e);
                }
            }
            for (File file : locationFiles) {
                try {
                    contents = this.readFile(file);
                    id = (String)XmlUtil.xpath(contents, "/location/id");
                    type = (String)XmlUtil.xpath(contents, "/location/type");
                    builder.location(id, type);
                }
                catch (Exception e) {
                    exceptionHandler.onLoadMementoFailed(BrooklynObjectType.LOCATION, "File " + file, e);
                }
            }
            for (File file : policyFiles) {
                try {
                    contents = this.readFile(file);
                    id = (String)XmlUtil.xpath(contents, "/policy/id");
                    type = (String)XmlUtil.xpath(contents, "/policy/type");
                    builder.policy(id, type);
                }
                catch (Exception e) {
                    exceptionHandler.onLoadMementoFailed(BrooklynObjectType.POLICY, "File " + file, e);
                }
            }
            for (File file : enricherFiles) {
                try {
                    contents = this.readFile(file);
                    id = (String)XmlUtil.xpath(contents, "/enricher/id");
                    type = (String)XmlUtil.xpath(contents, "/enricher/type");
                    builder.enricher(id, type);
                }
                catch (Exception e) {
                    exceptionHandler.onLoadMementoFailed(BrooklynObjectType.ENRICHER, "File " + file, e);
                }
            }
            for (File file : catalogItemFiles) {
                try {
                    contents = this.readFile(file);
                    id = (String)XmlUtil.xpath(contents, "/catalogItem/id");
                    type = (String)XmlUtil.xpath(contents, "/catalogItem/type");
                    builder.enricher(id, type);
                }
                catch (Exception e) {
                    exceptionHandler.onLoadMementoFailed(BrooklynObjectType.CATALOG_ITEM, "File " + file, e);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded memento manifest; took {}", (Object)Time.makeTimeStringRounded((long)stopwatch.elapsed(TimeUnit.MILLISECONDS)));
            }
            BrooklynMementoManifest brooklynMementoManifest = builder.build();
            return brooklynMementoManifest;
        }
        finally {
            this.serializer.unsetLookupContext();
        }
    }

    public BrooklynMemento loadMemento(BrooklynMementoPersister.LookupContext lookupContext, RebindExceptionHandler exceptionHandler) throws IOException {
        return this.loadMemento(null, lookupContext, exceptionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrooklynMemento loadMemento(BrooklynMementoRawData mementoData, BrooklynMementoPersister.LookupContext lookupContext, RebindExceptionHandler exceptionHandler) throws IOException {
        File[] catalogItemFiles;
        File[] enricherFiles;
        File[] policyFiles;
        File[] locationFiles;
        File[] entityFiles;
        if (!this.running) {
            throw new IllegalStateException("Persister not running; cannot load memento from " + this.dir);
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().endsWith(".tmp");
            }
        };
        try {
            entityFiles = this.entitiesDir.listFiles(fileFilter);
            locationFiles = this.locationsDir.listFiles(fileFilter);
            policyFiles = this.policiesDir.listFiles(fileFilter);
            enricherFiles = this.enrichersDir.listFiles(fileFilter);
            catalogItemFiles = this.catalogItemsDir.listFiles(fileFilter);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            exceptionHandler.onLoadMementoFailed(BrooklynObjectType.UNKNOWN, "Failed to list files", e);
            throw new IllegalStateException("Failed to list memento files in " + this.dir, e);
        }
        LOG.info("Loading memento from {}; {} entities, {} locations, {} policies, {} enrichers and {} catalog items", new Object[]{this.dir, entityFiles.length, locationFiles.length, policyFiles.length, enricherFiles.length, catalogItemFiles.length});
        BrooklynMementoImpl.Builder builder = BrooklynMementoImpl.builder();
        this.serializer.setLookupContext(lookupContext);
        try {
            EntityMemento memento;
            for (File file : entityFiles) {
                try {
                    memento = (EntityMemento)this.serializer.fromString(this.readFile(file));
                    if (memento == null) {
                        LOG.warn("No entity-memento deserialized from file " + file + "; ignoring and continuing");
                        continue;
                    }
                    builder.entity(memento);
                    if (!memento.isTopLevelApp()) continue;
                    builder.applicationId(memento.getId());
                }
                catch (Exception e) {
                    exceptionHandler.onLoadMementoFailed(BrooklynObjectType.ENTITY, "File " + file, e);
                }
            }
            for (File file : locationFiles) {
                try {
                    memento = (LocationMemento)this.serializer.fromString(this.readFile(file));
                    if (memento == null) {
                        LOG.warn("No location-memento deserialized from file " + file + "; ignoring and continuing");
                        continue;
                    }
                    builder.location((LocationMemento)memento);
                }
                catch (Exception e) {
                    exceptionHandler.onLoadMementoFailed(BrooklynObjectType.LOCATION, "File " + file, e);
                }
            }
            for (File file : policyFiles) {
                try {
                    memento = (PolicyMemento)this.serializer.fromString(this.readFile(file));
                    if (memento == null) {
                        LOG.warn("No policy-memento deserialized from file " + file + "; ignoring and continuing");
                        continue;
                    }
                    builder.policy((PolicyMemento)memento);
                }
                catch (Exception e) {
                    exceptionHandler.onLoadMementoFailed(BrooklynObjectType.POLICY, "File " + file, e);
                }
            }
            for (File file : enricherFiles) {
                memento = (EnricherMemento)this.serializer.fromString(this.readFile(file));
                if (memento == null) {
                    LOG.warn("No enricher-memento deserialized from file " + file + "; ignoring and continuing");
                    continue;
                }
                builder.enricher((EnricherMemento)memento);
            }
            for (File file : catalogItemFiles) {
                memento = (CatalogItemMemento)this.serializer.fromString(this.readFile(file));
                if (memento == null) {
                    LOG.warn("No catalog-item-memento deserialized from file " + file + "; ignoring and continuing");
                    continue;
                }
                builder.catalogItem((CatalogItemMemento)memento);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded memento; took {}", (Object)Time.makeTimeStringRounded((long)stopwatch.elapsed(TimeUnit.MILLISECONDS)));
            }
            BrooklynMemento brooklynMemento = builder.build();
            return brooklynMemento;
        }
        finally {
            this.serializer.unsetLookupContext();
        }
    }

    public void checkpoint(BrooklynMemento newMemento, PersistenceExceptionHandler exceptionHandler) {
        if (!this.running) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring checkpointing entire memento, because not running");
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checkpointing entire memento");
        }
        for (EntityMemento m : newMemento.getEntityMementos().values()) {
            this.persist(m);
        }
        for (EntityMemento m : newMemento.getLocationMementos().values()) {
            this.persist((LocationMemento)m);
        }
        for (EntityMemento m : newMemento.getPolicyMementos().values()) {
            this.persist((PolicyMemento)m);
        }
        for (EntityMemento m : newMemento.getEnricherMementos().values()) {
            this.persist((EnricherMemento)m);
        }
        for (EntityMemento m : newMemento.getCatalogItemMementos().values()) {
            this.persist((CatalogItemMemento)m);
        }
        LOG.warn("Using legacy persister; feeds will not be persisted");
    }

    public void checkpoint(BrooklynMementoRawData newMemento, PersistenceExceptionHandler exceptionHandler) {
        throw new IllegalStateException("Not supported; use " + BrooklynMementoPersisterToObjectStore.class);
    }

    public void delta(BrooklynMementoPersister.Delta delta, PersistenceExceptionHandler exceptionHandler) {
        if (!this.running) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring checkpointed delta of memento, because not running");
            }
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Checkpointed delta of memento; updating {} entities, {} locations, {} policies and {} enrichers; removing {} entities, {} locations {} policies and {} enrichers", new Object[]{delta.entities(), delta.locations(), delta.policies(), delta.enrichers(), delta.removedEntityIds(), delta.removedLocationIds(), delta.removedPolicyIds(), delta.removedEnricherIds()});
        }
        for (EntityMemento entity : delta.entities()) {
            this.persist(entity);
        }
        for (LocationMemento location : delta.locations()) {
            this.persist(location);
        }
        for (PolicyMemento policy : delta.policies()) {
            this.persist(policy);
        }
        for (EnricherMemento enricher : delta.enrichers()) {
            this.persist(enricher);
        }
        for (CatalogItemMemento catalogItem : delta.catalogItems()) {
            this.persist(catalogItem);
        }
        for (String id : delta.removedEntityIds()) {
            this.deleteEntity(id);
        }
        for (String id : delta.removedLocationIds()) {
            this.deleteLocation(id);
        }
        for (String id : delta.removedPolicyIds()) {
            this.deletePolicy(id);
        }
        for (String id : delta.removedEnricherIds()) {
            this.deleteEnricher(id);
        }
        for (String id : delta.removedCatalogItemIds()) {
            this.deleteCatalogItem(id);
        }
    }

    public void queueDelta(BrooklynMementoPersister.Delta delta) {
        LOG.warn("Legacy persister ignoring queued delta: " + delta);
    }

    @VisibleForTesting
    public File getDir() {
        return this.dir;
    }

    @VisibleForTesting
    public void waitForWritesCompleted(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.waitForWritesCompleted(Duration.of((long)timeout, (TimeUnit)unit));
    }

    public void waitForWritesCompleted(Duration timeout) throws InterruptedException, TimeoutException {
        for (MementoFileWriter writer : this.entityWriters.values()) {
            writer.waitForWriteCompleted(timeout);
        }
        for (MementoFileWriter writer : this.locationWriters.values()) {
            writer.waitForWriteCompleted(timeout);
        }
        for (MementoFileWriter writer : this.policyWriters.values()) {
            writer.waitForWriteCompleted(timeout);
        }
        for (MementoFileWriter writer : this.enricherWriters.values()) {
            writer.waitForWriteCompleted(timeout);
        }
        for (MementoFileWriter writer : this.catalogItemWriters.values()) {
            writer.waitForWriteCompleted(timeout);
        }
    }

    public static void checkDirIsAccessible(File dir) {
        if (!(dir.exists() && dir.isDirectory() && dir.canRead() && dir.canWrite())) {
            throw new IllegalStateException("Invalid directory " + dir + " because " + (!dir.exists() ? "does not exist" : (!dir.isDirectory() ? "not a directory" : (!dir.canRead() ? "not readable" : (!dir.canWrite() ? "not writable" : "unknown reason")))));
        }
    }

    private String readFile(File file) throws IOException {
        return Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read();
    }

    private void persist(EntityMemento entity) {
        MementoFileWriter writer = (MementoFileWriter)this.entityWriters.get(entity.getId());
        if (writer == null) {
            this.entityWriters.putIfAbsent(entity.getId(), new MementoFileWriter<Object>(this.getFileFor(entity), this.executor, this.serializer));
            writer = (MementoFileWriter)this.entityWriters.get(entity.getId());
        }
        writer.write(entity);
    }

    private void persist(LocationMemento location) {
        MementoFileWriter writer = (MementoFileWriter)this.locationWriters.get(location.getId());
        if (writer == null) {
            this.locationWriters.putIfAbsent(location.getId(), new MementoFileWriter<Object>(this.getFileFor(location), this.executor, this.serializer));
            writer = (MementoFileWriter)this.locationWriters.get(location.getId());
        }
        writer.write(location);
    }

    private void persist(PolicyMemento policy) {
        MementoFileWriter writer = (MementoFileWriter)this.policyWriters.get(policy.getId());
        if (writer == null) {
            this.policyWriters.putIfAbsent(policy.getId(), new MementoFileWriter<Object>(this.getFileFor(policy), this.executor, this.serializer));
            writer = (MementoFileWriter)this.policyWriters.get(policy.getId());
        }
        writer.write(policy);
    }

    private void persist(EnricherMemento enricher) {
        MementoFileWriter writer = (MementoFileWriter)this.enricherWriters.get(enricher.getId());
        if (writer == null) {
            this.enricherWriters.putIfAbsent(enricher.getId(), new MementoFileWriter<Object>(this.getFileFor(enricher), this.executor, this.serializer));
            writer = (MementoFileWriter)this.enricherWriters.get(enricher.getId());
        }
        writer.write(enricher);
    }

    private void persist(CatalogItemMemento catalogItem) {
        MementoFileWriter writer = (MementoFileWriter)this.catalogItemWriters.get(catalogItem.getId());
        if (writer == null) {
            this.catalogItemWriters.putIfAbsent(catalogItem.getId(), new MementoFileWriter<Object>(this.getFileFor(catalogItem), this.executor, this.serializer));
            writer = (MementoFileWriter)this.catalogItemWriters.get(catalogItem.getId());
        }
        writer.write(catalogItem);
    }

    private void deleteEntity(String id) {
        MementoFileWriter writer = (MementoFileWriter)this.entityWriters.get(id);
        if (writer != null) {
            writer.delete();
        }
    }

    private void deleteLocation(String id) {
        MementoFileWriter writer = (MementoFileWriter)this.locationWriters.get(id);
        if (writer != null) {
            writer.delete();
        }
    }

    private void deletePolicy(String id) {
        MementoFileWriter writer = (MementoFileWriter)this.policyWriters.get(id);
        if (writer != null) {
            writer.delete();
        }
    }

    private void deleteEnricher(String id) {
        MementoFileWriter writer = (MementoFileWriter)this.enricherWriters.get(id);
        if (writer != null) {
            writer.delete();
        }
    }

    private void deleteCatalogItem(String id) {
        MementoFileWriter writer = (MementoFileWriter)this.catalogItemWriters.get(id);
        if (writer != null) {
            writer.delete();
        }
    }

    private File getFileFor(EntityMemento entity) {
        return this.getFileFor(this.entitiesDir, entity.getId());
    }

    private File getFileFor(LocationMemento location) {
        return this.getFileFor(this.locationsDir, location.getId());
    }

    private File getFileFor(PolicyMemento policy) {
        return this.getFileFor(this.policiesDir, policy.getId());
    }

    private File getFileFor(EnricherMemento enricher) {
        return this.getFileFor(this.enrichersDir, enricher.getId());
    }

    private File getFileFor(CatalogItemMemento catalogItem) {
        return this.getFileFor(this.catalogItemsDir, catalogItem.getId());
    }

    private File getFileFor(File parent, String id) {
        return new File(parent, Strings.makeValidFilename((String)id));
    }

    public String getBackingStoreDescription() {
        return this.toString();
    }
}

