/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.persister;

import brooklyn.entity.rebind.PersistenceExceptionHandler;
import brooklyn.entity.rebind.RebindExceptionHandler;
import brooklyn.entity.rebind.persister.AbstractBrooklynMementoPersister;
import brooklyn.entity.rebind.persister.MementoSerializer;
import brooklyn.entity.rebind.persister.XmlMementoSerializer;
import brooklyn.mementos.BrooklynMemento;
import brooklyn.mementos.BrooklynMementoPersister;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BrooklynMementoPersisterToFile
extends AbstractBrooklynMementoPersister {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynMementoPersisterToFile.class);
    private final File file;
    private final MementoSerializer<BrooklynMemento> serializer;
    private final Object mutex = new Object();

    public BrooklynMementoPersisterToFile(File file, ClassLoader classLoader) {
        this.file = file;
        this.serializer = new XmlMementoSerializer<BrooklynMemento>(classLoader);
    }

    @VisibleForTesting
    public void waitForWritesCompleted(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
    }

    @VisibleForTesting
    public void waitForWritesCompleted(Duration timeout) throws InterruptedException, TimeoutException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrooklynMemento loadMemento(BrooklynMementoPersister.LookupContext lookupContext, RebindExceptionHandler exceptionHandler) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String xml = this.readFile();
        this.serializer.setLookupContext(lookupContext);
        try {
            BrooklynMemento result = this.serializer.fromString(xml);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded memento; took {}", (Object)Time.makeTimeStringRounded((Stopwatch)stopwatch));
            }
            BrooklynMemento brooklynMemento = result;
            return brooklynMemento;
        }
        finally {
            this.serializer.unsetLookupContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                return Files.asCharSource((File)this.file, (Charset)Charsets.UTF_8).read();
            }
        }
        catch (IOException e) {
            LOG.error("Failed to persist memento", (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkpoint(BrooklynMemento newMemento, PersistenceExceptionHandler exceptionHandler) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Object object = this.mutex;
        synchronized (object) {
            long timeObtainedMutex = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            super.checkpoint(newMemento, exceptionHandler);
            long timeCheckpointed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            this.writeMemento();
            long timeWritten = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checkpointed memento; total={}ms, obtainingMutex={}ms, checkpointing={}ms, writing={}ms", new Object[]{timeWritten, timeObtainedMutex, timeCheckpointed - timeObtainedMutex, timeWritten - timeCheckpointed});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delta(BrooklynMementoPersister.Delta delta, PersistenceExceptionHandler exceptionHandler) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Object object = this.mutex;
        synchronized (object) {
            long timeObtainedMutex = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            super.delta(delta, exceptionHandler);
            long timeDeltad = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            this.writeMemento();
            long timeWritten = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checkpointed memento; total={}ms, obtainingMutex={}ms, delta'ing={}ms, writing={}", new Object[]{timeWritten, timeObtainedMutex, timeDeltad - timeObtainedMutex, timeWritten - timeDeltad});
            }
        }
    }

    private void writeMemento() {
        assert (Thread.holdsLock(this.mutex));
        try {
            Files.write((CharSequence)this.serializer.toString(this.memento), (File)this.file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error("Failed to persist memento", (Throwable)e);
        }
    }
}

