/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.persister;

import brooklyn.basic.BrooklynObject;
import brooklyn.catalog.CatalogItem;
import brooklyn.entity.Entity;
import brooklyn.entity.Feed;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.proxying.EntityProxy;
import brooklyn.entity.rebind.BrooklynObjectType;
import brooklyn.entity.rebind.PersistenceExceptionHandler;
import brooklyn.entity.rebind.PersistenceExceptionHandlerImpl;
import brooklyn.entity.rebind.RebindExceptionHandler;
import brooklyn.entity.rebind.RebindExceptionHandlerImpl;
import brooklyn.entity.rebind.RebindManager;
import brooklyn.entity.rebind.persister.AbstractBrooklynMementoPersister;
import brooklyn.entity.rebind.persister.BrooklynMementoPersisterToMultiFile;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import brooklyn.mementos.BrooklynMemento;
import brooklyn.mementos.BrooklynMementoManifest;
import brooklyn.mementos.BrooklynMementoPersister;
import brooklyn.policy.Enricher;
import brooklyn.policy.Policy;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.javalang.JavaClassNames;
import brooklyn.util.javalang.Reflections;
import brooklyn.util.os.Os;
import brooklyn.util.time.Duration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Deprecated
public class BrooklynMementoPersisterInMemory
extends AbstractBrooklynMementoPersister {
    private final ClassLoader classLoader;
    private final boolean checkPersistable;

    public BrooklynMementoPersisterInMemory(ClassLoader classLoader) {
        this(classLoader, true);
    }

    public BrooklynMementoPersisterInMemory(ClassLoader classLoader, boolean checkPersistable) {
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader");
        this.checkPersistable = checkPersistable;
    }

    @VisibleForTesting
    public void waitForWritesCompleted(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
    }

    @VisibleForTesting
    public void waitForWritesCompleted(Duration timeout) throws InterruptedException, TimeoutException {
    }

    @Override
    public void checkpoint(BrooklynMemento newMemento, PersistenceExceptionHandler exceptionHandler) {
        super.checkpoint(newMemento, exceptionHandler);
        if (this.checkPersistable) {
            this.reserializeMemento();
        }
    }

    @Override
    public void delta(BrooklynMementoPersister.Delta delta, PersistenceExceptionHandler exceptionHandler) {
        super.delta(delta, exceptionHandler);
        if (this.checkPersistable) {
            this.reserializeMemento();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reserializeMemento() {
        try {
            File tempDir = Os.newTempDir((String)JavaClassNames.cleanSimpleClassName((Object)this));
            try {
                BrooklynMementoPersisterToMultiFile persister = new BrooklynMementoPersisterToMultiFile(tempDir, this.classLoader);
                RebindExceptionHandler rebindExceptionHandler = RebindExceptionHandlerImpl.builder().danglingRefFailureMode(RebindManager.RebindFailureMode.FAIL_AT_END).rebindFailureMode(RebindManager.RebindFailureMode.FAIL_AT_END).build();
                PersistenceExceptionHandler persistenceExceptionHandler = PersistenceExceptionHandlerImpl.builder().build();
                persister.checkpoint(this.memento, persistenceExceptionHandler);
                final BrooklynMementoManifest manifest = persister.loadMementoManifest(null, rebindExceptionHandler);
                BrooklynMementoPersister.LookupContext dummyLookupContext = new BrooklynMementoPersister.LookupContext(){

                    public ManagementContext lookupManagementContext() {
                        return null;
                    }

                    public Entity lookupEntity(String id) {
                        MutableList types = MutableList.builder().add(Entity.class, EntityInternal.class, (Object[])new Class[]{EntityProxy.class}).add(this.loadClass(((BrooklynMementoManifest.EntityMementoManifest)manifest.getEntityIdToManifest().get(id)).getType())).build();
                        return (Entity)Proxy.newProxyInstance(BrooklynMementoPersisterInMemory.this.classLoader, types.toArray(new Class[types.size()]), new InvocationHandler(){

                            @Override
                            public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
                                return m.invoke((Object)this, args);
                            }
                        });
                    }

                    public Location lookupLocation(String id) {
                        Class<?> clazz = this.loadClass((String)manifest.getLocationIdToType().get(id));
                        return (Location)this.invokeConstructor(clazz, new Object[0], {MutableMap.of()});
                    }

                    public Policy lookupPolicy(String id) {
                        Class<?> clazz = this.loadClass((String)manifest.getPolicyIdToType().get(id));
                        return (Policy)this.invokeConstructor(clazz, new Object[0], {MutableMap.of()});
                    }

                    public Enricher lookupEnricher(String id) {
                        Class<?> clazz = this.loadClass((String)manifest.getEnricherIdToType().get(id));
                        return (Enricher)this.invokeConstructor(clazz, new Object[0], {MutableMap.of()});
                    }

                    public Feed lookupFeed(String id) {
                        Class<?> clazz = this.loadClass((String)manifest.getFeedIdToType().get(id));
                        return (Feed)this.invokeConstructor(clazz, new Object[0], {MutableMap.of()});
                    }

                    public CatalogItem<?, ?> lookupCatalogItem(String id) {
                        Class<?> clazz = this.loadClass(manifest.getCatalogItemMemento(id).getType());
                        return (CatalogItem)this.invokeConstructor(clazz, new Object[][]{new Object[0]});
                    }

                    public BrooklynObject lookup(BrooklynObjectType type, String id) {
                        switch (type) {
                            case CATALOG_ITEM: {
                                return this.lookupCatalogItem(id);
                            }
                            case ENRICHER: {
                                return this.lookupEnricher(id);
                            }
                            case ENTITY: {
                                return this.lookupEntity(id);
                            }
                            case FEED: {
                                return this.lookupFeed(id);
                            }
                            case LOCATION: {
                                return this.lookupLocation(id);
                            }
                            case POLICY: {
                                return this.lookupPolicy(id);
                            }
                            case UNKNOWN: {
                                return null;
                            }
                        }
                        throw new IllegalStateException("Unexpected type " + type + " / id " + id);
                    }

                    public BrooklynObject peek(BrooklynObjectType type, String id) {
                        return this.lookup(type, id);
                    }

                    private Class<?> loadClass(String name) {
                        try {
                            return BrooklynMementoPersisterInMemory.this.classLoader.loadClass(name);
                        }
                        catch (ClassNotFoundException e) {
                            throw Exceptions.propagate((Throwable)e);
                        }
                    }

                    private <T> T invokeConstructor(Class<T> clazz, Object[] ... possibleArgs) {
                        for (Object[] args : possibleArgs) {
                            try {
                                Optional v = Reflections.invokeConstructorWithArgs(clazz, (Object[])args, (boolean)true);
                                if (!v.isPresent()) continue;
                                return (T)v.get();
                            }
                            catch (Exception e) {
                                throw Exceptions.propagate((Throwable)e);
                            }
                        }
                        throw new IllegalStateException("Cannot instantiate instance of type " + clazz + "; expected constructor signature not found");
                    }
                };
                persister.loadMemento(null, dummyLookupContext, rebindExceptionHandler);
            }
            finally {
                Os.deleteRecursively((File)tempDir);
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

