/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.persister;

import brooklyn.entity.rebind.PersistenceExceptionHandler;
import brooklyn.entity.rebind.RebindExceptionHandler;
import brooklyn.entity.rebind.dto.BrooklynMementoManifestImpl;
import brooklyn.entity.rebind.dto.MutableBrooklynMemento;
import brooklyn.entity.rebind.persister.BrooklynMementoPersisterToObjectStore;
import brooklyn.mementos.BrooklynMemento;
import brooklyn.mementos.BrooklynMementoManifest;
import brooklyn.mementos.BrooklynMementoPersister;
import brooklyn.mementos.BrooklynMementoRawData;
import brooklyn.mementos.CatalogItemMemento;
import brooklyn.mementos.EnricherMemento;
import brooklyn.mementos.EntityMemento;
import brooklyn.mementos.LocationMemento;
import brooklyn.mementos.PolicyMemento;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractBrooklynMementoPersister
implements BrooklynMementoPersister {
    private static final Logger log = LoggerFactory.getLogger(AbstractBrooklynMementoPersister.class);
    protected volatile MutableBrooklynMemento memento = new MutableBrooklynMemento();

    public BrooklynMementoRawData loadMementoRawData(RebindExceptionHandler exceptionHandler) {
        return null;
    }

    public BrooklynMemento loadMemento(BrooklynMementoRawData mementoData, BrooklynMementoPersister.LookupContext lookupContext, RebindExceptionHandler exceptionHandler) {
        return this.memento;
    }

    public BrooklynMemento loadMemento(BrooklynMementoPersister.LookupContext lookupContext, RebindExceptionHandler exceptionHandler) {
        return this.loadMemento(null, lookupContext, exceptionHandler);
    }

    public BrooklynMementoManifest loadMementoManifest(RebindExceptionHandler exceptionHandler) {
        return this.loadMementoManifest(null, exceptionHandler);
    }

    public BrooklynMementoManifest loadMementoManifest(BrooklynMementoRawData mementoData, RebindExceptionHandler exceptionHandler) {
        BrooklynMementoManifestImpl.Builder builder = BrooklynMementoManifestImpl.builder();
        for (EntityMemento entityMemento : this.memento.getEntityMementos().values()) {
            builder.entity(entityMemento.getId(), entityMemento.getType(), entityMemento.getParent(), entityMemento.getCatalogItemId());
        }
        for (LocationMemento locationMemento : this.memento.getLocationMementos().values()) {
            builder.location(locationMemento.getId(), locationMemento.getType());
        }
        for (PolicyMemento policyMemento : this.memento.getPolicyMementos().values()) {
            builder.policy(policyMemento.getId(), policyMemento.getType());
        }
        for (EnricherMemento enricherMemento : this.memento.getEnricherMementos().values()) {
            builder.enricher(enricherMemento.getId(), enricherMemento.getType());
        }
        for (CatalogItemMemento catalogItemMemento : this.memento.getCatalogItemMementos().values()) {
            builder.catalogItem(catalogItemMemento);
        }
        return builder.build();
    }

    public void enableWriteAccess() {
    }

    public void disableWriteAccess(boolean graceful) {
    }

    public void stop(boolean graceful) {
    }

    public void checkpoint(BrooklynMemento newMemento, PersistenceExceptionHandler exceptionHandler) {
        this.memento.reset((BrooklynMemento)Preconditions.checkNotNull((Object)newMemento, (Object)"memento"));
    }

    public void checkpoint(BrooklynMementoRawData newMemento, PersistenceExceptionHandler exceptionHandler) {
        throw new IllegalStateException("Not supported; use " + BrooklynMementoPersisterToObjectStore.class);
    }

    public void delta(BrooklynMementoPersister.Delta delta, PersistenceExceptionHandler exceptionHanlder) {
        this.memento.removeEntities(delta.removedEntityIds());
        this.memento.removeLocations(delta.removedLocationIds());
        this.memento.removePolicies(delta.removedPolicyIds());
        this.memento.removeEnrichers(delta.removedEnricherIds());
        this.memento.removeCatalogItems(delta.removedCatalogItemIds());
        this.memento.updateEntityMementos(delta.entities());
        this.memento.updateLocationMementos(delta.locations());
        this.memento.updatePolicyMementos(delta.policies());
        this.memento.updateEnricherMementos(delta.enrichers());
        this.memento.updateCatalogItemMementos(delta.catalogItems());
    }

    public void queueDelta(BrooklynMementoPersister.Delta delta) {
        log.warn("Legacy persister ignoring queued delta: " + delta);
    }

    public String getBackingStoreDescription() {
        return this.toString();
    }
}

