/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.dto;

import brooklyn.mementos.BrooklynMemento;
import brooklyn.mementos.CatalogItemMemento;
import brooklyn.mementos.EnricherMemento;
import brooklyn.mementos.EntityMemento;
import brooklyn.mementos.FeedMemento;
import brooklyn.mementos.LocationMemento;
import brooklyn.mementos.PolicyMemento;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class MutableBrooklynMemento
implements BrooklynMemento {
    private static final long serialVersionUID = -442895028005849060L;
    private final Collection<String> applicationIds = Sets.newLinkedHashSet();
    private final Collection<String> topLevelLocationIds = Sets.newLinkedHashSet();
    private final Map<String, EntityMemento> entities = Maps.newLinkedHashMap();
    private final Map<String, LocationMemento> locations = Maps.newLinkedHashMap();
    private final Map<String, PolicyMemento> policies = Maps.newLinkedHashMap();
    private final Map<String, EnricherMemento> enrichers = Maps.newLinkedHashMap();
    private final Map<String, FeedMemento> feeds = Maps.newLinkedHashMap();
    private final Map<String, CatalogItemMemento> catalogItems = Maps.newLinkedHashMap();

    public MutableBrooklynMemento() {
    }

    public MutableBrooklynMemento(BrooklynMemento memento) {
        this.reset(memento);
    }

    public void reset(BrooklynMemento memento) {
        this.applicationIds.addAll(memento.getApplicationIds());
        this.topLevelLocationIds.addAll(memento.getTopLevelLocationIds());
        for (String entityId : memento.getEntityIds()) {
            this.entities.put(entityId, (EntityMemento)Preconditions.checkNotNull((Object)memento.getEntityMemento(entityId), (Object)entityId));
        }
        for (String locationId : memento.getLocationIds()) {
            this.locations.put(locationId, (LocationMemento)Preconditions.checkNotNull((Object)memento.getLocationMemento(locationId), (Object)locationId));
        }
    }

    public void updateEntityMemento(EntityMemento memento) {
        this.updateEntityMementos((Collection<EntityMemento>)ImmutableSet.of((Object)memento));
    }

    public void updateLocationMemento(LocationMemento memento) {
        this.updateLocationMementos((Collection<LocationMemento>)ImmutableSet.of((Object)memento));
    }

    public void updatePolicyMemento(PolicyMemento memento) {
        this.updatePolicyMementos((Collection<PolicyMemento>)ImmutableSet.of((Object)memento));
    }

    public void updateEnricherMemento(EnricherMemento memento) {
        this.updateEnricherMementos((Collection<EnricherMemento>)ImmutableSet.of((Object)memento));
    }

    public void updateFeedMemento(FeedMemento memento) {
        this.updateFeedMementos((Collection<FeedMemento>)ImmutableSet.of((Object)memento));
    }

    public void updateCatalogItemMemento(CatalogItemMemento memento) {
        this.updateCatalogItemMementos((Collection<CatalogItemMemento>)ImmutableSet.of((Object)memento));
    }

    public void updateEntityMementos(Collection<EntityMemento> mementos) {
        for (EntityMemento memento : mementos) {
            this.entities.put(memento.getId(), memento);
            if (!memento.isTopLevelApp()) continue;
            this.applicationIds.add(memento.getId());
        }
    }

    public void updateLocationMementos(Collection<LocationMemento> mementos) {
        for (LocationMemento locationMemento : mementos) {
            this.locations.put(locationMemento.getId(), locationMemento);
            if (locationMemento.getParent() != null) continue;
            this.topLevelLocationIds.add(locationMemento.getId());
        }
    }

    public void updatePolicyMementos(Collection<PolicyMemento> mementos) {
        for (PolicyMemento memento : mementos) {
            this.policies.put(memento.getId(), memento);
        }
    }

    public void updateEnricherMementos(Collection<EnricherMemento> mementos) {
        for (EnricherMemento memento : mementos) {
            this.enrichers.put(memento.getId(), memento);
        }
    }

    public void updateFeedMementos(Collection<FeedMemento> mementos) {
        for (FeedMemento memento : mementos) {
            this.feeds.put(memento.getId(), memento);
        }
    }

    public void updateCatalogItemMementos(Collection<CatalogItemMemento> mementos) {
        for (CatalogItemMemento memento : mementos) {
            this.catalogItems.put(memento.getId(), memento);
        }
    }

    public void removeEntities(Collection<String> ids) {
        this.entities.keySet().removeAll(ids);
        this.applicationIds.removeAll(ids);
    }

    public void removeLocations(Collection<String> ids) {
        this.locations.keySet().removeAll(ids);
        this.topLevelLocationIds.removeAll(ids);
    }

    public void removePolicies(Collection<String> ids) {
        this.policies.keySet().removeAll(ids);
    }

    public void removeEnrichers(Collection<String> ids) {
        this.enrichers.keySet().removeAll(ids);
    }

    public void removeFeeds(Collection<String> ids) {
        this.feeds.keySet().removeAll(ids);
    }

    public void removeCatalogItems(Collection<String> ids) {
        this.catalogItems.keySet().removeAll(ids);
    }

    public EntityMemento getEntityMemento(String id) {
        return this.entities.get(id);
    }

    public LocationMemento getLocationMemento(String id) {
        return this.locations.get(id);
    }

    public PolicyMemento getPolicyMemento(String id) {
        return this.policies.get(id);
    }

    public EnricherMemento getEnricherMemento(String id) {
        return this.enrichers.get(id);
    }

    public FeedMemento getFeedMemento(String id) {
        return this.feeds.get(id);
    }

    public CatalogItemMemento getCatalogItemMemento(String id) {
        return this.catalogItems.get(id);
    }

    public Collection<String> getApplicationIds() {
        return ImmutableList.copyOf(this.applicationIds);
    }

    public Collection<String> getEntityIds() {
        return Collections.unmodifiableSet(this.entities.keySet());
    }

    public Collection<String> getLocationIds() {
        return Collections.unmodifiableSet(this.locations.keySet());
    }

    public Collection<String> getPolicyIds() {
        return Collections.unmodifiableSet(this.policies.keySet());
    }

    public Collection<String> getEnricherIds() {
        return Collections.unmodifiableSet(this.enrichers.keySet());
    }

    public Collection<String> getFeedIds() {
        return Collections.unmodifiableSet(this.feeds.keySet());
    }

    public Collection<String> getCatalogItemIds() {
        return Collections.unmodifiableSet(this.catalogItems.keySet());
    }

    public Collection<String> getTopLevelLocationIds() {
        return Collections.unmodifiableCollection(this.topLevelLocationIds);
    }

    public Map<String, EntityMemento> getEntityMementos() {
        return ImmutableMap.copyOf(this.entities);
    }

    public Map<String, LocationMemento> getLocationMementos() {
        return ImmutableMap.copyOf(this.locations);
    }

    public Map<String, PolicyMemento> getPolicyMementos() {
        return ImmutableMap.copyOf(this.policies);
    }

    public Map<String, EnricherMemento> getEnricherMementos() {
        return ImmutableMap.copyOf(this.enrichers);
    }

    public Map<String, FeedMemento> getFeedMementos() {
        return ImmutableMap.copyOf(this.feeds);
    }

    public Map<String, CatalogItemMemento> getCatalogItemMementos() {
        return ImmutableMap.copyOf(this.catalogItems);
    }
}

