/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.dto;

import brooklyn.basic.BrooklynObject;
import brooklyn.basic.BrooklynTypes;
import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogItemDo;
import brooklyn.config.ConfigKey;
import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.Feed;
import brooklyn.entity.Group;
import brooklyn.entity.basic.EntityDynamicType;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.rebind.TreeUtils;
import brooklyn.entity.rebind.dto.AbstractMemento;
import brooklyn.entity.rebind.dto.BasicCatalogItemMemento;
import brooklyn.entity.rebind.dto.BasicEnricherMemento;
import brooklyn.entity.rebind.dto.BasicEntityMemento;
import brooklyn.entity.rebind.dto.BasicFeedMemento;
import brooklyn.entity.rebind.dto.BasicLocationMemento;
import brooklyn.entity.rebind.dto.BasicPolicyMemento;
import brooklyn.entity.rebind.dto.BrooklynMementoImpl;
import brooklyn.entity.rebind.dto.MementoValidators;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.AbstractFeed;
import brooklyn.location.Location;
import brooklyn.location.basic.LocationInternal;
import brooklyn.management.ManagementContext;
import brooklyn.management.Task;
import brooklyn.mementos.BrooklynMemento;
import brooklyn.mementos.CatalogItemMemento;
import brooklyn.mementos.EnricherMemento;
import brooklyn.mementos.EntityMemento;
import brooklyn.mementos.FeedMemento;
import brooklyn.mementos.LocationMemento;
import brooklyn.mementos.Memento;
import brooklyn.mementos.PolicyMemento;
import brooklyn.policy.Enricher;
import brooklyn.policy.EntityAdjunct;
import brooklyn.policy.Policy;
import brooklyn.policy.basic.AbstractPolicy;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.flags.FlagUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Set;

public class MementosGenerators {
    private MementosGenerators() {
    }

    public static Memento newMemento(BrooklynObject instance) {
        return MementosGenerators.newBasicMemento(instance);
    }

    @Beta
    public static Memento newBasicMemento(BrooklynObject instance) {
        if (instance instanceof Entity) {
            return MementosGenerators.newEntityMemento((Entity)instance);
        }
        if (instance instanceof Location) {
            return MementosGenerators.newLocationMemento((Location)instance);
        }
        if (instance instanceof Policy) {
            return MementosGenerators.newPolicyMemento((Policy)instance);
        }
        if (instance instanceof Enricher) {
            return MementosGenerators.newEnricherMemento((Enricher)instance);
        }
        if (instance instanceof Feed) {
            return MementosGenerators.newFeedMemento((Feed)instance);
        }
        if (instance instanceof CatalogItem) {
            return MementosGenerators.newCatalogItemMemento((CatalogItem)instance);
        }
        throw new IllegalArgumentException("Unexpected brooklyn type: " + (instance == null ? "null" : instance.getClass()) + " (" + instance + ")");
    }

    @Deprecated
    public static BrooklynMemento newBrooklynMemento(ManagementContext managementContext) {
        BrooklynMementoImpl.Builder builder = BrooklynMementoImpl.builder();
        for (Application app : managementContext.getApplications()) {
            builder.applicationIds.add(app.getId());
        }
        for (Entity entity : managementContext.getEntityManager().getEntities()) {
            builder.entities.put(entity.getId(), (EntityMemento)((EntityInternal)entity).getRebindSupport().getMemento());
            for (Location location : entity.getLocations()) {
                if (builder.locations.containsKey(location.getId())) continue;
                for (Location locationInHierarchy : TreeUtils.findLocationsInHierarchy(location)) {
                    if (builder.locations.containsKey(locationInHierarchy.getId())) continue;
                    builder.locations.put(locationInHierarchy.getId(), (LocationMemento)((LocationInternal)locationInHierarchy).getRebindSupport().getMemento());
                }
            }
        }
        for (LocationMemento memento : builder.locations.values()) {
            if (memento.getParent() != null) continue;
            builder.topLevelLocationIds.add(memento.getId());
        }
        BrooklynMemento result = builder.build();
        MementoValidators.validateMemento(result);
        return result;
    }

    @Deprecated
    public static EntityMemento newEntityMemento(Entity entity) {
        return MementosGenerators.newEntityMementoBuilder(entity).build();
    }

    @Deprecated
    public static BasicEntityMemento.Builder newEntityMementoBuilder(Entity entityRaw) {
        EntityInternal entity = (EntityInternal)entityRaw;
        BasicEntityMemento.Builder builder = BasicEntityMemento.builder();
        MementosGenerators.populateBrooklynObjectMementoBuilder(entity, builder);
        EntityDynamicType definedType = BrooklynTypes.getDefinedEntityType(entity.getClass());
        builder.effectors.addAll(entity.getEntityType().getEffectors());
        builder.effectors.removeAll(definedType.getEffectors().values());
        builder.isTopLevelApp = entity instanceof Application && entity.getParent() == null;
        Map<ConfigKey<?>, Object> localConfig = entity.getConfigMap().getLocalConfig();
        for (Map.Entry<ConfigKey<?>, Object> entry : localConfig.entrySet()) {
            ConfigKey configKey = (ConfigKey)Preconditions.checkNotNull(entry.getKey(), localConfig);
            Object value = MementosGenerators.configValueToPersistable(entry.getValue());
            builder.config.put(configKey, value);
        }
        MutableMap localConfigUnmatched = MutableMap.copyOf(entity.getConfigMap().getLocalConfigBag().getAllConfig());
        for (ConfigKey<?> configKey : localConfig.keySet()) {
            localConfigUnmatched.remove(configKey.getName());
        }
        for (Map.Entry entry : localConfigUnmatched.entrySet()) {
            String key = (String)Preconditions.checkNotNull(entry.getKey(), localConfig);
            Object value = entry.getValue();
            builder.configUnmatched.put(key, value);
        }
        Map<AttributeSensor, Object> allAttributes = entity.getAllAttributes();
        for (Map.Entry<AttributeSensor, Object> entry : allAttributes.entrySet()) {
            AttributeSensor key = (AttributeSensor)Preconditions.checkNotNull((Object)entry.getKey(), allAttributes);
            if (key.getPersistenceMode() == AttributeSensor.SensorPersistenceMode.NONE) continue;
            Object value = entry.getValue();
            builder.attributes.put(key, value);
        }
        for (Location location : entity.getLocations()) {
            builder.locations.add(location.getId());
        }
        for (Entity child : entity.getChildren()) {
            builder.children.add(child.getId());
        }
        for (Policy policy : entity.getPolicies()) {
            builder.policies.add(policy.getId());
        }
        for (Enricher enricher : entity.getEnrichers()) {
            builder.enrichers.add(enricher.getId());
        }
        for (Feed feed : entity.feeds().getFeeds()) {
            builder.feeds.add(feed.getId());
        }
        Entity entity2 = entity.getParent();
        String string = builder.parent = entity2 != null ? entity2.getId() : null;
        if (entity instanceof Group) {
            for (Entity member : ((Group)entity).getMembers()) {
                builder.members.add(member.getId());
            }
        }
        return builder;
    }

    @Deprecated
    public static Function<Entity, EntityMemento> entityMementoFunction() {
        return new Function<Entity, EntityMemento>(){

            public EntityMemento apply(Entity input) {
                return MementosGenerators.newEntityMemento(input);
            }
        };
    }

    @Deprecated
    public static LocationMemento newLocationMemento(Location location) {
        return MementosGenerators.newLocationMementoBuilder(location).build();
    }

    @Deprecated
    public static BasicLocationMemento.Builder newLocationMementoBuilder(Location location) {
        BasicLocationMemento.Builder builder = BasicLocationMemento.builder();
        MementosGenerators.populateBrooklynObjectMementoBuilder((BrooklynObject)location, builder);
        Set nonPersistableFlagNames = MutableMap.builder().putAll(FlagUtils.getFieldsWithFlagsWithModifiers(location, 128)).putAll(FlagUtils.getFieldsWithFlagsWithModifiers(location, 8)).put((Object)"id", String.class).filterValues(Predicates.not((Predicate)Predicates.instanceOf(ConfigKey.class))).build().keySet();
        MutableMap persistableFlags = MutableMap.builder().putAll(FlagUtils.getFieldsWithFlagsExcludingModifiers(location, 136)).removeAll((Iterable)nonPersistableFlagNames).build();
        ConfigBag persistableConfig = new ConfigBag().copy(((LocationInternal)location).config().getLocalBag()).removeAll(nonPersistableFlagNames);
        builder.copyConfig(persistableConfig);
        builder.locationConfig.putAll((Map<String, Object>)persistableFlags);
        Location parentLocation = location.getParent();
        builder.parent = parentLocation != null ? parentLocation.getId() : null;
        for (Location child : location.getChildren()) {
            builder.children.add(child.getId());
        }
        return builder;
    }

    @Deprecated
    public static Function<Location, LocationMemento> locationMementoFunction() {
        return new Function<Location, LocationMemento>(){

            public LocationMemento apply(Location input) {
                return MementosGenerators.newLocationMemento(input);
            }
        };
    }

    @Deprecated
    public static PolicyMemento newPolicyMemento(Policy policy) {
        BasicPolicyMemento.Builder builder = BasicPolicyMemento.builder();
        MementosGenerators.populateBrooklynObjectMementoBuilder((BrooklynObject)policy, builder);
        Map config = ((AbstractPolicy)policy).getConfigMap().getAllConfig();
        for (Map.Entry entry : config.entrySet()) {
            ConfigKey key = (ConfigKey)Preconditions.checkNotNull(entry.getKey(), (String)"config=%s", (Object[])new Object[]{config});
            Object value = MementosGenerators.configValueToPersistable(entry.getValue());
            builder.config.put(key.getName(), value);
        }
        MutableMap persistableFlags = MutableMap.builder().putAll(FlagUtils.getFieldsWithFlagsExcludingModifiers(policy, 136)).remove((Object)"id").remove((Object)"name").build();
        builder.config.putAll((Map<String, Object>)persistableFlags);
        return builder.build();
    }

    @Deprecated
    public static Function<Policy, PolicyMemento> policyMementoFunction() {
        return new Function<Policy, PolicyMemento>(){

            public PolicyMemento apply(Policy input) {
                return MementosGenerators.newPolicyMemento(input);
            }
        };
    }

    @Deprecated
    public static EnricherMemento newEnricherMemento(Enricher enricher) {
        BasicEnricherMemento.Builder builder = BasicEnricherMemento.builder();
        MementosGenerators.populateBrooklynObjectMementoBuilder((BrooklynObject)enricher, builder);
        Map config = ((AbstractEnricher)enricher).getConfigMap().getAllConfig();
        for (Map.Entry entry : config.entrySet()) {
            ConfigKey key = (ConfigKey)Preconditions.checkNotNull(entry.getKey(), (String)"config=%s", (Object[])new Object[]{config});
            Object value = MementosGenerators.configValueToPersistable(entry.getValue());
            builder.config.put(key.getName(), value);
        }
        MutableMap persistableFlags = MutableMap.builder().putAll(FlagUtils.getFieldsWithFlagsExcludingModifiers(enricher, 136)).remove((Object)"id").remove((Object)"name").build();
        builder.config.putAll((Map<String, Object>)persistableFlags);
        return builder.build();
    }

    @Deprecated
    public static FeedMemento newFeedMemento(Feed feed) {
        BasicFeedMemento.Builder builder = BasicFeedMemento.builder();
        MementosGenerators.populateBrooklynObjectMementoBuilder((BrooklynObject)feed, builder);
        Map config = ((AbstractFeed)feed).getConfigMap().getAllConfig();
        for (Map.Entry entry : config.entrySet()) {
            ConfigKey key = (ConfigKey)Preconditions.checkNotNull(entry.getKey(), (String)"config=%s", (Object[])new Object[]{config});
            Object value = MementosGenerators.configValueToPersistable(entry.getValue());
            builder.config.put(key.getName(), value);
        }
        return builder.build();
    }

    @Deprecated
    public static CatalogItemMemento newCatalogItemMemento(CatalogItem<?, ?> catalogItem) {
        if (catalogItem instanceof CatalogItemDo) {
            catalogItem = ((CatalogItemDo)catalogItem).getDto();
        }
        BasicCatalogItemMemento.Builder builder = BasicCatalogItemMemento.builder();
        MementosGenerators.populateBrooklynObjectMementoBuilder(catalogItem, builder);
        builder.catalogItemJavaType(catalogItem.getCatalogItemJavaType()).catalogItemType(catalogItem.getCatalogItemType()).description(catalogItem.getDescription()).iconUrl(catalogItem.getIconUrl()).javaType(catalogItem.getJavaType()).libraries(catalogItem.getLibraries()).symbolicName(catalogItem.getSymbolicName()).specType(catalogItem.getSpecType()).version(catalogItem.getVersion()).planYaml(catalogItem.getPlanYaml()).deprecated(catalogItem.isDeprecated());
        return builder.build();
    }

    private static void populateBrooklynObjectMementoBuilder(BrooklynObject instance, AbstractMemento.Builder<?> builder) {
        if (Proxy.isProxyClass(instance.getClass())) {
            throw new IllegalStateException("Attempt to create memento from proxy " + instance + " (would fail with wrong type)");
        }
        builder.id = instance.getId();
        builder.displayName = instance.getDisplayName();
        builder.catalogItemId = instance.getCatalogItemId();
        builder.type = instance.getClass().getName();
        builder.typeClass = instance.getClass();
        if (instance instanceof EntityAdjunct) {
            builder.uniqueTag = ((EntityAdjunct)instance).getUniqueTag();
        }
        for (Object tag : instance.tags().getTags()) {
            builder.tags.add(tag);
        }
    }

    protected static Object configValueToPersistable(Object value) {
        if (value instanceof Task) {
            Task task = (Task)value;
            if (task.isDone() && !task.isError()) {
                return task.getUnchecked();
            }
            return null;
        }
        return value;
    }

    public static Function<Enricher, EnricherMemento> enricherMementoFunction() {
        return new Function<Enricher, EnricherMemento>(){

            public EnricherMemento apply(Enricher input) {
                return MementosGenerators.newEnricherMemento(input);
            }
        };
    }

    public static Function<Feed, FeedMemento> feedMementoFunction() {
        return new Function<Feed, FeedMemento>(){

            public FeedMemento apply(Feed input) {
                return MementosGenerators.newFeedMemento(input);
            }
        };
    }
}

