/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.dto;

import brooklyn.entity.rebind.BrooklynObjectType;
import brooklyn.entity.rebind.dto.EntityMementoManifestImpl;
import brooklyn.mementos.BrooklynMementoManifest;
import brooklyn.mementos.CatalogItemMemento;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class BrooklynMementoManifestImpl
implements BrooklynMementoManifest,
Serializable {
    private static final long serialVersionUID = -7424713724226824486L;
    private final Map<String, BrooklynMementoManifest.EntityMementoManifest> entityIdToManifest;
    private final Map<String, String> locationIdToType;
    private final Map<String, String> policyIdToType;
    private final Map<String, String> enricherIdToType;
    private final Map<String, String> feedIdToType;
    private Map<String, CatalogItemMemento> catalogItems;

    public static Builder builder() {
        return new Builder();
    }

    private BrooklynMementoManifestImpl(Builder builder) {
        this.entityIdToManifest = builder.entityIdToManifest;
        this.locationIdToType = builder.locationIdToType;
        this.policyIdToType = builder.policyIdToType;
        this.enricherIdToType = builder.enricherIdToType;
        this.feedIdToType = builder.feedIdToType;
        this.catalogItems = builder.catalogItems;
    }

    public Map<String, BrooklynMementoManifest.EntityMementoManifest> getEntityIdToManifest() {
        return Collections.unmodifiableMap(this.entityIdToManifest);
    }

    public Map<String, String> getLocationIdToType() {
        return Collections.unmodifiableMap(this.locationIdToType);
    }

    public Map<String, String> getPolicyIdToType() {
        return Collections.unmodifiableMap(this.policyIdToType);
    }

    public Map<String, String> getEnricherIdToType() {
        return Collections.unmodifiableMap(this.enricherIdToType);
    }

    public Map<String, String> getFeedIdToType() {
        return Collections.unmodifiableMap(this.feedIdToType);
    }

    public CatalogItemMemento getCatalogItemMemento(String id) {
        return this.catalogItems.get(id);
    }

    public Collection<String> getCatalogItemIds() {
        return Collections.unmodifiableSet(this.catalogItems.keySet());
    }

    public Map<String, CatalogItemMemento> getCatalogItemMementos() {
        return Collections.unmodifiableMap(this.catalogItems);
    }

    public boolean isEmpty() {
        return this.entityIdToManifest.isEmpty() && this.locationIdToType.isEmpty() && this.policyIdToType.isEmpty() && this.enricherIdToType.isEmpty() && this.feedIdToType.isEmpty() && this.catalogItems.isEmpty();
    }

    public static class Builder {
        protected String brooklynVersion;
        protected final Map<String, BrooklynMementoManifest.EntityMementoManifest> entityIdToManifest = Maps.newConcurrentMap();
        protected final Map<String, String> locationIdToType = Maps.newConcurrentMap();
        protected final Map<String, String> policyIdToType = Maps.newConcurrentMap();
        protected final Map<String, String> enricherIdToType = Maps.newConcurrentMap();
        protected final Map<String, String> feedIdToType = Maps.newConcurrentMap();
        protected final Map<String, CatalogItemMemento> catalogItems = Maps.newConcurrentMap();

        public Builder brooklynVersion(String val) {
            this.brooklynVersion = val;
            return this;
        }

        public Builder entity(String id, String type, String parent, String catalogItemId) {
            this.entityIdToManifest.put(id, new EntityMementoManifestImpl(id, type, parent, catalogItemId));
            return this;
        }

        public Builder location(String id, String type) {
            this.locationIdToType.put(id, type);
            return this;
        }

        public Builder locations(Map<String, String> vals) {
            this.locationIdToType.putAll(vals);
            return this;
        }

        public Builder policy(String id, String type) {
            this.policyIdToType.put(id, type);
            return this;
        }

        public Builder policies(Map<String, String> vals) {
            this.policyIdToType.putAll(vals);
            return this;
        }

        public Builder enricher(String id, String type) {
            this.enricherIdToType.put(id, type);
            return this;
        }

        public Builder enrichers(Map<String, String> vals) {
            this.enricherIdToType.putAll(vals);
            return this;
        }

        public Builder feed(String id, String type) {
            this.feedIdToType.put(id, type);
            return this;
        }

        public Builder feed(Map<String, String> vals) {
            this.feedIdToType.putAll(vals);
            return this;
        }

        public Builder catalogItems(Map<String, CatalogItemMemento> vals) {
            this.catalogItems.putAll(vals);
            return this;
        }

        public Builder catalogItem(CatalogItemMemento val) {
            this.catalogItems.put(val.getId(), val);
            return this;
        }

        public Builder putType(BrooklynObjectType type, String id, String javaType) {
            switch (type) {
                case ENTITY: {
                    throw new IllegalArgumentException(type.toCamelCase() + " requires additional parameters");
                }
                case LOCATION: {
                    return this.location(id, javaType);
                }
                case POLICY: {
                    return this.policy(id, javaType);
                }
                case ENRICHER: {
                    return this.enricher(id, javaType);
                }
                case FEED: {
                    return this.feed(id, javaType);
                }
                case CATALOG_ITEM: {
                    throw new IllegalArgumentException(type.toCamelCase() + " requires different parameters");
                }
            }
            throw new IllegalArgumentException(type.toCamelCase() + " not supported");
        }

        public BrooklynMementoManifest build() {
            return new BrooklynMementoManifestImpl(this);
        }
    }
}

