/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.dto;

import brooklyn.BrooklynVersion;
import brooklyn.mementos.BrooklynMemento;
import brooklyn.mementos.CatalogItemMemento;
import brooklyn.mementos.EnricherMemento;
import brooklyn.mementos.EntityMemento;
import brooklyn.mementos.FeedMemento;
import brooklyn.mementos.LocationMemento;
import brooklyn.mementos.Memento;
import brooklyn.mementos.PolicyMemento;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BrooklynMementoImpl
implements BrooklynMemento,
Serializable {
    private static final long serialVersionUID = -5848083830410137654L;
    private String brooklynVersion;
    private List<String> applicationIds;
    private List<String> topLevelLocationIds;
    private Map<String, EntityMemento> entities;
    private Map<String, LocationMemento> locations;
    private Map<String, PolicyMemento> policies;
    private Map<String, EnricherMemento> enrichers;
    private Map<String, FeedMemento> feeds;
    private Map<String, CatalogItemMemento> catalogItems;

    public static Builder builder() {
        return new Builder();
    }

    private BrooklynMementoImpl(Builder builder) {
        this.brooklynVersion = builder.brooklynVersion;
        this.applicationIds = builder.applicationIds;
        this.topLevelLocationIds = builder.topLevelLocationIds;
        this.entities = builder.entities;
        this.locations = builder.locations;
        this.policies = builder.policies;
        this.enrichers = builder.enrichers;
        this.feeds = builder.feeds;
        this.catalogItems = builder.catalogItems;
    }

    public EntityMemento getEntityMemento(String id) {
        return this.entities.get(id);
    }

    public LocationMemento getLocationMemento(String id) {
        return this.locations.get(id);
    }

    public PolicyMemento getPolicyMemento(String id) {
        return this.policies.get(id);
    }

    public EnricherMemento getEnricherMemento(String id) {
        return this.enrichers.get(id);
    }

    public FeedMemento getFeedMemento(String id) {
        return this.feeds.get(id);
    }

    public CatalogItemMemento getCatalogItemMemento(String id) {
        return this.catalogItems.get(id);
    }

    public Collection<String> getApplicationIds() {
        return ImmutableList.copyOf(this.applicationIds);
    }

    public Collection<String> getEntityIds() {
        return Collections.unmodifiableSet(this.entities.keySet());
    }

    public Collection<String> getLocationIds() {
        return Collections.unmodifiableSet(this.locations.keySet());
    }

    public Collection<String> getPolicyIds() {
        return Collections.unmodifiableSet(this.policies.keySet());
    }

    public Collection<String> getEnricherIds() {
        return Collections.unmodifiableSet(this.enrichers.keySet());
    }

    public Collection<String> getCatalogItemIds() {
        return Collections.unmodifiableSet(this.catalogItems.keySet());
    }

    public Collection<String> getFeedIds() {
        return Collections.unmodifiableSet(this.feeds.keySet());
    }

    public Collection<String> getTopLevelLocationIds() {
        return Collections.unmodifiableList(this.topLevelLocationIds);
    }

    public Map<String, EntityMemento> getEntityMementos() {
        return Collections.unmodifiableMap(this.entities);
    }

    public Map<String, LocationMemento> getLocationMementos() {
        return Collections.unmodifiableMap(this.locations);
    }

    public Map<String, PolicyMemento> getPolicyMementos() {
        return Collections.unmodifiableMap(this.policies);
    }

    public Map<String, EnricherMemento> getEnricherMementos() {
        return Collections.unmodifiableMap(this.enrichers);
    }

    public Map<String, FeedMemento> getFeedMementos() {
        return Collections.unmodifiableMap(this.feeds);
    }

    public Map<String, CatalogItemMemento> getCatalogItemMementos() {
        return Collections.unmodifiableMap(this.catalogItems);
    }

    public static class Builder {
        protected String brooklynVersion = BrooklynVersion.get();
        protected final List<String> applicationIds = Collections.synchronizedList(Lists.newArrayList());
        protected final List<String> topLevelLocationIds = Collections.synchronizedList(Lists.newArrayList());
        protected final Map<String, EntityMemento> entities = Maps.newConcurrentMap();
        protected final Map<String, LocationMemento> locations = Maps.newConcurrentMap();
        protected final Map<String, PolicyMemento> policies = Maps.newConcurrentMap();
        protected final Map<String, EnricherMemento> enrichers = Maps.newConcurrentMap();
        protected final Map<String, FeedMemento> feeds = Maps.newConcurrentMap();
        protected final Map<String, CatalogItemMemento> catalogItems = Maps.newConcurrentMap();

        public Builder brooklynVersion(String val) {
            this.brooklynVersion = val;
            return this;
        }

        public Builder applicationId(String val) {
            this.applicationIds.add(val);
            return this;
        }

        public Builder applicationIds(Collection<String> vals) {
            this.applicationIds.addAll(vals);
            return this;
        }

        public Builder topLevelLocationIds(Collection<String> vals) {
            this.topLevelLocationIds.addAll(vals);
            return this;
        }

        public void memento(Memento memento) {
            if (memento instanceof EntityMemento) {
                this.entity((EntityMemento)memento);
            } else if (memento instanceof LocationMemento) {
                this.location((LocationMemento)memento);
            } else if (memento instanceof PolicyMemento) {
                this.policy((PolicyMemento)memento);
            } else if (memento instanceof EnricherMemento) {
                this.enricher((EnricherMemento)memento);
            } else if (memento instanceof FeedMemento) {
                this.feed((FeedMemento)memento);
            } else if (memento instanceof CatalogItemMemento) {
                this.catalogItem((CatalogItemMemento)memento);
            } else {
                throw new IllegalStateException("Unexpected memento type :" + memento);
            }
        }

        public Builder entities(Map<String, EntityMemento> vals) {
            this.entities.putAll(vals);
            return this;
        }

        public Builder locations(Map<String, LocationMemento> vals) {
            this.locations.putAll(vals);
            return this;
        }

        public Builder policy(PolicyMemento val) {
            this.policies.put(val.getId(), val);
            return this;
        }

        public Builder enricher(EnricherMemento val) {
            this.enrichers.put(val.getId(), val);
            return this;
        }

        public Builder feed(FeedMemento val) {
            this.feeds.put(val.getId(), val);
            return this;
        }

        public Builder entity(EntityMemento val) {
            this.entities.put(val.getId(), val);
            if (val.isTopLevelApp()) {
                this.applicationId(val.getId());
            }
            return this;
        }

        public Builder location(LocationMemento val) {
            this.locations.put(val.getId(), val);
            return this;
        }

        public Builder policies(Map<String, PolicyMemento> vals) {
            this.policies.putAll(vals);
            return this;
        }

        public Builder enrichers(Map<String, EnricherMemento> vals) {
            this.enrichers.putAll(vals);
            return this;
        }

        public Builder feeds(Map<String, FeedMemento> vals) {
            this.feeds.putAll(vals);
            return this;
        }

        public Builder catalogItems(Map<String, CatalogItemMemento> vals) {
            this.catalogItems.putAll(vals);
            return this;
        }

        public Builder catalogItem(CatalogItemMemento val) {
            this.catalogItems.put(val.getId(), val);
            return this;
        }

        public BrooklynMemento build() {
            return new BrooklynMementoImpl(this);
        }
    }
}

