/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.dto;

import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.entity.rebind.dto.AbstractMemento;
import brooklyn.mementos.CatalogItemMemento;
import brooklyn.mementos.Memento;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class BasicCatalogItemMemento
extends AbstractMemento
implements CatalogItemMemento,
Serializable {
    private static final long serialVersionUID = -2040630288193425950L;
    private String description;
    private String symbolicName;
    private String iconUrl;
    private String javaType;
    private String version;
    private String planYaml;
    private Collection<CatalogItem.CatalogBundle> libraries;
    private CatalogItem.CatalogItemType catalogItemType;
    private Class<?> catalogItemJavaType;
    private Class<?> specType;
    private boolean deprecated;

    public static Builder builder() {
        return new Builder();
    }

    private BasicCatalogItemMemento() {
    }

    protected BasicCatalogItemMemento(Builder builder) {
        super(builder);
        this.description = builder.description;
        this.symbolicName = builder.symbolicName;
        this.iconUrl = builder.iconUrl;
        this.version = builder.version;
        this.planYaml = builder.planYaml;
        this.libraries = builder.libraries;
        this.catalogItemJavaType = builder.catalogItemJavaType;
        this.catalogItemType = builder.catalogItemType;
        this.specType = builder.specType;
        this.javaType = builder.javaType;
        this.deprecated = builder.deprecated;
    }

    @Override
    public String getId() {
        return CatalogUtils.getVersionedId(this.getSymbolicName(), this.getVersion());
    }

    public String getDescription() {
        return this.description;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        return "0.0.0.SNAPSHOT";
    }

    public String getPlanYaml() {
        return this.planYaml;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public Collection<CatalogItem.CatalogBundle> getLibraries() {
        return this.libraries;
    }

    public CatalogItem.CatalogItemType getCatalogItemType() {
        return this.catalogItemType;
    }

    public Class<?> getCatalogItemJavaType() {
        return this.catalogItemJavaType;
    }

    public Class<?> getSpecType() {
        return this.specType;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    protected void setCustomFields(Map<String, Object> fields) {
        if (!fields.isEmpty()) {
            throw new UnsupportedOperationException("Cannot set custom fields on " + this + ". " + "Fields=" + Joiner.on((String)", ").join(fields.keySet()));
        }
    }

    @Override
    public Map<String, ? extends Object> getCustomFields() {
        return Collections.emptyMap();
    }

    @Override
    protected Objects.ToStringHelper newVerboseStringHelper() {
        return super.newVerboseStringHelper().add("description", (Object)this.getDescription()).add("symbolicName", (Object)this.getSymbolicName()).add("iconUrl", (Object)this.getIconUrl()).add("version", (Object)this.getVersion()).add("planYaml", (Object)this.getPlanYaml()).add("libraries", this.getLibraries()).add("catalogItemJavaType", this.getCatalogItemJavaType()).add("catalogItemType", (Object)this.getCatalogItemType()).add("javaType", (Object)this.getJavaType()).add("specType", this.getSpecType()).add("deprecated", this.isDeprecated());
    }

    public static class Builder
    extends AbstractMemento.Builder<Builder> {
        protected String description;
        protected String symbolicName;
        protected String iconUrl;
        protected String javaType;
        protected String version;
        protected String planYaml;
        protected Collection<CatalogItem.CatalogBundle> libraries;
        protected CatalogItem.CatalogItemType catalogItemType;
        protected Class<?> catalogItemJavaType;
        protected Class<?> specType;
        protected boolean deprecated;

        public Builder description(String description) {
            this.description = description;
            return (Builder)this.self();
        }

        public Builder symbolicName(String symbolicName) {
            this.symbolicName = symbolicName;
            return (Builder)this.self();
        }

        public Builder iconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return (Builder)this.self();
        }

        public Builder javaType(String javaType) {
            this.javaType = javaType;
            return (Builder)this.self();
        }

        public Builder version(String version) {
            this.version = version;
            return (Builder)this.self();
        }

        public Builder planYaml(String planYaml) {
            this.planYaml = planYaml;
            return (Builder)this.self();
        }

        public Builder libraries(Collection<CatalogItem.CatalogBundle> libraries) {
            this.libraries = libraries;
            return (Builder)this.self();
        }

        public Builder catalogItemType(CatalogItem.CatalogItemType catalogItemType) {
            this.catalogItemType = catalogItemType;
            return (Builder)this.self();
        }

        public Builder catalogItemJavaType(Class<?> catalogItemJavaType) {
            this.catalogItemJavaType = catalogItemJavaType;
            return (Builder)this.self();
        }

        public Builder specType(Class<?> specType) {
            this.specType = specType;
            return (Builder)this.self();
        }

        public Builder deprecated(boolean deprecated) {
            this.deprecated = deprecated;
            return (Builder)this.self();
        }

        public Builder from(CatalogItemMemento other) {
            super.from((Memento)other);
            this.description = other.getDescription();
            this.symbolicName = other.getSymbolicName();
            this.iconUrl = other.getIconUrl();
            this.javaType = other.getJavaType();
            this.version = other.getVersion();
            this.planYaml = other.getPlanYaml();
            this.libraries = other.getLibraries();
            this.catalogItemType = other.getCatalogItemType();
            this.catalogItemJavaType = other.getCatalogItemJavaType();
            this.specType = other.getSpecType();
            this.deprecated = other.isDeprecated();
            return (Builder)this.self();
        }

        public BasicCatalogItemMemento build() {
            return new BasicCatalogItemMemento(this);
        }
    }
}

