/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind.dto;

import brooklyn.BrooklynVersion;
import brooklyn.entity.basic.Sanitizer;
import brooklyn.mementos.Memento;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMemento
implements Memento,
Serializable {
    private static final long serialVersionUID = -8091049282749284567L;
    private String brooklynVersion;
    private String type;
    private String id;
    private String displayName;
    private String catalogItemId;
    private List<Object> tags;
    private String uniqueTag;
    private transient Class<?> typeClass;

    protected AbstractMemento() {
    }

    protected AbstractMemento(Builder<?> builder) {
        this.brooklynVersion = builder.brooklynVersion;
        this.id = builder.id;
        this.type = builder.type;
        this.typeClass = builder.typeClass;
        this.displayName = builder.displayName;
        this.catalogItemId = builder.catalogItemId;
        this.setCustomFields(builder.customFields);
        this.tags = this.toPersistedList(builder.tags);
        this.uniqueTag = builder.uniqueTag;
    }

    protected abstract void setCustomFields(Map<String, Object> var1);

    public void injectTypeClass(Class<?> clazz) {
        this.typeClass = clazz;
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public String getBrooklynVersion() {
        return this.brooklynVersion;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCatalogItemId() {
        return this.catalogItemId;
    }

    public List<Object> getTags() {
        return this.fromPersistedList(this.tags);
    }

    public String getUniqueTag() {
        return this.uniqueTag;
    }

    @Deprecated
    public Object getCustomField(String name) {
        if (this.getCustomFields() == null) {
            return null;
        }
        return this.getCustomFields().get(name);
    }

    @Deprecated
    public abstract Map<String, ? extends Object> getCustomFields();

    public String toString() {
        return Objects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("id", (Object)this.getId()).toString();
    }

    public String toVerboseString() {
        return this.newVerboseStringHelper().toString();
    }

    protected Objects.ToStringHelper newVerboseStringHelper() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("type", (Object)this.getType()).add("displayName", (Object)this.getDisplayName()).add("customFields", Sanitizer.sanitize(this.getCustomFields()));
    }

    protected <T> List<T> fromPersistedList(List<T> l) {
        if (l == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(l);
    }

    protected <T> List<T> toPersistedList(List<T> l) {
        if (l == null || l.isEmpty()) {
            return null;
        }
        return l;
    }

    protected <T> Set<T> fromPersistedSet(Set<T> l) {
        if (l == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(l);
    }

    protected <T> Set<T> toPersistedSet(Set<T> l) {
        if (l == null || l.isEmpty()) {
            return null;
        }
        return l;
    }

    protected <K, V> Map<K, V> fromPersistedMap(Map<K, V> m) {
        if (m == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(m);
    }

    protected <K, V> Map<K, V> toPersistedMap(Map<K, V> m) {
        if (m == null || m.isEmpty()) {
            return null;
        }
        return m;
    }

    protected static abstract class Builder<B extends Builder<?>> {
        protected String brooklynVersion = BrooklynVersion.get();
        protected String id;
        protected String type;
        protected Class<?> typeClass;
        protected String displayName;
        protected String catalogItemId;
        protected Map<String, Object> customFields = Maps.newLinkedHashMap();
        protected List<Object> tags = Lists.newArrayList();
        protected String uniqueTag;

        protected Builder() {
        }

        protected B self() {
            return (B)this;
        }

        public B from(Memento other) {
            this.brooklynVersion = other.getBrooklynVersion();
            this.id = other.getId();
            this.type = other.getType();
            this.typeClass = other.getTypeClass();
            this.displayName = other.getDisplayName();
            this.catalogItemId = other.getCatalogItemId();
            this.customFields.putAll(other.getCustomFields());
            this.tags.addAll(other.getTags());
            this.uniqueTag = other.getUniqueTag();
            return this.self();
        }

        @Deprecated
        public B customFields(Map<String, ?> vals) {
            this.customFields.putAll(vals);
            return this.self();
        }
    }
}

