/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind;

import brooklyn.basic.AbstractBrooklynObject;
import brooklyn.basic.BrooklynObject;
import brooklyn.basic.BrooklynObjectInternal;
import brooklyn.catalog.BrooklynCatalog;
import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogInitialization;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.config.BrooklynLogging;
import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.Feed;
import brooklyn.entity.basic.AbstractApplication;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.proxying.InternalEntityFactory;
import brooklyn.entity.proxying.InternalFactory;
import brooklyn.entity.proxying.InternalLocationFactory;
import brooklyn.entity.proxying.InternalPolicyFactory;
import brooklyn.entity.rebind.BrooklynObjectType;
import brooklyn.entity.rebind.PersisterDeltaImpl;
import brooklyn.entity.rebind.RebindContext;
import brooklyn.entity.rebind.RebindContextImpl;
import brooklyn.entity.rebind.RebindExceptionHandler;
import brooklyn.entity.rebind.RebindManagerImpl;
import brooklyn.entity.rebind.persister.PersistenceActivityMetrics;
import brooklyn.event.feed.AbstractFeed;
import brooklyn.internal.BrooklynFeatureEnablement;
import brooklyn.location.Location;
import brooklyn.location.basic.AbstractLocation;
import brooklyn.location.basic.LocationInternal;
import brooklyn.management.classloading.BrooklynClassLoadingContext;
import brooklyn.management.ha.ManagementNodeState;
import brooklyn.management.internal.BrooklynObjectManagementMode;
import brooklyn.management.internal.BrooklynObjectManagerInternal;
import brooklyn.management.internal.EntityManagerInternal;
import brooklyn.management.internal.LocationManagerInternal;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.management.internal.ManagementTransitionMode;
import brooklyn.mementos.BrooklynMemento;
import brooklyn.mementos.BrooklynMementoManifest;
import brooklyn.mementos.BrooklynMementoPersister;
import brooklyn.mementos.BrooklynMementoRawData;
import brooklyn.mementos.CatalogItemMemento;
import brooklyn.mementos.EnricherMemento;
import brooklyn.mementos.EntityMemento;
import brooklyn.mementos.FeedMemento;
import brooklyn.mementos.LocationMemento;
import brooklyn.mementos.Memento;
import brooklyn.mementos.PolicyMemento;
import brooklyn.mementos.TreeNode;
import brooklyn.policy.Enricher;
import brooklyn.policy.Policy;
import brooklyn.policy.basic.AbstractPolicy;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.guava.Maybe;
import brooklyn.util.javalang.Reflections;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RebindIteration {
    private static final Logger LOG = LoggerFactory.getLogger(RebindIteration.class);
    protected final RebindManagerImpl rebindManager;
    protected final ClassLoader classLoader;
    protected final RebindExceptionHandler exceptionHandler;
    protected final ManagementNodeState mode;
    protected final ManagementContextInternal managementContext;
    protected final Semaphore rebindActive;
    protected final AtomicInteger readOnlyRebindCount;
    protected final PersistenceActivityMetrics rebindMetrics;
    protected final BrooklynMementoPersister persistenceStoreAccess;
    protected final AtomicBoolean iterationStarted = new AtomicBoolean();
    protected final RebindContextImpl rebindContext;
    protected final Reflections reflections;
    protected final BrooklynObjectInstantiator instantiator;
    protected Stopwatch timer;
    protected int phase = 0;
    protected BrooklynMementoRawData mementoRawData;
    protected BrooklynMementoManifest mementoManifest;
    protected Boolean overwritingMaster;
    protected Boolean isEmpty;
    protected BrooklynMemento memento;
    protected List<Application> applications;

    public RebindIteration(RebindManagerImpl rebindManager, ManagementNodeState mode, ClassLoader classLoader, RebindExceptionHandler exceptionHandler, Semaphore rebindActive, AtomicInteger readOnlyRebindCount, PersistenceActivityMetrics rebindMetrics, BrooklynMementoPersister persistenceStoreAccess) {
        this.rebindManager = rebindManager;
        this.mode = mode;
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader");
        this.exceptionHandler = (RebindExceptionHandler)Preconditions.checkNotNull((Object)exceptionHandler, (Object)"exceptionHandler");
        this.rebindActive = rebindActive;
        this.readOnlyRebindCount = readOnlyRebindCount;
        this.rebindMetrics = rebindMetrics;
        this.persistenceStoreAccess = persistenceStoreAccess;
        this.managementContext = rebindManager.getManagementContext();
        this.rebindContext = new RebindContextImpl(this.managementContext, exceptionHandler, classLoader);
        this.reflections = new Reflections(classLoader);
        this.instantiator = new BrooklynObjectInstantiator(classLoader, this.rebindContext, this.reflections);
        if (mode == ManagementNodeState.HOT_STANDBY || mode == ManagementNodeState.HOT_BACKUP) {
            this.rebindContext.setAllReadOnly();
        } else {
            Preconditions.checkState((mode == ManagementNodeState.MASTER ? 1 : 0) != 0, (Object)("Must be either master or read only to rebind (mode " + mode + ")"));
        }
    }

    public List<Application> getApplications() {
        return this.applications;
    }

    RebindContextImpl getRebindContext() {
        return this.rebindContext;
    }

    protected void doRun() throws Exception {
        this.loadManifestFiles();
        this.rebuildCatalog();
        this.instantiateLocationsAndEntities();
        this.instantiateMementos();
        this.instantiateAdjuncts(this.instantiator);
        this.reconstructEverything();
        this.associateAdjunctsWithEntities();
        this.manageTheObjects();
        this.finishingUp();
    }

    protected abstract void loadManifestFiles() throws Exception;

    public void run() {
        if (this.iterationStarted.getAndSet(true)) {
            throw new IllegalStateException("Iteration " + this + " has already run; create a new instance for another rebind pass.");
        }
        try {
            this.rebindActive.acquire();
        }
        catch (InterruptedException e) {
            Exceptions.propagate((Throwable)e);
        }
        try {
            RebindManagerImpl.RebindTracker.setRebinding();
            if (ManagementNodeState.isHotProxy((ManagementNodeState)this.mode)) {
                this.readOnlyRebindCount.incrementAndGet();
            }
            this.timer = Stopwatch.createStarted();
            this.exceptionHandler.onStart((RebindContext)this.rebindContext);
            this.doRun();
            this.exceptionHandler.onDone();
            this.rebindMetrics.noteSuccess(Duration.of((Object)this.timer));
            this.noteErrors(this.exceptionHandler, null);
        }
        catch (Exception e) {
            this.rebindMetrics.noteFailure(Duration.of((Object)this.timer));
            Exceptions.propagateIfFatal((Throwable)e);
            this.noteErrors(this.exceptionHandler, e);
            throw this.exceptionHandler.onFailed(e);
        }
        finally {
            this.rebindActive.release();
            RebindManagerImpl.RebindTracker.reset();
        }
    }

    protected void checkEnteringPhase(int targetPhase) {
        ++this.phase;
        this.checkContinuingPhase(targetPhase);
    }

    protected void checkContinuingPhase(int targetPhase) {
        if (targetPhase != this.phase) {
            throw new IllegalStateException("Phase mismatch: should be phase " + targetPhase + " but is currently " + this.phase);
        }
    }

    protected void preprocessManifestFiles() throws Exception {
        this.checkContinuingPhase(1);
        Preconditions.checkState((this.mementoRawData != null ? 1 : 0) != 0, (Object)"Memento raw data should be set when calling this");
        Preconditions.checkState((this.mementoManifest == null ? 1 : 0) != 0, (Object)"Memento data should not yet be set when calling this");
        this.mementoManifest = this.persistenceStoreAccess.loadMementoManifest(this.mementoRawData, this.exceptionHandler);
        this.overwritingMaster = false;
        this.isEmpty = this.mementoManifest.isEmpty();
    }

    protected void rebuildCatalog() {
        boolean needsAdditionalItemsLoaded;
        boolean needsInitialItemsLoaded;
        this.checkEnteringPhase(2);
        if (this.rebindManager.persistCatalogItemsEnabled) {
            this.logRebindingDebug("RebindManager instantiating catalog items: {}", this.mementoManifest.getCatalogItemIds());
            for (CatalogItemMemento catalogItemMemento : this.mementoManifest.getCatalogItemMementos().values()) {
                this.logRebindingDebug("RebindManager instantiating catalog item {}", catalogItemMemento);
                try {
                    CatalogItem<?, ?> catalogItem = this.instantiator.newCatalogItem(catalogItemMemento);
                    this.rebindContext.registerCatalogItem(catalogItemMemento.getId(), catalogItem);
                }
                catch (Exception e) {
                    this.exceptionHandler.onCreateFailed(BrooklynObjectType.CATALOG_ITEM, catalogItemMemento.getId(), catalogItemMemento.getType(), e);
                }
            }
        } else {
            this.logRebindingDebug("Not rebinding catalog; feature disabled: {}", this.mementoManifest.getCatalogItemIds());
        }
        if (this.rebindManager.persistCatalogItemsEnabled) {
            this.logRebindingDebug("RebindManager reconstructing catalog items", new Object[0]);
            for (CatalogItemMemento catalogItemMemento : this.mementoManifest.getCatalogItemMementos().values()) {
                CatalogItem<?, ?> item = this.rebindContext.getCatalogItem(catalogItemMemento.getId());
                this.logRebindingDebug("RebindManager reconstructing catalog item {}", catalogItemMemento);
                if (item == null) {
                    this.exceptionHandler.onNotFound(BrooklynObjectType.CATALOG_ITEM, catalogItemMemento.getId());
                    continue;
                }
                try {
                    item.getRebindSupport().reconstruct((RebindContext)this.rebindContext, (Memento)catalogItemMemento);
                    if (!(item instanceof AbstractBrooklynObject)) continue;
                    ((AbstractBrooklynObject)AbstractBrooklynObject.class.cast(item)).setManagementContext(this.managementContext);
                }
                catch (Exception e) {
                    this.exceptionHandler.onRebindFailed(BrooklynObjectType.CATALOG_ITEM, item, e);
                }
            }
        }
        Collection<CatalogItem<?, ?>> catalogItems = this.rebindContext.getCatalogItems();
        CatalogInitialization catInit = this.managementContext.getCatalogInitialization();
        catInit.applyCatalogLoadMode();
        MutableList itemsForResettingCatalog = null;
        if (this.rebindManager.persistCatalogItemsEnabled) {
            if (!catInit.hasRunFinalInitialization() && catInit.isInitialResetRequested()) {
                String message = "RebindManager resetting catalog on first run (catalog persistence enabled, but reset explicitly specified). ";
                if (catalogItems.isEmpty()) {
                    message = message + "Catalog was empty anyway.";
                } else {
                    message = message + "Deleting " + catalogItems.size() + " persisted catalog item" + Strings.s(catalogItems) + ": " + catalogItems;
                    if (this.shouldLogRebinding()) {
                        LOG.info(message);
                    }
                }
                this.logRebindingDebug(message, new Object[0]);
                itemsForResettingCatalog = MutableList.of();
                PersisterDeltaImpl delta = new PersisterDeltaImpl();
                delta.removedCatalogItemIds.addAll(this.mementoRawData.getCatalogItems().keySet());
                this.getPersister().queueDelta((BrooklynMementoPersister.Delta)delta);
                this.mementoRawData.clearCatalogItems();
                this.rebindContext.clearCatalogItems();
                needsInitialItemsLoaded = true;
                needsAdditionalItemsLoaded = true;
            } else if (!this.isEmpty.booleanValue()) {
                this.logRebindingDebug("RebindManager clearing local catalog and loading from persisted state", new Object[0]);
                itemsForResettingCatalog = this.rebindContext.getCatalogItems();
                needsInitialItemsLoaded = false;
                needsAdditionalItemsLoaded = !catInit.hasRunFinalInitialization();
            } else if (catInit.hasRunFinalInitialization()) {
                this.logRebindingDebug("RebindManager has already done the final official run, not doing anything (even though persisted state empty)", new Object[0]);
                needsInitialItemsLoaded = false;
                needsAdditionalItemsLoaded = false;
            } else {
                this.logRebindingDebug("RebindManager loading initial catalog locally because persisted state empty and the final official run has not yet been performed", new Object[0]);
                needsInitialItemsLoaded = true;
                needsAdditionalItemsLoaded = true;
            }
        } else if (catInit.hasRunFinalInitialization()) {
            this.logRebindingDebug("RebindManager skipping catalog init because it has already run (catalog persistence disabled)", new Object[0]);
            needsInitialItemsLoaded = false;
            needsAdditionalItemsLoaded = false;
        } else {
            this.logRebindingDebug("RebindManager will initialize catalog locally because catalog persistence is disabled and the final official run has not yet been performed", new Object[0]);
            needsInitialItemsLoaded = true;
            needsAdditionalItemsLoaded = true;
        }
        catInit.populateCatalog(this.mode, needsInitialItemsLoaded, needsAdditionalItemsLoaded, (Collection<CatalogItem<?, ?>>)itemsForResettingCatalog);
    }

    protected void instantiateLocationsAndEntities() {
        this.checkEnteringPhase(3);
        this.logRebindingDebug("RebindManager instantiating locations: {}", this.mementoManifest.getLocationIdToType().keySet());
        for (Map.Entry entry : this.mementoManifest.getLocationIdToType().entrySet()) {
            String locId = (String)entry.getKey();
            String locType = (String)entry.getValue();
            if (LOG.isTraceEnabled()) {
                LOG.trace("RebindManager instantiating location {}", (Object)locId);
            }
            try {
                Location location = this.instantiator.newLocation(locId, locType);
                this.rebindContext.registerLocation(locId, location);
            }
            catch (Exception e) {
                this.exceptionHandler.onCreateFailed(BrooklynObjectType.LOCATION, locId, locType, e);
            }
        }
        this.logRebindingDebug("RebindManager instantiating entities: {}", this.mementoManifest.getEntityIdToManifest().keySet());
        for (Map.Entry entry : this.mementoManifest.getEntityIdToManifest().entrySet()) {
            String entityId = (String)entry.getKey();
            BrooklynMementoManifest.EntityMementoManifest entityManifest = (BrooklynMementoManifest.EntityMementoManifest)entry.getValue();
            if (LOG.isTraceEnabled()) {
                LOG.trace("RebindManager instantiating entity {}", (Object)entityId);
            }
            try {
                Entity entity = this.instantiator.newEntity(entityManifest);
                ((EntityInternal)entity).getManagementSupport().setReadOnly(this.rebindContext.isReadOnly((BrooklynObject)entity));
                this.rebindContext.registerEntity(entityId, entity);
            }
            catch (Exception e) {
                this.exceptionHandler.onCreateFailed(BrooklynObjectType.ENTITY, entityId, entityManifest.getType(), e);
            }
        }
    }

    protected void instantiateMementos() throws IOException {
        this.checkEnteringPhase(4);
        this.memento = this.persistenceStoreAccess.loadMemento(this.mementoRawData, this.rebindContext.lookup(), this.exceptionHandler);
    }

    protected void instantiateAdjuncts(BrooklynObjectInstantiator instantiator) {
        this.checkEnteringPhase(5);
        if (this.rebindManager.persistPoliciesEnabled) {
            this.logRebindingDebug("RebindManager instantiating policies: {}", this.memento.getPolicyIds());
            for (PolicyMemento policyMemento : this.memento.getPolicyMementos().values()) {
                this.logRebindingDebug("RebindManager instantiating policy {}", policyMemento);
                try {
                    Policy policy = instantiator.newPolicy(policyMemento);
                    this.rebindContext.registerPolicy(policyMemento.getId(), policy);
                }
                catch (Exception e) {
                    this.exceptionHandler.onCreateFailed(BrooklynObjectType.POLICY, policyMemento.getId(), policyMemento.getType(), e);
                }
            }
        } else {
            this.logRebindingDebug("Not rebinding policies; feature disabled: {}", this.memento.getPolicyIds());
        }
        if (this.rebindManager.persistEnrichersEnabled) {
            this.logRebindingDebug("RebindManager instantiating enrichers: {}", this.memento.getEnricherIds());
            for (EnricherMemento enricherMemento : this.memento.getEnricherMementos().values()) {
                this.logRebindingDebug("RebindManager instantiating enricher {}", enricherMemento);
                try {
                    Enricher enricher = instantiator.newEnricher(enricherMemento);
                    this.rebindContext.registerEnricher(enricherMemento.getId(), enricher);
                }
                catch (Exception e) {
                    this.exceptionHandler.onCreateFailed(BrooklynObjectType.ENRICHER, enricherMemento.getId(), enricherMemento.getType(), e);
                }
            }
        } else {
            this.logRebindingDebug("Not rebinding enrichers; feature disabled: {}", this.memento.getEnricherIds());
        }
        if (this.rebindManager.persistFeedsEnabled) {
            this.logRebindingDebug("RebindManager instantiating feeds: {}", this.memento.getFeedIds());
            for (FeedMemento feedMemento : this.memento.getFeedMementos().values()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RebindManager instantiating feed {}", (Object)feedMemento);
                }
                try {
                    Feed feed = instantiator.newFeed(feedMemento);
                    this.rebindContext.registerFeed(feedMemento.getId(), feed);
                }
                catch (Exception e) {
                    this.exceptionHandler.onCreateFailed(BrooklynObjectType.FEED, feedMemento.getId(), feedMemento.getType(), e);
                }
            }
        } else {
            this.logRebindingDebug("Not rebinding feeds; feature disabled: {}", this.memento.getFeedIds());
        }
    }

    protected void reconstructEverything() {
        this.checkEnteringPhase(6);
        this.logRebindingDebug("RebindManager reconstructing locations", new Object[0]);
        for (LocationMemento locMemento : this.sortParentFirst(this.memento.getLocationMementos()).values()) {
            Location location = this.rebindContext.getLocation(locMemento.getId());
            this.logRebindingDebug("RebindManager reconstructing location {}", locMemento);
            if (location == null) {
                this.exceptionHandler.onNotFound(BrooklynObjectType.LOCATION, locMemento.getId());
                continue;
            }
            try {
                ((LocationInternal)location).getRebindSupport().reconstruct((RebindContext)this.rebindContext, (Memento)locMemento);
            }
            catch (Exception e) {
                this.exceptionHandler.onRebindFailed(BrooklynObjectType.LOCATION, (BrooklynObject)location, e);
            }
        }
        if (this.rebindManager.persistPoliciesEnabled) {
            this.logRebindingDebug("RebindManager reconstructing policies", new Object[0]);
            for (PolicyMemento policyMemento : this.memento.getPolicyMementos().values()) {
                Policy policy = this.rebindContext.getPolicy(policyMemento.getId());
                this.logRebindingDebug("RebindManager reconstructing policy {}", policyMemento);
                if (policy == null) {
                    this.exceptionHandler.onNotFound(BrooklynObjectType.POLICY, policyMemento.getId());
                    continue;
                }
                try {
                    policy.getRebindSupport().reconstruct((RebindContext)this.rebindContext, (Memento)policyMemento);
                }
                catch (Exception e) {
                    this.exceptionHandler.onRebindFailed(BrooklynObjectType.POLICY, (BrooklynObject)policy, e);
                    this.rebindContext.unregisterPolicy(policy);
                }
            }
        }
        if (this.rebindManager.persistEnrichersEnabled) {
            this.logRebindingDebug("RebindManager reconstructing enrichers", new Object[0]);
            for (EnricherMemento enricherMemento : this.memento.getEnricherMementos().values()) {
                Enricher enricher = this.rebindContext.getEnricher(enricherMemento.getId());
                this.logRebindingDebug("RebindManager reconstructing enricher {}", enricherMemento);
                if (enricher == null) {
                    this.exceptionHandler.onNotFound(BrooklynObjectType.ENRICHER, enricherMemento.getId());
                    continue;
                }
                try {
                    enricher.getRebindSupport().reconstruct((RebindContext)this.rebindContext, (Memento)enricherMemento);
                }
                catch (Exception e) {
                    this.exceptionHandler.onRebindFailed(BrooklynObjectType.ENRICHER, (BrooklynObject)enricher, e);
                    this.rebindContext.unregisterEnricher(enricher);
                }
            }
        }
        if (this.rebindManager.persistFeedsEnabled) {
            this.logRebindingDebug("RebindManager reconstructing feeds", new Object[0]);
            for (FeedMemento feedMemento : this.memento.getFeedMementos().values()) {
                Feed feed = this.rebindContext.getFeed(feedMemento.getId());
                this.logRebindingDebug("RebindManager reconstructing feed {}", feedMemento);
                if (feed == null) {
                    this.exceptionHandler.onNotFound(BrooklynObjectType.FEED, feedMemento.getId());
                    continue;
                }
                try {
                    feed.getRebindSupport().reconstruct((RebindContext)this.rebindContext, (Memento)feedMemento);
                }
                catch (Exception e) {
                    this.exceptionHandler.onRebindFailed(BrooklynObjectType.FEED, (BrooklynObject)feed, e);
                    this.rebindContext.unregisterFeed(feed);
                }
            }
        }
        this.logRebindingDebug("RebindManager reconstructing entities", new Object[0]);
        for (EntityMemento entityMemento : this.sortParentFirst(this.memento.getEntityMementos()).values()) {
            Entity entity = this.rebindContext.lookup().lookupEntity(entityMemento.getId());
            this.logRebindingDebug("RebindManager reconstructing entity {}", entityMemento);
            if (entity == null) {
                this.exceptionHandler.onNotFound(BrooklynObjectType.ENTITY, entityMemento.getId());
                continue;
            }
            try {
                entityMemento.injectTypeClass(entity.getClass());
                ((EntityInternal)entity).getRebindSupport().reconstruct((RebindContext)this.rebindContext, (Memento)entityMemento);
            }
            catch (Exception e) {
                this.exceptionHandler.onRebindFailed(BrooklynObjectType.ENTITY, (BrooklynObject)entity, e);
            }
        }
    }

    protected void associateAdjunctsWithEntities() {
        this.checkEnteringPhase(7);
        this.logRebindingDebug("RebindManager associating adjuncts to entities", new Object[0]);
        for (EntityMemento entityMemento : this.sortParentFirst(this.memento.getEntityMementos()).values()) {
            Entity entity = this.rebindContext.getEntity(entityMemento.getId());
            this.logRebindingDebug("RebindManager associating adjuncts to entity {}", entityMemento);
            if (entity == null) {
                this.exceptionHandler.onNotFound(BrooklynObjectType.ENTITY, entityMemento.getId());
                continue;
            }
            try {
                entityMemento.injectTypeClass(entity.getClass());
                ((EntityInternal)entity).getRebindSupport().addPolicies((RebindContext)this.rebindContext, (Memento)entityMemento);
                ((EntityInternal)entity).getRebindSupport().addEnrichers((RebindContext)this.rebindContext, (Memento)entityMemento);
                ((EntityInternal)entity).getRebindSupport().addFeeds((RebindContext)this.rebindContext, (Memento)entityMemento);
            }
            catch (Exception e) {
                this.exceptionHandler.onRebindFailed(BrooklynObjectType.ENTITY, (BrooklynObject)entity, e);
            }
        }
    }

    protected void manageTheObjects() {
        this.checkEnteringPhase(8);
        this.logRebindingDebug("RebindManager managing locations", new Object[0]);
        LocationManagerInternal locationManager = (LocationManagerInternal)this.managementContext.getLocationManager();
        LinkedHashSet oldLocations = Sets.newLinkedHashSet(locationManager.getLocationIds());
        for (Location location : this.rebindContext.getLocations()) {
            ManagementTransitionMode oldMode = this.updateTransitionMode(locationManager, location);
            if (oldMode == null) continue;
            oldLocations.remove(location.getId());
        }
        for (Location location : this.rebindContext.getLocations()) {
            if (location.getParent() != null) continue;
            try {
                ((LocationManagerInternal)this.managementContext.getLocationManager()).manageRebindedRoot((BrooklynObject)location);
            }
            catch (Exception e) {
                this.exceptionHandler.onManageFailed(BrooklynObjectType.LOCATION, (BrooklynObject)location, e);
            }
        }
        this.cleanupOldLocations(oldLocations);
        this.logRebindingDebug("RebindManager managing entities", new Object[0]);
        EntityManagerInternal entityManager = (EntityManagerInternal)this.managementContext.getEntityManager();
        LinkedHashSet oldEntities = Sets.newLinkedHashSet(entityManager.getEntityIds());
        for (Entity entity : this.rebindContext.getEntities()) {
            ManagementTransitionMode oldMode = this.updateTransitionMode(entityManager, entity);
            if (oldMode == null) continue;
            oldEntities.remove(entity.getId());
        }
        ArrayList apps = Lists.newArrayList();
        for (String rootId : this.getMementoRootEntities()) {
            Entity entity = this.rebindContext.getEntity(rootId);
            if (entity == null) {
                this.exceptionHandler.onNotFound(BrooklynObjectType.ENTITY, rootId);
                continue;
            }
            try {
                entityManager.manageRebindedRoot((BrooklynObject)entity);
            }
            catch (Exception e) {
                this.exceptionHandler.onManageFailed(BrooklynObjectType.ENTITY, (BrooklynObject)entity, e);
            }
            if (!(entity instanceof Application)) continue;
            apps.add((Application)entity);
        }
        this.cleanupOldEntities(oldEntities);
        this.applications = apps;
    }

    private <T extends BrooklynObject> ManagementTransitionMode updateTransitionMode(BrooklynObjectManagerInternal<T> boManager, T bo) {
        BrooklynObjectManagementMode modeAfter;
        ManagementTransitionMode oldTransitionMode = boManager.getLastManagementTransitionMode(bo.getId());
        Boolean isNowReadOnly = this.rebindContext.isReadOnly(bo);
        BrooklynObjectManagementMode modeBefore = oldTransitionMode == null ? BrooklynObjectManagementMode.UNMANAGED_PERSISTED : oldTransitionMode.getModeAfter();
        if (this.isRebindingActiveAgain()) {
            Preconditions.checkState((!Boolean.TRUE.equals(isNowReadOnly) ? 1 : 0) != 0);
            Preconditions.checkState((modeBefore == BrooklynObjectManagementMode.MANAGED_PRIMARY ? 1 : 0) != 0);
            modeAfter = BrooklynObjectManagementMode.MANAGED_PRIMARY;
        } else {
            modeAfter = isNowReadOnly != false ? BrooklynObjectManagementMode.LOADED_READ_ONLY : BrooklynObjectManagementMode.MANAGED_PRIMARY;
        }
        ManagementTransitionMode newTransitionMode = ManagementTransitionMode.transitioning(modeBefore, modeAfter);
        boManager.setManagementTransitionMode(bo, newTransitionMode);
        return oldTransitionMode;
    }

    protected abstract boolean isRebindingActiveAgain();

    protected Collection<String> getMementoRootEntities() {
        return this.memento.getApplicationIds();
    }

    protected abstract void cleanupOldLocations(Set<String> var1);

    protected abstract void cleanupOldEntities(Set<String> var1);

    protected void finishingUp() {
        this.checkContinuingPhase(8);
        if (!this.isEmpty.booleanValue()) {
            BrooklynLogging.log(LOG, this.shouldLogRebinding() ? BrooklynLogging.LoggingLevel.INFO : BrooklynLogging.LoggingLevel.DEBUG, "Rebind complete (" + this.mode + (this.readOnlyRebindCount.get() >= 0 ? ", iteration " + this.readOnlyRebindCount : "") + ")" + " in {}: {} app{}, {} entit{}, {} location{}, {} polic{}, {} enricher{}, {} feed{}, {} catalog item{}", Time.makeTimeStringRounded((Stopwatch)this.timer), this.applications.size(), Strings.s(this.applications), this.rebindContext.getEntities().size(), Strings.ies(this.rebindContext.getEntities()), this.rebindContext.getLocations().size(), Strings.s(this.rebindContext.getLocations()), this.rebindContext.getPolicies().size(), Strings.ies(this.rebindContext.getPolicies()), this.rebindContext.getEnrichers().size(), Strings.s(this.rebindContext.getEnrichers()), this.rebindContext.getFeeds().size(), Strings.s(this.rebindContext.getFeeds()), this.rebindContext.getCatalogItems().size(), Strings.s(this.rebindContext.getCatalogItems()));
        }
        this.logRebindingDebug("RebindManager complete; apps: {}", this.getMementoRootEntities());
    }

    protected void noteErrors(RebindExceptionHandler exceptionHandler, Exception primaryException) {
        List exceptions = exceptionHandler.getExceptions();
        List warnings = exceptionHandler.getWarnings();
        if (primaryException != null || !exceptions.isEmpty() || !warnings.isEmpty()) {
            MutableList messages = MutableList.of();
            if (primaryException != null) {
                messages.add(primaryException.toString());
            }
            for (Exception e : exceptions) {
                messages.add(e.toString());
            }
            for (String w : warnings) {
                messages.add(w);
            }
            this.rebindMetrics.noteError((List<?>)messages);
        }
    }

    protected String findCatalogItemId(ClassLoader cl, Map<String, BrooklynMementoManifest.EntityMementoManifest> entityIdToManifest, BrooklynMementoManifest.EntityMementoManifest entityManifest) {
        if (entityManifest.getCatalogItemId() != null) {
            return entityManifest.getCatalogItemId();
        }
        if (BrooklynFeatureEnablement.isEnabled("brooklyn.backwardCompatibility.feature.inferCatalogItemOnRebind")) {
            BrooklynMementoManifest.EntityMementoManifest ptr = entityManifest;
            while (ptr != null) {
                if (ptr.getCatalogItemId() != null) {
                    CatalogItem<?, ?> catalogItem = CatalogUtils.getCatalogItemOptionalVersion(this.managementContext, ptr.getCatalogItemId());
                    if (catalogItem != null) {
                        return catalogItem.getId();
                    }
                    return ptr.getCatalogItemId();
                }
                if (ptr.getParent() != null) {
                    ptr = entityIdToManifest.get(ptr.getParent());
                    continue;
                }
                ptr = null;
            }
            BrooklynCatalog catalog = this.managementContext.getCatalog();
            ptr = entityManifest;
            while (ptr != null) {
                CatalogItem catalogItem = catalog.getCatalogItem(ptr.getType(), "0.0.0_DEFAULT_VERSION");
                if (catalogItem != null) {
                    LOG.debug("Inferred catalog item ID " + catalogItem.getId() + " for " + entityManifest + " from ancestor " + ptr);
                    return catalogItem.getId();
                }
                if (ptr.getParent() != null) {
                    ptr = entityIdToManifest.get(ptr.getParent());
                    continue;
                }
                ptr = null;
            }
            try {
                cl.loadClass(entityManifest.getType());
                return null;
            }
            catch (ClassNotFoundException e) {
                for (CatalogItem item : catalog.getCatalogItems()) {
                    BrooklynClassLoadingContext loader = CatalogUtils.newClassLoadingContext(this.managementContext, item);
                    boolean canLoadClass = loader.tryLoadClass(entityManifest.getType()).isPresent();
                    if (!canLoadClass) continue;
                    LOG.warn("Missing catalog item for " + entityManifest.getId() + ", inferring as " + item.getId() + " because that is able to load the item");
                    return item.getId();
                }
            }
        }
        return null;
    }

    protected BrooklynMementoPersister getPersister() {
        return this.rebindManager.getPersister();
    }

    protected <T extends TreeNode> Map<String, T> sortParentFirst(Map<String, T> nodes) {
        return RebindManagerImpl.sortParentFirst(nodes);
    }

    protected void logRebindingDebug(String message, Object ... args) {
        if (this.shouldLogRebinding()) {
            LOG.debug(message, args);
        } else {
            LOG.trace(message, args);
        }
    }

    protected boolean shouldLogRebinding() {
        return this.readOnlyRebindCount.get() < 5 || this.readOnlyRebindCount.get() % 1000 == 0;
    }

    protected class BrooklynObjectInstantiator {
        protected final ClassLoader classLoader;
        protected final RebindContextImpl rebindContext;
        protected final Reflections reflections;

        protected BrooklynObjectInstantiator(ClassLoader classLoader, RebindContextImpl rebindContext, Reflections reflections) {
            this.classLoader = classLoader;
            this.rebindContext = rebindContext;
            this.reflections = reflections;
        }

        protected Entity newEntity(BrooklynMementoManifest.EntityMementoManifest entityManifest) {
            Object entity;
            String entityId = entityManifest.getId();
            String catalogItemId = RebindIteration.this.findCatalogItemId(this.classLoader, RebindIteration.this.mementoManifest.getEntityIdToManifest(), entityManifest);
            String entityType = entityManifest.getType();
            LoadedClass<Entity> loaded = this.load(Entity.class, entityType, catalogItemId, entityId);
            Class entityClazz = loaded.clazz;
            String transformedCatalogItemId = loaded.catalogItemId;
            if (InternalFactory.isNewStyle(entityClazz)) {
                InternalEntityFactory entityFactory = RebindIteration.this.managementContext.getEntityFactory();
                entity = entityFactory.constructEntity(entityClazz, Reflections.getAllInterfaces(entityClazz), entityId);
            } else {
                LOG.warn("Deprecated rebind of entity without no-arg constructor; this may not be supported in future versions: id=" + entityId + "; type=" + entityType);
                LinkedHashMap flags = Maps.newLinkedHashMap();
                flags.put("id", entityId);
                if (AbstractApplication.class.isAssignableFrom(entityClazz)) {
                    flags.put("mgmt", RebindIteration.this.managementContext);
                }
                entity = (Entity)this.invokeConstructor(null, entityClazz, {flags}, {flags, null}, {null}, new Object[0]);
                FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"id", (Object)entityId), entity);
                if (entity instanceof AbstractApplication) {
                    FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"mgmt", (Object)RebindIteration.this.managementContext), entity);
                }
                ((AbstractEntity)entity).setManagementContext(RebindIteration.this.managementContext);
                RebindIteration.this.managementContext.prePreManage((Entity)entity);
            }
            this.setCatalogItemId((BrooklynObject)entity, transformedCatalogItemId);
            return entity;
        }

        protected void setCatalogItemId(BrooklynObject item, String catalogItemId) {
            if (catalogItemId != null) {
                ((BrooklynObjectInternal)item).setCatalogItemId(catalogItemId);
            }
        }

        protected <T extends BrooklynObject> LoadedClass<? extends T> load(Class<T> bType, Memento memento) {
            return this.load(bType, memento.getType(), memento.getCatalogItemId(), memento.getId());
        }

        protected <T extends BrooklynObject> LoadedClass<? extends T> load(Class<T> bType, String jType, String catalogItemId, String contextSuchAsId) {
            Preconditions.checkNotNull((Object)jType, (String)"Type of %s (%s) must not be null", (Object[])new Object[]{contextSuchAsId, bType.getSimpleName()});
            if (catalogItemId != null) {
                CatalogItem catalogItem = this.rebindContext.lookup().lookupCatalogItem(catalogItemId);
                if (catalogItem == null && BrooklynFeatureEnablement.isEnabled("brooklyn.quickfix.fixDanglingCatalogItemOnRebind") && CatalogUtils.looksLikeVersionedId(catalogItemId)) {
                    String symbolicName = CatalogUtils.getIdFromVersionedId(catalogItemId);
                    catalogItem = this.rebindContext.lookup().lookupCatalogItem(symbolicName);
                    if (catalogItem != null) {
                        LOG.warn("Unable to load catalog item " + catalogItemId + " for " + contextSuchAsId + " (" + bType.getSimpleName() + "); will auto-upgrade to " + catalogItem.getCatalogItemId());
                        catalogItemId = catalogItem.getCatalogItemId();
                    }
                }
                if (catalogItem != null) {
                    BrooklynClassLoadingContext loader = CatalogUtils.newClassLoadingContext(RebindIteration.this.managementContext, catalogItem);
                    return new LoadedClass(loader.loadClass(jType, bType), catalogItemId);
                }
                LOG.warn("Unable to load catalog item " + catalogItemId + " for " + contextSuchAsId + " (" + bType.getSimpleName() + "); will try default class loader");
            }
            try {
                return new LoadedClass(this.reflections.loadClass(jType), catalogItemId);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                LOG.warn("Unable to load " + jType + " using reflections; will try standard context");
                if (catalogItemId != null) {
                    throw new IllegalStateException("Unable to load catalog item " + catalogItemId + " for " + contextSuchAsId + ", or load class from classpath");
                }
                if (BrooklynFeatureEnablement.isEnabled("brooklyn.backwardCompatibility.feature.inferCatalogItemOnRebind")) {
                    BrooklynCatalog catalog = RebindIteration.this.managementContext.getCatalog();
                    for (CatalogItem item : catalog.getCatalogItems()) {
                        BrooklynClassLoadingContext catalogLoader = CatalogUtils.newClassLoadingContext(RebindIteration.this.managementContext, item);
                        Maybe catalogClass = catalogLoader.tryLoadClass(jType);
                        if (!catalogClass.isPresent()) continue;
                        return new LoadedClass((Class)catalogClass.get(), catalogItemId);
                    }
                    throw new IllegalStateException("No catalogItemId specified for " + contextSuchAsId + " and can't load class from either classpath or catalog items");
                }
                throw new IllegalStateException("No catalogItemId specified for " + contextSuchAsId + " and can't load class from classpath");
            }
        }

        protected Location newLocation(String locationId, String locationType) {
            Class locationClazz = this.reflections.loadClass(locationType, Location.class);
            if (InternalFactory.isNewStyle(locationClazz)) {
                InternalLocationFactory locationFactory = RebindIteration.this.managementContext.getLocationFactory();
                Object location = locationFactory.constructLocation(locationClazz);
                FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"id", (Object)locationId), location);
                RebindIteration.this.managementContext.prePreManage((Location)location);
                ((AbstractLocation)location).setManagementContext(RebindIteration.this.managementContext);
                return location;
            }
            LOG.warn("Deprecated rebind of location without no-arg constructor; this may not be supported in future versions: id=" + locationId + "; type=" + locationType);
            MutableMap flags = MutableMap.of((Object)"id", (Object)locationId, (Object)"deferConstructionChecks", (Object)true);
            return (Location)this.invokeConstructor(this.reflections, locationClazz, new Object[][]{{flags}});
        }

        protected Policy newPolicy(PolicyMemento memento) {
            Object policy;
            String id = memento.getId();
            LoadedClass<Policy> loaded = this.load(Policy.class, memento.getType(), memento.getCatalogItemId(), id);
            Class policyClazz = loaded.clazz;
            String transformedCatalogItemId = loaded.catalogItemId;
            if (InternalFactory.isNewStyle(policyClazz)) {
                InternalPolicyFactory policyFactory = RebindIteration.this.managementContext.getPolicyFactory();
                policy = policyFactory.constructPolicy(policyClazz);
                FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"id", (Object)id), policy);
                ((AbstractPolicy)policy).setManagementContext(RebindIteration.this.managementContext);
            } else {
                LOG.warn("Deprecated rebind of policy without no-arg constructor; this may not be supported in future versions: id=" + id + "; type=" + policyClazz);
                MutableMap flags = MutableMap.of((Object)"id", (Object)id, (Object)"deferConstructionChecks", (Object)true, (Object)"noConstructionInit", (Object)true);
                flags.putAll(memento.getConfig());
                policy = (Policy)this.invokeConstructor(null, policyClazz, new Object[][]{{flags}});
            }
            this.setCatalogItemId((BrooklynObject)policy, transformedCatalogItemId);
            return policy;
        }

        protected Enricher newEnricher(EnricherMemento memento) {
            Object enricher;
            String id = memento.getId();
            LoadedClass<Enricher> loaded = this.load(Enricher.class, (Memento)memento);
            Class enricherClazz = loaded.clazz;
            String transformedCatalogItemId = loaded.catalogItemId;
            if (InternalFactory.isNewStyle(enricherClazz)) {
                InternalPolicyFactory policyFactory = RebindIteration.this.managementContext.getPolicyFactory();
                enricher = policyFactory.constructEnricher(enricherClazz);
                FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"id", (Object)id), enricher);
                ((AbstractEnricher)enricher).setManagementContext(RebindIteration.this.managementContext);
            } else {
                LOG.warn("Deprecated rebind of enricher without no-arg constructor; this may not be supported in future versions: id=" + id + "; type=" + enricherClazz);
                MutableMap flags = MutableMap.of((Object)"id", (Object)id, (Object)"deferConstructionChecks", (Object)true, (Object)"noConstructionInit", (Object)true);
                flags.putAll(memento.getConfig());
                enricher = (Enricher)this.invokeConstructor(this.reflections, enricherClazz, new Object[][]{{flags}});
            }
            this.setCatalogItemId((BrooklynObject)enricher, transformedCatalogItemId);
            return enricher;
        }

        protected Feed newFeed(FeedMemento memento) {
            String id = memento.getId();
            LoadedClass<Feed> loaded = this.load(Feed.class, (Memento)memento);
            Class feedClazz = loaded.clazz;
            String transformedCatalogItemId = loaded.catalogItemId;
            if (!InternalFactory.isNewStyle(feedClazz)) {
                throw new IllegalStateException("rebind of feed without no-arg constructor unsupported: id=" + id + "; type=" + feedClazz);
            }
            InternalPolicyFactory policyFactory = RebindIteration.this.managementContext.getPolicyFactory();
            Object feed = policyFactory.constructFeed(feedClazz);
            FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"id", (Object)id), feed);
            ((AbstractFeed)feed).setManagementContext(RebindIteration.this.managementContext);
            this.setCatalogItemId((BrooklynObject)feed, transformedCatalogItemId);
            return feed;
        }

        protected CatalogItem<?, ?> newCatalogItem(CatalogItemMemento memento) {
            String id = memento.getId();
            String itemType = (String)Preconditions.checkNotNull((Object)memento.getType(), (String)"catalog item type of %s must not be null in memento", (Object[])new Object[]{id});
            Class clazz = this.reflections.loadClass(itemType, CatalogItem.class);
            return (CatalogItem)this.invokeConstructor(this.reflections, clazz, new Object[][]{new Object[0]});
        }

        protected <T> T invokeConstructor(Reflections reflections, Class<T> clazz, Object[] ... possibleArgs) {
            for (Object[] args : possibleArgs) {
                try {
                    Optional v = Reflections.invokeConstructorWithArgs(clazz, (Object[])args, (boolean)true);
                    if (!v.isPresent()) continue;
                    return (T)v.get();
                }
                catch (Exception e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            StringBuilder args = new StringBuilder();
            if (possibleArgs.length < 1) {
                args.append("no possible argument sets supplied; error");
            } else if (possibleArgs.length < 2) {
                args.append("args are " + Arrays.asList(possibleArgs[0]));
            } else {
                args.append("args are " + Arrays.asList(possibleArgs[0]));
                for (int i = 1; i < possibleArgs.length; ++i) {
                    args.append(" or ");
                    args.append(Arrays.asList(possibleArgs[i]));
                }
            }
            throw new IllegalStateException("Cannot instantiate instance of type " + clazz + "; expected constructor signature not found (" + args + ")");
        }
    }

    protected static class LoadedClass<T extends BrooklynObject> {
        protected final Class<? extends T> clazz;
        protected final String catalogItemId;

        protected LoadedClass(Class<? extends T> clazz, String catalogItemId) {
            this.clazz = clazz;
            this.catalogItemId = catalogItemId;
        }
    }
}

