/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind;

import brooklyn.basic.BrooklynObject;
import brooklyn.catalog.CatalogItem;
import brooklyn.entity.Entity;
import brooklyn.entity.Feed;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.rebind.BrooklynObjectType;
import brooklyn.entity.rebind.RebindContext;
import brooklyn.entity.rebind.RebindExceptionHandler;
import brooklyn.entity.rebind.RebindManager;
import brooklyn.entity.rebind.RebindManagerImpl;
import brooklyn.location.Location;
import brooklyn.policy.Enricher;
import brooklyn.policy.Policy;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.QuorumCheck;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.text.Strings;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebindExceptionHandlerImpl
implements RebindExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RebindExceptionHandlerImpl.class);
    protected final RebindManager.RebindFailureMode danglingRefFailureMode;
    protected final RebindManager.RebindFailureMode rebindFailureMode;
    protected final RebindManager.RebindFailureMode addPolicyFailureMode;
    protected final RebindManager.RebindFailureMode loadPolicyFailureMode;
    protected final QuorumCheck danglingRefsQuorumRequiredHealthy;
    protected final Set<String> missingEntities = Sets.newConcurrentHashSet();
    protected final Set<String> missingLocations = Sets.newConcurrentHashSet();
    protected final Set<String> missingPolicies = Sets.newConcurrentHashSet();
    protected final Set<String> missingEnrichers = Sets.newConcurrentHashSet();
    protected final Set<String> missingFeeds = Sets.newConcurrentHashSet();
    protected final Set<String> missingCatalogItems = Sets.newConcurrentHashSet();
    protected final Set<String> creationFailedIds = Sets.newConcurrentHashSet();
    protected final Set<Exception> addPolicyFailures = Sets.newConcurrentHashSet();
    protected final Set<Exception> loadPolicyFailures = Sets.newConcurrentHashSet();
    protected final Set<String> warnings = Collections.synchronizedSet(Sets.newLinkedHashSet());
    protected final Set<Exception> exceptions = Collections.synchronizedSet(Sets.newLinkedHashSet());
    protected RebindContext context;
    protected boolean started = false;
    protected boolean done = false;

    public static Builder builder() {
        return new Builder();
    }

    public RebindExceptionHandlerImpl(Builder builder) {
        this.danglingRefFailureMode = (RebindManager.RebindFailureMode)Preconditions.checkNotNull((Object)builder.danglingRefFailureMode, (Object)"danglingRefFailureMode");
        this.rebindFailureMode = (RebindManager.RebindFailureMode)Preconditions.checkNotNull((Object)builder.rebindFailureMode, (Object)"rebindFailureMode");
        this.addPolicyFailureMode = (RebindManager.RebindFailureMode)Preconditions.checkNotNull((Object)builder.addPolicyFailureMode, (Object)"addPolicyFailureMode");
        this.loadPolicyFailureMode = (RebindManager.RebindFailureMode)Preconditions.checkNotNull((Object)builder.deserializePolicyFailureMode, (Object)"deserializePolicyFailureMode");
        this.danglingRefsQuorumRequiredHealthy = (QuorumCheck)Preconditions.checkNotNull((Object)builder.danglingRefsQuorumRequiredHealthy, (Object)"danglingRefsQuorumRequiredHealthy");
    }

    protected void warn(String message) {
        this.warn(message, null);
    }

    protected void warn(String message, Throwable optionalError) {
        if (optionalError == null) {
            LOG.warn(message);
        } else {
            LOG.warn(message, optionalError);
        }
        this.warnings.add(message);
    }

    public void onStart(RebindContext context) {
        if (this.done) {
            throw new IllegalStateException(this + " has already been used on a finished run");
        }
        if (this.started) {
            throw new IllegalStateException(this + " has already been used on a started run");
        }
        this.context = context;
        this.started = true;
    }

    public void onLoadMementoFailed(BrooklynObjectType type, String msg, Exception e) {
        Exceptions.propagateIfFatal((Throwable)e);
        String errmsg = "problem loading memento: " + msg;
        block0 : switch (type) {
            case FEED: 
            case POLICY: 
            case ENRICHER: {
                switch (this.loadPolicyFailureMode) {
                    case FAIL_FAST: {
                        throw new IllegalStateException("Rebind: aborting due to " + errmsg, e);
                    }
                    case FAIL_AT_END: {
                        this.loadPolicyFailures.add(new IllegalStateException(errmsg, e));
                        break block0;
                    }
                    case CONTINUE: {
                        this.warn(errmsg + "; continuing: " + e, e);
                        break block0;
                    }
                }
                throw new IllegalStateException("Unexpected state '" + this.loadPolicyFailureMode + "' for loadPolicyFailureMode");
            }
            default: {
                this.exceptions.add(new IllegalStateException(errmsg, e));
                this.onErrorImpl(errmsg, e);
            }
        }
    }

    public Entity onDanglingEntityRef(String id) {
        this.missingEntities.add(id);
        if (this.danglingRefFailureMode == RebindManager.RebindFailureMode.FAIL_FAST) {
            throw new IllegalStateException("No entity found with id " + id);
        }
        this.warn("No entity found with id " + id + "; dangling reference on rebind");
        return null;
    }

    public Location onDanglingLocationRef(String id) {
        this.missingLocations.add(id);
        if (this.danglingRefFailureMode == RebindManager.RebindFailureMode.FAIL_FAST) {
            throw new IllegalStateException("No location found with id " + id);
        }
        this.warn("No location found with id " + id + "; dangling reference on rebind");
        return null;
    }

    public Policy onDanglingPolicyRef(String id) {
        this.missingPolicies.add(id);
        if (this.danglingRefFailureMode == RebindManager.RebindFailureMode.FAIL_FAST) {
            throw new IllegalStateException("No policy found with id " + id);
        }
        this.warn("No policy found with id " + id + "; dangling reference on rebind");
        return null;
    }

    public Enricher onDanglingEnricherRef(String id) {
        this.missingEnrichers.add(id);
        if (this.danglingRefFailureMode == RebindManager.RebindFailureMode.FAIL_FAST) {
            throw new IllegalStateException("No enricher found with id " + id);
        }
        this.warn("No enricher found with id " + id + "; dangling reference on rebind");
        return null;
    }

    public Feed onDanglingFeedRef(String id) {
        this.missingFeeds.add(id);
        if (this.danglingRefFailureMode == RebindManager.RebindFailureMode.FAIL_FAST) {
            throw new IllegalStateException("No feed found with id " + id);
        }
        this.warn("No feed found with id " + id + "; dangling reference on rebind");
        return null;
    }

    public CatalogItem<?, ?> onDanglingCatalogItemRef(String id) {
        this.missingCatalogItems.add(id);
        if (this.danglingRefFailureMode == RebindManager.RebindFailureMode.FAIL_FAST) {
            throw new IllegalStateException("No catalog item found with id " + id);
        }
        this.warn("No catalog item found with id " + id + "; dangling reference on rebind");
        return null;
    }

    public void onCreateFailed(BrooklynObjectType type, String id, String instanceType, Exception e) {
        Exceptions.propagateIfFatal((Throwable)e);
        String errmsg = "problem creating " + type + " " + id + " of type " + instanceType;
        this.creationFailedIds.add(id);
        this.exceptions.add(new IllegalStateException(errmsg, e));
        this.onErrorImpl(errmsg, e);
    }

    public void onNotFound(BrooklynObjectType type, String id) {
        if (!this.creationFailedIds.contains(id)) {
            String errmsg = type.toCamelCase() + " '" + id + "' not found";
            this.exceptions.add(new IllegalStateException(errmsg));
            this.onErrorImpl(errmsg);
        }
    }

    public void onRebindFailed(BrooklynObjectType type, BrooklynObject instance, Exception e) {
        Exceptions.propagateIfFatal((Throwable)e);
        String errmsg = "problem rebinding " + type.toCamelCase() + " " + instance.getId() + " (" + instance + ")";
        block0 : switch (type) {
            case FEED: 
            case POLICY: 
            case ENRICHER: {
                switch (this.addPolicyFailureMode) {
                    case FAIL_FAST: {
                        throw new IllegalStateException("Rebind: aborting due to " + errmsg, e);
                    }
                    case FAIL_AT_END: {
                        this.addPolicyFailures.add(new IllegalStateException(errmsg, e));
                        break block0;
                    }
                    case CONTINUE: {
                        this.warn(errmsg + "; continuing", e);
                        this.creationFailedIds.add(instance.getId());
                        break block0;
                    }
                }
                throw new IllegalStateException("Unexpected state '" + this.addPolicyFailureMode + "' for addPolicyFailureMode");
            }
            default: {
                this.exceptions.add(new IllegalStateException(errmsg, e));
                this.onErrorImpl(errmsg, e);
            }
        }
    }

    public void onAddPolicyFailed(EntityLocal entity, Policy policy, Exception e) {
        Exceptions.propagateIfFatal((Throwable)e);
        String errmsg = "problem adding policy " + policy.getId() + " (" + policy + ") to entity " + entity.getId() + " (" + entity + ")";
        switch (this.addPolicyFailureMode) {
            case FAIL_FAST: {
                throw new IllegalStateException("Rebind: aborting due to " + errmsg, e);
            }
            case FAIL_AT_END: {
                this.addPolicyFailures.add(new IllegalStateException(errmsg, e));
                break;
            }
            case CONTINUE: {
                this.warn(errmsg + "; continuing", e);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state '" + this.addPolicyFailureMode + "' for addPolicyFailureMode");
            }
        }
    }

    public void onAddEnricherFailed(EntityLocal entity, Enricher enricher, Exception e) {
        Exceptions.propagateIfFatal((Throwable)e);
        String errmsg = "problem adding enricher " + enricher.getId() + " (" + enricher + ") to entity " + entity.getId() + " (" + entity + ")";
        switch (this.addPolicyFailureMode) {
            case FAIL_FAST: {
                throw new IllegalStateException("Rebind: aborting due to " + errmsg, e);
            }
            case FAIL_AT_END: {
                this.addPolicyFailures.add(new IllegalStateException(errmsg, e));
                break;
            }
            case CONTINUE: {
                this.warn(errmsg + "; continuing", e);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state '" + this.addPolicyFailureMode + "' for addPolicyFailureMode");
            }
        }
    }

    public void onAddFeedFailed(EntityLocal entity, Feed feed, Exception e) {
        Exceptions.propagateIfFatal((Throwable)e);
        String errmsg = "problem adding feed " + feed.getId() + " (" + feed + ") to entity " + entity.getId() + " (" + entity + ")";
        switch (this.addPolicyFailureMode) {
            case FAIL_FAST: {
                throw new IllegalStateException("Rebind: aborting due to " + errmsg, e);
            }
            case FAIL_AT_END: {
                this.addPolicyFailures.add(new IllegalStateException(errmsg, e));
                break;
            }
            case CONTINUE: {
                this.warn(errmsg + "; continuing", e);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state '" + this.addPolicyFailureMode + "' for addPolicyFailureMode");
            }
        }
    }

    public void onManageFailed(BrooklynObjectType type, BrooklynObject instance, Exception e) {
        Exceptions.propagateIfFatal((Throwable)e);
        String errmsg = "problem managing " + type.toCamelCase() + " " + instance.getId() + " (" + instance + ")";
        this.exceptions.add(new IllegalStateException(errmsg, e));
        this.onErrorImpl(errmsg, e);
    }

    protected void onErrorImpl(String errmsg) {
        this.onErrorImpl(errmsg, null);
    }

    protected void onErrorImpl(String errmsg, Exception e) {
        if (this.rebindFailureMode == RebindManager.RebindFailureMode.FAIL_FAST) {
            throw new IllegalStateException("Rebind: aborting due to " + errmsg, e);
        }
        if (Thread.currentThread().isInterrupted()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Rebind: while interrupted, received " + errmsg + "/" + e + "; throwing interruption", (Throwable)e);
            }
            throw Exceptions.propagate((Throwable)new InterruptedException("Detected interruption while not sleeping, due to secondary error rebinding: " + errmsg + "/" + e));
        }
        this.warn("Rebind: continuing after " + errmsg, e);
    }

    public void onDone() {
        this.onDoneImpl(null);
    }

    public RuntimeException onFailed(Exception e) {
        if (this.done) {
            throw Exceptions.propagate((Throwable)e);
        }
        this.onDoneImpl(e);
        this.exceptions.add(e);
        throw new IllegalStateException("Rebind failed", e);
    }

    protected void onDoneImpl(Exception e) {
        Exceptions.propagateIfFatal((Throwable)e);
        ArrayList allExceptions = Lists.newArrayList();
        if (this.done) {
            allExceptions.add(new IllegalStateException(this + " has already been informed of rebind done"));
        }
        this.done = true;
        MutableList danglingIds = MutableList.copyOf(this.missingEntities).appendAll(this.missingLocations).appendAll(this.missingPolicies).appendAll(this.missingEnrichers).appendAll(this.missingFeeds).appendAll(this.missingCatalogItems);
        int totalDangling = danglingIds.size();
        if (totalDangling > 0) {
            int totalFound = this.context.getAllBrooklynObjects().size();
            int totalItems = totalFound + totalDangling;
            if (this.context == null) {
                allExceptions.add(new IllegalStateException("Dangling references (" + totalDangling + " of " + totalItems + ") present without rebind context"));
            } else if (!this.danglingRefsQuorumRequiredHealthy.isQuorate(totalFound, totalItems)) {
                this.warn("Dangling item" + Strings.s((int)totalDangling) + " (" + totalDangling + " of " + totalItems + ") found on rebind exceeds quorum, assuming failed: " + danglingIds);
                allExceptions.add(new IllegalStateException("Too many dangling references: " + totalDangling + " of " + totalItems));
            } else {
                LOG.info("Dangling item" + Strings.s((int)totalDangling) + " (" + totalDangling + " of " + totalItems + ") found on rebind, assuming deleted: " + danglingIds);
            }
        }
        if (e != null) {
            allExceptions.add(e);
        }
        if (this.addPolicyFailureMode != RebindManager.RebindFailureMode.CONTINUE) {
            allExceptions.addAll(this.addPolicyFailures);
        }
        if (this.loadPolicyFailureMode != RebindManager.RebindFailureMode.CONTINUE) {
            allExceptions.addAll(this.loadPolicyFailures);
        }
        if (this.danglingRefFailureMode != RebindManager.RebindFailureMode.CONTINUE) {
            if (!this.missingEntities.isEmpty()) {
                allExceptions.add(new IllegalStateException("Missing referenced entit" + Strings.ies(this.missingEntities) + ": " + this.missingEntities));
            }
            if (!this.missingLocations.isEmpty()) {
                allExceptions.add(new IllegalStateException("Missing referenced location" + Strings.s(this.missingLocations) + ": " + this.missingLocations));
            }
            if (!this.missingPolicies.isEmpty()) {
                allExceptions.add(new IllegalStateException("Missing referenced polic" + Strings.ies(this.missingPolicies) + ": " + ": " + this.missingPolicies));
            }
            if (!this.missingEnrichers.isEmpty()) {
                allExceptions.add(new IllegalStateException("Missing referenced enricher" + Strings.s(this.missingEnrichers) + ": " + this.missingEnrichers));
            }
            if (!this.missingFeeds.isEmpty()) {
                allExceptions.add(new IllegalStateException("Missing referenced feed" + Strings.s(this.missingFeeds) + ": " + this.missingFeeds));
            }
            if (!this.missingCatalogItems.isEmpty()) {
                allExceptions.add(new IllegalStateException("Missing referenced catalog item" + Strings.s(this.missingCatalogItems) + ": " + this.missingCatalogItems));
            }
        }
        if (this.rebindFailureMode != RebindManager.RebindFailureMode.CONTINUE) {
            allExceptions.addAll(this.exceptions);
        }
        if (!this.started) {
            allExceptions.add(new IllegalStateException(this + " was not informed of start of rebind run"));
        }
        if (allExceptions.isEmpty()) {
            return;
        }
        RuntimeException compoundException = Exceptions.create((String)"Failure rebinding", (Collection)allExceptions);
        LOG.debug(compoundException.getMessage() + " (rethrowing)");
        throw compoundException;
    }

    public List<Exception> getExceptions() {
        return ImmutableList.copyOf(this.exceptions);
    }

    public List<String> getWarnings() {
        return ImmutableList.copyOf(this.warnings);
    }

    public static class Builder {
        private RebindManager.RebindFailureMode danglingRefFailureMode = RebindManager.RebindFailureMode.CONTINUE;
        private RebindManager.RebindFailureMode rebindFailureMode = RebindManager.RebindFailureMode.FAIL_AT_END;
        private RebindManager.RebindFailureMode addPolicyFailureMode = RebindManager.RebindFailureMode.CONTINUE;
        private RebindManager.RebindFailureMode deserializePolicyFailureMode = RebindManager.RebindFailureMode.CONTINUE;
        private QuorumCheck danglingRefsQuorumRequiredHealthy = (QuorumCheck)RebindManagerImpl.DANGLING_REFERENCES_MIN_REQUIRED_HEALTHY.getDefaultValue();

        public Builder danglingRefFailureMode(RebindManager.RebindFailureMode val) {
            this.danglingRefFailureMode = val;
            return this;
        }

        public Builder rebindFailureMode(RebindManager.RebindFailureMode val) {
            this.rebindFailureMode = val;
            return this;
        }

        public Builder addPolicyFailureMode(RebindManager.RebindFailureMode val) {
            this.addPolicyFailureMode = val;
            return this;
        }

        public Builder loadPolicyFailureMode(RebindManager.RebindFailureMode val) {
            this.deserializePolicyFailureMode = val;
            return this;
        }

        public Builder danglingRefQuorumRequiredHealthy(QuorumCheck val) {
            this.danglingRefsQuorumRequiredHealthy = val;
            return this;
        }

        public RebindExceptionHandler build() {
            return new RebindExceptionHandlerImpl(this);
        }
    }
}

