/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind;

import brooklyn.basic.BrooklynObject;
import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.entity.Entity;
import brooklyn.entity.Feed;
import brooklyn.entity.rebind.BrooklynObjectType;
import brooklyn.entity.rebind.RebindContextImpl;
import brooklyn.entity.rebind.RebindExceptionHandler;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import brooklyn.mementos.BrooklynMementoPersister;
import brooklyn.policy.Enricher;
import brooklyn.policy.Policy;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebindContextLookupContext
implements BrooklynMementoPersister.LookupContext {
    private static final Logger LOG = LoggerFactory.getLogger(RebindContextLookupContext.class);
    @Nullable
    protected final ManagementContext managementContext;
    protected final RebindContextImpl rebindContext;
    protected final RebindExceptionHandler exceptionHandler;

    public RebindContextLookupContext(ManagementContext managementContext, RebindContextImpl rebindContext, RebindExceptionHandler exceptionHandler) {
        this.managementContext = managementContext;
        this.rebindContext = rebindContext;
        this.exceptionHandler = exceptionHandler;
    }

    public ManagementContext lookupManagementContext() {
        return this.managementContext;
    }

    public Entity lookupEntity(String id) {
        Entity result = this.rebindContext.getEntity(id);
        if (result == null) {
            result = (Entity)this.managementContext.lookup(id, Entity.class);
        }
        if (result == null) {
            result = this.exceptionHandler.onDanglingEntityRef(id);
        }
        return result;
    }

    public Location lookupLocation(String id) {
        Location result = this.rebindContext.getLocation(id);
        if (result == null) {
            result = (Location)this.managementContext.lookup(id, Location.class);
        }
        if (result == null) {
            result = this.exceptionHandler.onDanglingLocationRef(id);
        }
        return result;
    }

    public Policy lookupPolicy(String id) {
        Policy result = this.rebindContext.getPolicy(id);
        if (result == null) {
            result = (Policy)this.managementContext.lookup(id, Policy.class);
        }
        if (result == null) {
            result = this.exceptionHandler.onDanglingPolicyRef(id);
        }
        return result;
    }

    public Enricher lookupEnricher(String id) {
        Enricher result = this.rebindContext.getEnricher(id);
        if (result == null) {
            result = (Enricher)this.managementContext.lookup(id, Enricher.class);
        }
        if (result == null) {
            result = this.exceptionHandler.onDanglingEnricherRef(id);
        }
        return result;
    }

    public Feed lookupFeed(String id) {
        Feed result = this.rebindContext.getFeed(id);
        if (result == null) {
            result = (Feed)this.managementContext.lookup(id, Feed.class);
        }
        if (result == null) {
            result = this.exceptionHandler.onDanglingFeedRef(id);
        }
        return result;
    }

    public CatalogItem<?, ?> lookupCatalogItem(String id) {
        CatalogItem result = this.rebindContext.getCatalogItem(id);
        if (result == null) {
            result = CatalogUtils.getCatalogItemOptionalVersion(this.managementContext, id);
        }
        if (result == null) {
            result = this.exceptionHandler.onDanglingCatalogItemRef(id);
        }
        return result;
    }

    public BrooklynObject lookup(BrooklynObjectType type, String id) {
        switch (type) {
            case CATALOG_ITEM: {
                return this.lookupCatalogItem(id);
            }
            case ENRICHER: {
                return this.lookupEnricher(id);
            }
            case ENTITY: {
                return this.lookupEntity(id);
            }
            case FEED: {
                return this.lookupFeed(id);
            }
            case LOCATION: {
                return this.lookupLocation(id);
            }
            case POLICY: {
                return this.lookupPolicy(id);
            }
            case UNKNOWN: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected type " + type + " / id " + id);
    }

    public BrooklynObject peek(BrooklynObjectType type, String id) {
        switch (type) {
            case CATALOG_ITEM: {
                return this.rebindContext.getCatalogItem(id);
            }
            case ENRICHER: {
                return this.rebindContext.getEnricher(id);
            }
            case ENTITY: {
                return this.rebindContext.getEntity(id);
            }
            case FEED: {
                return this.rebindContext.getFeed(id);
            }
            case LOCATION: {
                return this.rebindContext.getLocation(id);
            }
            case POLICY: {
                return this.rebindContext.getPolicy(id);
            }
            case UNKNOWN: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected type " + type + " / id " + id);
    }
}

