/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind;

import brooklyn.basic.BrooklynObject;
import brooklyn.catalog.CatalogItem;
import brooklyn.entity.Entity;
import brooklyn.entity.Feed;
import brooklyn.entity.rebind.RebindContext;
import brooklyn.entity.rebind.RebindContextLookupContext;
import brooklyn.entity.rebind.RebindExceptionHandler;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import brooklyn.mementos.BrooklynMementoPersister;
import brooklyn.policy.Enricher;
import brooklyn.policy.Policy;
import brooklyn.util.collections.MutableMap;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;

public class RebindContextImpl
implements RebindContext {
    private final Map<String, Entity> entities = Maps.newLinkedHashMap();
    private final Map<String, Location> locations = Maps.newLinkedHashMap();
    private final Map<String, Policy> policies = Maps.newLinkedHashMap();
    private final Map<String, Enricher> enrichers = Maps.newLinkedHashMap();
    private final Map<String, Feed> feeds = Maps.newLinkedHashMap();
    private final Map<String, CatalogItem<?, ?>> catalogItems = Maps.newLinkedHashMap();
    private final ClassLoader classLoader;
    private final ManagementContext mgmt;
    private final RebindExceptionHandler exceptionHandler;
    private final BrooklynMementoPersister.LookupContext lookupContext;
    private boolean allAreReadOnly = false;

    public RebindContextImpl(ManagementContext mgmt, RebindExceptionHandler exceptionHandler, ClassLoader classLoader) {
        this.mgmt = (ManagementContext)Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt");
        this.exceptionHandler = (RebindExceptionHandler)Preconditions.checkNotNull((Object)exceptionHandler, (Object)"exceptionHandler");
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader");
        this.lookupContext = new RebindContextLookupContext(mgmt, this, exceptionHandler);
    }

    public void registerEntity(String id, Entity entity) {
        this.entities.put(id, entity);
    }

    public void registerLocation(String id, Location location) {
        this.locations.put(id, location);
    }

    public void registerPolicy(String id, Policy policy) {
        this.policies.put(id, policy);
    }

    public void registerEnricher(String id, Enricher enricher) {
        this.enrichers.put(id, enricher);
    }

    public void registerFeed(String id, Feed feed) {
        this.feeds.put(id, feed);
    }

    public void registerCatalogItem(String id, CatalogItem<?, ?> catalogItem) {
        this.catalogItems.put(id, catalogItem);
    }

    public void unregisterPolicy(Policy policy) {
        this.policies.remove(policy.getId());
    }

    public void unregisterEnricher(Enricher enricher) {
        this.enrichers.remove(enricher.getId());
    }

    public void unregisterFeed(Feed feed) {
        this.feeds.remove(feed.getId());
    }

    public void unregisterCatalogItem(CatalogItem<?, ?> item) {
        this.catalogItems.remove(item.getId());
    }

    public void clearCatalogItems() {
        this.catalogItems.clear();
    }

    public Entity getEntity(String id) {
        return this.entities.get(id);
    }

    public Location getLocation(String id) {
        return this.locations.get(id);
    }

    public Policy getPolicy(String id) {
        return this.policies.get(id);
    }

    public Enricher getEnricher(String id) {
        return this.enrichers.get(id);
    }

    public CatalogItem<?, ?> getCatalogItem(String id) {
        return this.catalogItems.get(id);
    }

    public Feed getFeed(String id) {
        return this.feeds.get(id);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.classLoader.loadClass(className);
    }

    public RebindExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public Collection<Location> getLocations() {
        return this.locations.values();
    }

    public Collection<Entity> getEntities() {
        return this.entities.values();
    }

    public Collection<Policy> getPolicies() {
        return this.policies.values();
    }

    public Collection<Enricher> getEnrichers() {
        return this.enrichers.values();
    }

    public Collection<Feed> getFeeds() {
        return this.feeds.values();
    }

    public Collection<CatalogItem<?, ?>> getCatalogItems() {
        return this.catalogItems.values();
    }

    public Map<String, BrooklynObject> getAllBrooklynObjects() {
        MutableMap result = MutableMap.of();
        result.putAll(this.locations);
        result.putAll(this.entities);
        result.putAll(this.policies);
        result.putAll(this.enrichers);
        result.putAll(this.feeds);
        result.putAll(this.catalogItems);
        return result.asUnmodifiable();
    }

    public void setAllReadOnly() {
        this.allAreReadOnly = true;
    }

    public boolean isReadOnly(BrooklynObject item) {
        return this.allAreReadOnly;
    }

    public BrooklynMementoPersister.LookupContext lookup() {
        return this.lookupContext;
    }
}

