/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind;

import brooklyn.basic.BrooklynObject;
import brooklyn.basic.BrooklynObjectInternal;
import brooklyn.catalog.CatalogItem;
import brooklyn.entity.Entity;
import brooklyn.entity.Feed;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.rebind.BrooklynObjectType;
import brooklyn.entity.rebind.ChangeListener;
import brooklyn.entity.rebind.PersistenceExceptionHandler;
import brooklyn.entity.rebind.PersisterDeltaImpl;
import brooklyn.entity.rebind.TreeUtils;
import brooklyn.entity.rebind.persister.BrooklynPersistenceUtils;
import brooklyn.entity.rebind.persister.PersistenceActivityMetrics;
import brooklyn.internal.BrooklynFeatureEnablement;
import brooklyn.location.Location;
import brooklyn.management.ExecutionContext;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.mementos.BrooklynMementoPersister;
import brooklyn.policy.Enricher;
import brooklyn.policy.Policy;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.exceptions.RuntimeInterruptedException;
import brooklyn.util.task.ScheduledTask;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.CountdownTimer;
import brooklyn.util.time.Duration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicDeltaChangeListener
implements ChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicDeltaChangeListener.class);
    private final ExecutionContext executionContext;
    private final BrooklynMementoPersister persister;
    private final PersistenceExceptionHandler exceptionHandler;
    private final Duration period;
    private DeltaCollector deltaCollector = new DeltaCollector();
    private volatile ListenerState state = ListenerState.INIT;
    private volatile ScheduledTask scheduledTask;
    private final boolean persistPoliciesEnabled;
    private final boolean persistEnrichersEnabled;
    private final boolean persistFeedsEnabled;
    private final Semaphore persistingMutex = new Semaphore(1);
    private final Object startStopMutex = new Object();
    private final AtomicInteger writeCount = new AtomicInteger(0);
    private PersistenceActivityMetrics metrics;

    public PeriodicDeltaChangeListener(ExecutionContext executionContext, BrooklynMementoPersister persister, PersistenceExceptionHandler exceptionHandler, PersistenceActivityMetrics metrics, Duration period) {
        this.executionContext = executionContext;
        this.persister = persister;
        this.exceptionHandler = exceptionHandler;
        this.metrics = metrics;
        this.period = period;
        this.persistPoliciesEnabled = BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.policyPersistence");
        this.persistEnrichersEnabled = BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.enricherPersistence");
        this.persistFeedsEnabled = BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.feedPersistence");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.startStopMutex;
        synchronized (object) {
            if (this.state == ListenerState.RUNNING || this.scheduledTask != null && !this.scheduledTask.isDone()) {
                LOG.warn("Request to start " + this + " when already running - " + this.scheduledTask + "; ignoring");
                return;
            }
            this.state = ListenerState.RUNNING;
            Callable taskFactory = new Callable<Task<?>>(){

                @Override
                public Task<Void> call() {
                    return Tasks.builder().dynamic(false).name("periodic-persister").body(new Callable<Void>(){

                        @Override
                        public Void call() {
                            PeriodicDeltaChangeListener.this.persistNowSafely();
                            return null;
                        }
                    }).build();
                }
            };
            this.scheduledTask = (ScheduledTask)this.executionContext.submit((TaskAdaptable)new ScheduledTask((Map)MutableMap.of((Object)"displayName", (Object)"scheduled[periodic-persister]", (Object)"tags", (Object)MutableSet.of((Object)"TRANSIENT")), taskFactory).period(this.period));
        }
    }

    void stop() {
        this.stop(Duration.TEN_SECONDS, Duration.ONE_SECOND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(Duration timeout, Duration graceTimeoutForSubsequentOperations) {
        Object object = this.startStopMutex;
        synchronized (object) {
            this.state = ListenerState.STOPPING;
            try {
                if (this.scheduledTask != null) {
                    CountdownTimer expiry = timeout.countdownTimer();
                    try {
                        this.scheduledTask.cancel(false);
                        this.waitForPendingComplete(expiry.getDurationRemaining().lowerBound(Duration.ZERO).add(graceTimeoutForSubsequentOperations), true);
                    }
                    catch (Exception e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                    this.scheduledTask.blockUntilEnded(expiry.getDurationRemaining().lowerBound(Duration.ZERO).add(graceTimeoutForSubsequentOperations));
                    this.scheduledTask.cancel(true);
                    boolean reallyEnded = Tasks.blockUntilInternalTasksEnded(this.scheduledTask, expiry.getDurationRemaining().lowerBound(Duration.ZERO).add(graceTimeoutForSubsequentOperations));
                    if (!reallyEnded) {
                        LOG.warn("Persistence tasks took too long to terminate, when stopping persistence, although pending changes were persisted (ignoring): " + this.scheduledTask);
                    }
                    this.scheduledTask = null;
                }
                PeriodicDeltaChangeListener periodicDeltaChangeListener = this;
                synchronized (periodicDeltaChangeListener) {
                    this.deltaCollector = new DeltaCollector();
                }
            }
            finally {
                this.state = ListenerState.STOPPED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void waitForPendingComplete(Duration timeout, boolean canTrigger) throws InterruptedException, TimeoutException {
        if (!this.isActive() && this.state != ListenerState.STOPPING) {
            return;
        }
        CountdownTimer timer = timeout.isPositive() ? CountdownTimer.newInstanceStarted((Duration)timeout) : CountdownTimer.newInstancePaused((Duration)Duration.PRACTICALLY_FOREVER);
        Integer targetWriteCount = null;
        if (this.persistingMutex.tryAcquire(timer.getDurationRemaining().toMilliseconds(), TimeUnit.MILLISECONDS)) {
            try {
                if (!this.deltaCollector.isEmpty()) {
                    if (canTrigger) {
                        this.persistNowSafely(true);
                    } else {
                        targetWriteCount = this.writeCount.get() + 1;
                    }
                }
            }
            finally {
                this.persistingMutex.release();
            }
            if (targetWriteCount != null) {
                while (this.writeCount.get() <= targetWriteCount) {
                    Duration left = timer.getDurationRemaining();
                    if (left.isPositive()) {
                        AtomicInteger atomicInteger = this.writeCount;
                        synchronized (atomicInteger) {
                            this.writeCount.wait(left.lowerBound(Duration.millis((Number)10)).toMilliseconds());
                            continue;
                        }
                    }
                    throw new TimeoutException("Timeout waiting for independent write of rebind-periodic-delta, after " + timer.getDurationElapsed());
                }
            }
        } else {
            throw new TimeoutException("Timeout waiting for completion of in-progress write of rebind-periodic-delta, after " + timer.getDurationElapsed());
        }
    }

    private boolean isActive() {
        return this.state == ListenerState.RUNNING && this.persister != null && !this.isStopped();
    }

    private boolean isStopped() {
        return this.state == ListenerState.STOPPING || this.state == ListenerState.STOPPED || this.executionContext.isShutdown();
    }

    private void addReferencedObjects(DeltaCollector deltaCollector) {
        LinkedHashSet referencedObjects = Sets.newLinkedHashSet();
        for (Entity entity : deltaCollector.entities) {
            for (Location location : entity.getLocations()) {
                Collection<Location> findLocationsInHierarchy = TreeUtils.findLocationsInHierarchy(location);
                referencedObjects.addAll(findLocationsInHierarchy);
            }
            if (this.persistPoliciesEnabled) {
                referencedObjects.addAll(entity.getPolicies());
            }
            if (this.persistEnrichersEnabled) {
                referencedObjects.addAll(entity.getEnrichers());
            }
            if (!this.persistFeedsEnabled) continue;
            referencedObjects.addAll(((EntityInternal)entity).feeds().getFeeds());
        }
        for (BrooklynObject instance : referencedObjects) {
            deltaCollector.addIfNotRemoved(instance);
        }
    }

    @VisibleForTesting
    public boolean persistNowSafely() {
        return this.persistNowSafely(false);
    }

    private boolean persistNowSafely(boolean alreadyHasMutex) {
        Stopwatch timer = Stopwatch.createStarted();
        try {
            this.persistNowInternal(alreadyHasMutex);
            this.metrics.noteSuccess(Duration.of((Object)timer));
            return true;
        }
        catch (RuntimeInterruptedException e) {
            LOG.debug("Interrupted persisting change-delta (rethrowing)", (Throwable)e);
            this.metrics.noteFailure(Duration.of((Object)timer));
            this.metrics.noteError(e.toString());
            Thread.currentThread().interrupt();
            return false;
        }
        catch (Exception e) {
            LOG.error("Problem persisting change-delta", (Throwable)e);
            this.metrics.noteFailure(Duration.of((Object)timer));
            this.metrics.noteError(e.toString());
            return false;
        }
        catch (Throwable t) {
            LOG.warn("Problem persisting change-delta (rethrowing)", t);
            this.metrics.noteFailure(Duration.of((Object)timer));
            this.metrics.noteError(t.toString());
            throw Exceptions.propagate((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistNowInternal(boolean alreadyHasMutex) {
        block38: {
            if (!this.isActive() && this.state != ListenerState.STOPPING) {
                return;
            }
            try {
                DeltaCollector prevDeltaCollector;
                if (!alreadyHasMutex) {
                    this.persistingMutex.acquire();
                }
                if (!this.isActive() && this.state != ListenerState.STOPPING) {
                    return;
                }
                PeriodicDeltaChangeListener periodicDeltaChangeListener = this;
                synchronized (periodicDeltaChangeListener) {
                    prevDeltaCollector = this.deltaCollector;
                    this.deltaCollector = new DeltaCollector();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Checkpointing delta of memento: updating entities={}, locations={}, policies={}, enrichers={}, catalog items={}; removing entities={}, locations={}, policies={}, enrichers={}, catalog items={}", new Object[]{PeriodicDeltaChangeListener.limitedCountString(prevDeltaCollector.entities), PeriodicDeltaChangeListener.limitedCountString(prevDeltaCollector.locations), PeriodicDeltaChangeListener.limitedCountString(prevDeltaCollector.policies), PeriodicDeltaChangeListener.limitedCountString(prevDeltaCollector.enrichers), PeriodicDeltaChangeListener.limitedCountString(prevDeltaCollector.catalogItems), PeriodicDeltaChangeListener.limitedCountString(prevDeltaCollector.removedEntityIds), PeriodicDeltaChangeListener.limitedCountString(prevDeltaCollector.removedLocationIds), PeriodicDeltaChangeListener.limitedCountString(prevDeltaCollector.removedPolicyIds), PeriodicDeltaChangeListener.limitedCountString(prevDeltaCollector.removedEnricherIds), PeriodicDeltaChangeListener.limitedCountString(prevDeltaCollector.removedCatalogItemIds)});
                }
                this.addReferencedObjects(prevDeltaCollector);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Checkpointing delta of memento with references: updating {} entities, {} locations, {} policies, {} enrichers, {} catalog items; removing {} entities, {} locations, {} policies, {} enrichers, {} catalog items", new Object[]{prevDeltaCollector.entities.size(), prevDeltaCollector.locations.size(), prevDeltaCollector.policies.size(), prevDeltaCollector.enrichers.size(), prevDeltaCollector.catalogItems.size(), prevDeltaCollector.removedEntityIds.size(), prevDeltaCollector.removedLocationIds.size(), prevDeltaCollector.removedPolicyIds.size(), prevDeltaCollector.removedEnricherIds.size(), prevDeltaCollector.removedCatalogItemIds.size()});
                }
                if (prevDeltaCollector.isEmpty()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("No changes to persist since last delta");
                    }
                    break block38;
                }
                PersisterDeltaImpl persisterDelta = new PersisterDeltaImpl();
                for (BrooklynObjectType type : BrooklynPersistenceUtils.STANDARD_BROOKLYN_OBJECT_TYPE_PERSISTENCE_ORDER) {
                    for (BrooklynObject instance : prevDeltaCollector.getCollectionOfType(type)) {
                        try {
                            persisterDelta.add(type, ((BrooklynObjectInternal)instance).getRebindSupport().getMemento());
                        }
                        catch (Exception e) {
                            this.exceptionHandler.onGenerateMementoFailed(type, instance, e);
                        }
                    }
                }
                for (BrooklynObjectType type : BrooklynPersistenceUtils.STANDARD_BROOKLYN_OBJECT_TYPE_PERSISTENCE_ORDER) {
                    persisterDelta.removed(type, prevDeltaCollector.getRemovedIdsOfType(type));
                }
                Object object = new Object();
                synchronized (object) {
                }
                this.persister.delta((BrooklynMementoPersister.Delta)persisterDelta, this.exceptionHandler);
            }
            catch (Exception e) {
                if (this.isActive()) {
                    throw Exceptions.propagate((Throwable)e);
                }
                Exceptions.propagateIfFatal((Throwable)e);
                LOG.debug("Problem persisting, but no longer active (ignoring)", (Throwable)e);
            }
            finally {
                AtomicInteger atomicInteger = this.writeCount;
                synchronized (atomicInteger) {
                    this.writeCount.incrementAndGet();
                    this.writeCount.notifyAll();
                }
                if (!alreadyHasMutex) {
                    this.persistingMutex.release();
                }
            }
        }
    }

    private static String limitedCountString(Collection<?> items) {
        if (items == null) {
            return null;
        }
        int size = items.size();
        if (size == 0) {
            return "[]";
        }
        int MAX = 12;
        if (size <= MAX) {
            return items.toString();
        }
        ArrayList itemsTruncated = Lists.newArrayList((Iterable)Iterables.limit(items, (int)MAX));
        if (items.size() > itemsTruncated.size()) {
            itemsTruncated.add("... (" + (size - MAX) + " more)");
        }
        return ((Object)itemsTruncated).toString();
    }

    public synchronized void onManaged(BrooklynObject instance) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("onManaged: {}", (Object)instance);
        }
        this.onChanged(instance);
    }

    public synchronized void onUnmanaged(BrooklynObject instance) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("onUnmanaged: {}", (Object)instance);
        }
        if (!this.isStopped()) {
            this.removeFromCollector(instance);
            if (instance instanceof Entity) {
                Entity entity = (Entity)instance;
                for (BrooklynObject brooklynObject : entity.getPolicies()) {
                    this.removeFromCollector(brooklynObject);
                }
                for (BrooklynObject brooklynObject : entity.getEnrichers()) {
                    this.removeFromCollector(brooklynObject);
                }
                for (BrooklynObject brooklynObject : ((EntityInternal)entity).feeds().getFeeds()) {
                    this.removeFromCollector(brooklynObject);
                }
            }
        }
    }

    private void removeFromCollector(BrooklynObject instance) {
        this.deltaCollector.remove(instance);
    }

    public synchronized void onChanged(BrooklynObject instance) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("onChanged: {}", (Object)instance);
        }
        if (!this.isStopped()) {
            this.deltaCollector.add(instance);
        }
    }

    public PersistenceExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    private static enum ListenerState {
        INIT,
        RUNNING,
        STOPPING,
        STOPPED;

    }

    private static class DeltaCollector {
        private Set<Location> locations = Sets.newLinkedHashSet();
        private Set<Entity> entities = Sets.newLinkedHashSet();
        private Set<Policy> policies = Sets.newLinkedHashSet();
        private Set<Enricher> enrichers = Sets.newLinkedHashSet();
        private Set<Feed> feeds = Sets.newLinkedHashSet();
        private Set<CatalogItem<?, ?>> catalogItems = Sets.newLinkedHashSet();
        private Set<String> removedLocationIds = Sets.newLinkedHashSet();
        private Set<String> removedEntityIds = Sets.newLinkedHashSet();
        private Set<String> removedPolicyIds = Sets.newLinkedHashSet();
        private Set<String> removedEnricherIds = Sets.newLinkedHashSet();
        private Set<String> removedFeedIds = Sets.newLinkedHashSet();
        private Set<String> removedCatalogItemIds = Sets.newLinkedHashSet();

        private DeltaCollector() {
        }

        public boolean isEmpty() {
            return this.locations.isEmpty() && this.entities.isEmpty() && this.policies.isEmpty() && this.enrichers.isEmpty() && this.feeds.isEmpty() && this.catalogItems.isEmpty() && this.removedEntityIds.isEmpty() && this.removedLocationIds.isEmpty() && this.removedPolicyIds.isEmpty() && this.removedEnricherIds.isEmpty() && this.removedFeedIds.isEmpty() && this.removedCatalogItemIds.isEmpty();
        }

        public void add(BrooklynObject instance) {
            BrooklynObjectType type = BrooklynObjectType.of((BrooklynObject)instance);
            this.getUnsafeCollectionOfType(type).add(instance);
            if (type == BrooklynObjectType.CATALOG_ITEM) {
                this.removedCatalogItemIds.remove(instance.getId());
            }
        }

        public void addIfNotRemoved(BrooklynObject instance) {
            BrooklynObjectType type = BrooklynObjectType.of((BrooklynObject)instance);
            if (!this.getRemovedIdsOfType(type).contains(instance.getId())) {
                this.getUnsafeCollectionOfType(type).add(instance);
            }
        }

        public void remove(BrooklynObject instance) {
            BrooklynObjectType type = BrooklynObjectType.of((BrooklynObject)instance);
            this.getUnsafeCollectionOfType(type).remove(instance);
            this.getRemovedIdsOfType(type).add(instance.getId());
        }

        private Set<BrooklynObject> getUnsafeCollectionOfType(BrooklynObjectType type) {
            return this.getCollectionOfType(type);
        }

        private Set<? extends BrooklynObject> getCollectionOfType(BrooklynObjectType type) {
            switch (type) {
                case ENTITY: {
                    return this.entities;
                }
                case LOCATION: {
                    return this.locations;
                }
                case ENRICHER: {
                    return this.enrichers;
                }
                case FEED: {
                    return this.feeds;
                }
                case POLICY: {
                    return this.policies;
                }
                case CATALOG_ITEM: {
                    return this.catalogItems;
                }
            }
            throw new IllegalStateException("No collection for type " + type);
        }

        private Set<String> getRemovedIdsOfType(BrooklynObjectType type) {
            switch (type) {
                case ENTITY: {
                    return this.removedEntityIds;
                }
                case LOCATION: {
                    return this.removedLocationIds;
                }
                case ENRICHER: {
                    return this.removedEnricherIds;
                }
                case FEED: {
                    return this.removedFeedIds;
                }
                case POLICY: {
                    return this.removedPolicyIds;
                }
                case CATALOG_ITEM: {
                    return this.removedCatalogItemIds;
                }
            }
            throw new IllegalStateException("No removed ids for type " + type);
        }
    }
}

