/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind;

import brooklyn.basic.BrooklynObject;
import brooklyn.config.BrooklynLogging;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.rebind.RebindExceptionHandler;
import brooklyn.entity.rebind.RebindIteration;
import brooklyn.entity.rebind.RebindManagerImpl;
import brooklyn.entity.rebind.persister.PersistenceActivityMetrics;
import brooklyn.management.ha.ManagementNodeState;
import brooklyn.management.internal.BrooklynObjectManagementMode;
import brooklyn.management.internal.EntityManagerInternal;
import brooklyn.management.internal.LocationManagerInternal;
import brooklyn.management.internal.ManagementTransitionMode;
import brooklyn.mementos.BrooklynMementoPersister;
import brooklyn.util.text.Strings;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialFullRebindIteration
extends RebindIteration {
    private static final Logger LOG = LoggerFactory.getLogger(InitialFullRebindIteration.class);

    public InitialFullRebindIteration(RebindManagerImpl rebindManager, ManagementNodeState mode, ClassLoader classLoader, RebindExceptionHandler exceptionHandler, Semaphore rebindActive, AtomicInteger readOnlyRebindCount, PersistenceActivityMetrics rebindMetrics, BrooklynMementoPersister persistenceStoreAccess) {
        super(rebindManager, mode, classLoader, exceptionHandler, rebindActive, readOnlyRebindCount, rebindMetrics, persistenceStoreAccess);
    }

    @Override
    protected boolean isRebindingActiveAgain() {
        return false;
    }

    @Override
    protected void doRun() throws Exception {
        LOG.debug("Rebinding (" + this.mode + (this.readOnlyRebindCount.get() > Integer.MIN_VALUE ? ", iteration " + this.readOnlyRebindCount : "") + ") from " + this.rebindManager.getPersister().getBackingStoreDescription() + "...");
        super.doRun();
    }

    @Override
    protected void loadManifestFiles() throws Exception {
        Entity anEntity;
        this.checkEnteringPhase(1);
        Preconditions.checkState((this.mementoRawData == null ? 1 : 0) != 0, (Object)"Memento raw data should not yet be set when calling this");
        this.mementoRawData = this.persistenceStoreAccess.loadMementoRawData(this.exceptionHandler);
        this.preprocessManifestFiles();
        if (!this.isEmpty.booleanValue()) {
            if (!ManagementNodeState.isHotProxy((ManagementNodeState)this.mode) || this.readOnlyRebindCount.get() == 1) {
                LOG.info("Rebinding from " + this.getPersister().getBackingStoreDescription() + " for " + Strings.toLowerCase((String)Strings.toString((Object)this.mode)) + " " + this.managementContext.getManagementNodeId() + "...");
            }
        } else if (!ManagementNodeState.isHotProxy((ManagementNodeState)this.mode)) {
            LOG.info("Rebind check: no existing state; will persist new items to " + this.getPersister().getBackingStoreDescription());
        }
        if (!(ManagementNodeState.isHotProxy((ManagementNodeState)this.mode) || this.managementContext.getEntityManager().getEntities().isEmpty() && this.managementContext.getLocationManager().getLocations().isEmpty() || (anEntity = (Entity)Iterables.getFirst((Iterable)this.managementContext.getEntityManager().getEntities(), null)) == null || ((EntityInternal)anEntity).getManagementSupport().isReadOnly())) {
            this.overwritingMaster = true;
            LOG.warn("Rebind requested for " + this.mode + " node " + this.managementContext.getManagementNodeId() + " " + "when it already has active state; discouraged, " + "will likely overwrite: " + this.managementContext.getEntityManager().getEntities() + " and " + this.managementContext.getLocationManager().getLocations() + " and more");
        }
    }

    @Override
    protected void cleanupOldLocations(Set<String> oldLocations) {
        LocationManagerInternal locationManager = (LocationManagerInternal)this.managementContext.getLocationManager();
        if (!oldLocations.isEmpty()) {
            BrooklynLogging.log(LOG, this.overwritingMaster != false ? BrooklynLogging.LoggingLevel.WARN : BrooklynLogging.LoggingLevel.DEBUG, "Destroying unused locations on rebind: " + oldLocations, new Object[0]);
        }
        for (String oldLocationId : oldLocations) {
            locationManager.unmanage((BrooklynObject)locationManager.getLocation(oldLocationId), ManagementTransitionMode.guessing(BrooklynObjectManagementMode.MANAGED_PRIMARY, BrooklynObjectManagementMode.NONEXISTENT));
        }
    }

    @Override
    protected void cleanupOldEntities(Set<String> oldEntities) {
        EntityManagerInternal entityManager = (EntityManagerInternal)this.managementContext.getEntityManager();
        if (!oldEntities.isEmpty()) {
            BrooklynLogging.log(LOG, this.overwritingMaster != false ? BrooklynLogging.LoggingLevel.WARN : BrooklynLogging.LoggingLevel.DEBUG, "Destroying unused entities on rebind: " + oldEntities, new Object[0]);
        }
        for (String oldEntityId : oldEntities) {
            entityManager.unmanage((BrooklynObject)entityManager.getEntity(oldEntityId), ManagementTransitionMode.guessing(BrooklynObjectManagementMode.MANAGED_PRIMARY, BrooklynObjectManagementMode.NONEXISTENT));
        }
    }
}

