/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind;

import brooklyn.config.ConfigKey;
import brooklyn.entity.rebind.AbstractBrooklynObjectRebindSupport;
import brooklyn.entity.rebind.RebindContext;
import brooklyn.entity.rebind.dto.BasicLocationMemento;
import brooklyn.entity.rebind.dto.MementosGenerators;
import brooklyn.location.Location;
import brooklyn.location.basic.AbstractLocation;
import brooklyn.mementos.LocationMemento;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.flags.TypeCoercions;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicLocationRebindSupport
extends AbstractBrooklynObjectRebindSupport<LocationMemento> {
    private static final Logger LOG = LoggerFactory.getLogger(BasicLocationRebindSupport.class);
    private final AbstractLocation location;

    public BasicLocationRebindSupport(AbstractLocation location) {
        super(location);
        this.location = location;
    }

    @Override
    public LocationMemento getMemento() {
        return this.getMementoWithProperties(Collections.emptyMap());
    }

    @Deprecated
    protected LocationMemento getMementoWithProperties(Map<String, ?> props) {
        LocationMemento memento = ((BasicLocationMemento.Builder)MementosGenerators.newLocationMementoBuilder(this.location).customFields(props)).build();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating memento for location: {}", (Object)memento.toVerboseString());
        }
        return memento;
    }

    @Override
    protected void addConfig(RebindContext rebindContext, LocationMemento memento) {
        this.location.config().getLocalBag().putAll(memento.getLocationConfig()).markAll((Iterable<String>)Sets.difference(memento.getLocationConfig().keySet(), (Set)memento.getLocationConfigUnused())).setDescription(memento.getLocationConfigDescription());
        for (Map.Entry entry : memento.getLocationConfig().entrySet()) {
            String flagName = (String)entry.getKey();
            try {
                Field field = FlagUtils.findFieldForFlag(flagName, this.location);
                Class<?> fieldType = field.getType();
                Object value = entry.getValue();
                if (ConfigKey.class.isAssignableFrom(fieldType)) {
                    ConfigKey configKey = (ConfigKey)FlagUtils.getField(this.location, field);
                    value = TypeCoercions.coerce(entry.getValue(), configKey.getTypeToken());
                } else {
                    value = TypeCoercions.coerce(entry.getValue(), fieldType);
                }
                if (value == null) continue;
                this.location.config().addToLocalBag((Map<String, ?>)MutableMap.of((Object)flagName, value));
                FlagUtils.setFieldFromFlag(this.location, flagName, value);
            }
            catch (NoSuchElementException e) {}
        }
    }

    @Override
    protected void addCustoms(RebindContext rebindContext, LocationMemento memento) {
        this.setParent(rebindContext, memento);
        this.addChildren(rebindContext, memento);
        this.location.init();
    }

    @Override
    public void addFeeds(RebindContext rebindContext, LocationMemento Memento2) {
        throw new UnsupportedOperationException();
    }

    protected void addChildren(RebindContext rebindContext, LocationMemento memento) {
        for (String childId : memento.getChildren()) {
            Location child = rebindContext.lookup().lookupLocation(childId);
            if (child != null) {
                this.location.addChild(child);
                continue;
            }
            LOG.warn("Ignoring child {} of location {}({}), as cannot be found", new Object[]{childId, memento.getType(), memento.getId()});
        }
    }

    protected void setParent(RebindContext rebindContext, LocationMemento memento) {
        Location parent;
        Location location = parent = memento.getParent() != null ? rebindContext.lookup().lookupLocation(memento.getParent()) : null;
        if (parent != null) {
            this.location.setParent(parent);
        } else if (memento.getParent() != null) {
            LOG.warn("Ignoring parent {} of location {}({}), as cannot be found", new Object[]{memento.getParent(), memento.getType(), memento.getId()});
        }
    }
}

