/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind;

import brooklyn.basic.BrooklynObject;
import brooklyn.config.ConfigKey;
import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.Feed;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.AbstractGroupImpl;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.rebind.AbstractBrooklynObjectRebindSupport;
import brooklyn.entity.rebind.BrooklynObjectType;
import brooklyn.entity.rebind.RebindContext;
import brooklyn.entity.rebind.dto.BasicEntityMemento;
import brooklyn.entity.rebind.dto.MementosGenerators;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.AbstractFeed;
import brooklyn.location.Location;
import brooklyn.mementos.EntityMemento;
import brooklyn.policy.Enricher;
import brooklyn.policy.Policy;
import brooklyn.policy.basic.AbstractPolicy;
import brooklyn.util.exceptions.Exceptions;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicEntityRebindSupport
extends AbstractBrooklynObjectRebindSupport<EntityMemento> {
    private static final Logger LOG = LoggerFactory.getLogger(BasicEntityRebindSupport.class);
    private final EntityLocal entity;

    public BasicEntityRebindSupport(AbstractEntity entity) {
        super(entity);
        this.entity = (EntityLocal)Preconditions.checkNotNull((Object)entity, (Object)"entity");
    }

    @Override
    public EntityMemento getMemento() {
        return this.getMementoWithProperties(Collections.emptyMap());
    }

    @Deprecated
    protected EntityMemento getMementoWithProperties(Map<String, ?> props) {
        EntityMemento memento = ((BasicEntityMemento.Builder)MementosGenerators.newEntityMementoBuilder((Entity)this.entity).customFields(props)).build();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating memento for entity: {}", (Object)memento.toVerboseString());
        }
        return memento;
    }

    @Override
    protected void addCustoms(RebindContext rebindContext, EntityMemento memento) {
        for (Effector effector : memento.getEffectors()) {
            ((EntityInternal)this.entity).getMutableEntityType().addEffector(effector);
        }
        for (Map.Entry entry : memento.getAttributes().entrySet()) {
            try {
                AttributeSensor key = (AttributeSensor)entry.getKey();
                Object value = entry.getValue();
                Class type = key.getType() != null ? key.getType() : rebindContext.loadClass(key.getTypeName());
                ((EntityInternal)this.entity).setAttributeWithoutPublishing(key, value);
            }
            catch (Exception e) {
                LOG.warn("Error adding custom sensor " + entry + " when rebinding " + this.entity + " (rethrowing): " + e);
                throw Exceptions.propagate((Throwable)e);
            }
        }
        this.setParent(rebindContext, memento);
        this.addChildren(rebindContext, memento);
        this.addMembers(rebindContext, memento);
        this.addLocations(rebindContext, memento);
    }

    @Override
    protected void addConfig(RebindContext rebindContext, EntityMemento memento) {
        for (Map.Entry entry : memento.getConfig().entrySet()) {
            try {
                ConfigKey key = (ConfigKey)entry.getKey();
                Object value = entry.getValue();
                Class type = key.getType() != null ? key.getType() : rebindContext.loadClass(key.getTypeName());
                this.entity.setConfig(key, value);
            }
            catch (ClassNotFoundException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        ((EntityInternal)this.entity).getConfigMap().addToLocalBag(memento.getConfigUnmatched());
        ((EntityInternal)this.entity).refreshInheritedConfig();
    }

    @Override
    public void addPolicies(RebindContext rebindContext, EntityMemento memento) {
        for (String policyId : memento.getPolicies()) {
            AbstractPolicy policy = (AbstractPolicy)rebindContext.lookup().lookupPolicy(policyId);
            if (policy != null) {
                try {
                    this.entity.addPolicy((Policy)policy);
                }
                catch (Exception e) {
                    rebindContext.getExceptionHandler().onAddPolicyFailed(this.entity, (Policy)policy, e);
                }
                continue;
            }
            LOG.warn("Policy not found; discarding policy {} of entity {}({})", new Object[]{policyId, memento.getType(), memento.getId()});
            rebindContext.getExceptionHandler().onDanglingPolicyRef(policyId);
        }
    }

    @Override
    public void addEnrichers(RebindContext rebindContext, EntityMemento memento) {
        for (String enricherId : memento.getEnrichers()) {
            AbstractEnricher enricher = (AbstractEnricher)rebindContext.lookup().lookupEnricher(enricherId);
            if (enricher != null) {
                try {
                    this.entity.addEnricher((Enricher)enricher);
                }
                catch (Exception e) {
                    rebindContext.getExceptionHandler().onAddEnricherFailed(this.entity, (Enricher)enricher, e);
                }
                continue;
            }
            LOG.warn("Enricher not found; discarding enricher {} of entity {}({})", new Object[]{enricherId, memento.getType(), memento.getId()});
        }
    }

    @Override
    public void addFeeds(RebindContext rebindContext, EntityMemento memento) {
        for (String feedId : memento.getFeeds()) {
            AbstractFeed feed = (AbstractFeed)rebindContext.lookup().lookupFeed(feedId);
            if (feed != null) {
                try {
                    ((EntityInternal)this.entity).feeds().addFeed(feed);
                }
                catch (Exception e) {
                    rebindContext.getExceptionHandler().onAddFeedFailed(this.entity, (Feed)feed, e);
                }
                try {
                    if (rebindContext.isReadOnly((BrooklynObject)feed)) continue;
                    feed.start();
                }
                catch (Exception e) {
                    rebindContext.getExceptionHandler().onRebindFailed(BrooklynObjectType.ENTITY, (BrooklynObject)this.entity, e);
                }
                continue;
            }
            LOG.warn("Feed not found; discarding feed {} of entity {}({})", new Object[]{feedId, memento.getType(), memento.getId()});
        }
    }

    protected void addMembers(RebindContext rebindContext, EntityMemento memento) {
        if (memento.getMembers().size() > 0) {
            if (this.entity instanceof AbstractGroupImpl) {
                for (String memberId : memento.getMembers()) {
                    Entity member = rebindContext.lookup().lookupEntity(memberId);
                    if (member != null) {
                        ((AbstractGroupImpl)this.entity).addMemberInternal(member);
                        continue;
                    }
                    LOG.warn("Entity not found; discarding member {} of group {}({})", new Object[]{memberId, memento.getType(), memento.getId()});
                }
            } else {
                throw new UnsupportedOperationException("Entity with members should be a group: entity=" + this.entity + "; type=" + this.entity.getClass() + "; members=" + memento.getMembers());
            }
        }
    }

    protected Entity proxy(Entity target) {
        return target instanceof AbstractEntity ? ((AbstractEntity)target).getProxyIfAvailable() : target;
    }

    protected void addChildren(RebindContext rebindContext, EntityMemento memento) {
        for (String childId : memento.getChildren()) {
            Entity child = rebindContext.lookup().lookupEntity(childId);
            if (child != null) {
                this.entity.addChild(this.proxy(child));
                continue;
            }
            LOG.warn("Entity not found; discarding child {} of entity {}({})", new Object[]{childId, memento.getType(), memento.getId()});
        }
    }

    protected void setParent(RebindContext rebindContext, EntityMemento memento) {
        Entity parent;
        Entity entity = parent = memento.getParent() != null ? rebindContext.lookup().lookupEntity(memento.getParent()) : null;
        if (parent != null) {
            this.entity.setParent(this.proxy(parent));
        } else if (memento.getParent() != null) {
            LOG.warn("Entity not found; discarding parent {} of entity {}({}), so entity will be orphaned and unmanaged", new Object[]{memento.getParent(), memento.getType(), memento.getId()});
        }
    }

    protected void addLocations(RebindContext rebindContext, EntityMemento memento) {
        for (String id : memento.getLocations()) {
            Location loc = rebindContext.lookup().lookupLocation(id);
            if (loc != null) {
                ((EntityInternal)this.entity).addLocations((Collection<? extends Location>)ImmutableList.of((Object)loc));
                continue;
            }
            LOG.warn("Location not found; discarding location {} of entity {}({})", new Object[]{id, memento.getType(), memento.getId()});
        }
    }
}

