/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind;

import brooklyn.basic.BrooklynObject;
import brooklyn.basic.BrooklynObjectInternal;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.rebind.BrooklynObjectType;
import brooklyn.entity.rebind.RebindExceptionHandler;
import brooklyn.entity.rebind.RebindIteration;
import brooklyn.entity.rebind.RebindManagerImpl;
import brooklyn.entity.rebind.persister.BrooklynMementoPersisterToObjectStore;
import brooklyn.entity.rebind.persister.PersistenceActivityMetrics;
import brooklyn.entity.rebind.transformer.CompoundTransformer;
import brooklyn.management.ha.ManagementNodeState;
import brooklyn.mementos.BrooklynMementoPersister;
import brooklyn.mementos.BrooklynMementoRawData;
import brooklyn.mementos.Memento;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableSet;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivePartialRebindIteration
extends RebindIteration {
    private static final Logger LOG = LoggerFactory.getLogger(ActivePartialRebindIteration.class);
    protected Iterator<BrooklynObject> objectsToRebindInitial;
    protected Collection<BrooklynObject> objectsToRebindFinal;
    protected List<CompoundTransformer> transformers = MutableList.of();

    public ActivePartialRebindIteration(RebindManagerImpl rebindManager, ManagementNodeState mode, ClassLoader classLoader, RebindExceptionHandler exceptionHandler, Semaphore rebindActive, AtomicInteger readOnlyRebindCount, PersistenceActivityMetrics rebindMetrics, BrooklynMementoPersister persistenceStoreAccess) {
        super(rebindManager, mode, classLoader, exceptionHandler, rebindActive, readOnlyRebindCount, rebindMetrics, persistenceStoreAccess);
    }

    @Override
    protected boolean isRebindingActiveAgain() {
        return true;
    }

    public void setObjectIterator(Iterator<BrooklynObject> objectsToRebind) {
        this.objectsToRebindInitial = objectsToRebind;
    }

    public void applyTransformer(CompoundTransformer transformer) {
        this.transformers.add((CompoundTransformer)Preconditions.checkNotNull((Object)transformer, (Object)"transformer"));
    }

    @Override
    protected void doRun() throws Exception {
        Preconditions.checkState((this.rebindManager.getRebindMode() == ManagementNodeState.MASTER ? 1 : 0) != 0, (Object)("Partial rebind only supported in master mode, not " + this.rebindManager.getRebindMode()));
        Preconditions.checkState((this.readOnlyRebindCount.get() == Integer.MIN_VALUE ? 1 : 0) != 0, (Object)"Rebind count should be MIN when running in master mode");
        Preconditions.checkNotNull(this.objectsToRebindInitial, (Object)"Objects to rebind must be set");
        LOG.debug("Partial rebind Rebinding (" + this.mode + ") from " + this.rebindManager.getPersister().getBackingStoreDescription() + "...");
        super.doRun();
    }

    @Override
    protected void loadManifestFiles() throws Exception {
        this.checkEnteringPhase(1);
        BrooklynMementoRawData.Builder mementoRawBuilder = BrooklynMementoRawData.builder();
        this.objectsToRebindFinal = MutableSet.of();
        while (this.objectsToRebindInitial.hasNext()) {
            BrooklynObject bo = this.objectsToRebindInitial.next();
            this.objectsToRebindFinal.add(bo);
            if (!(bo instanceof Entity)) continue;
            this.objectsToRebindFinal.addAll(((EntityInternal)bo).getPolicies());
            this.objectsToRebindFinal.addAll(((EntityInternal)bo).getEnrichers());
            this.objectsToRebindFinal.addAll(((EntityInternal)bo).feeds().getFeeds());
        }
        for (BrooklynObject bo : this.objectsToRebindFinal) {
            Memento m = ((BrooklynObjectInternal)bo).getRebindSupport().getMemento();
            BrooklynMementoPersister p = this.rebindManager.getPersister();
            String mr = ((BrooklynMementoPersisterToObjectStore)p).getMementoSerializer().toString(m);
            mementoRawBuilder.put(BrooklynObjectType.of((BrooklynObject)bo), bo.getId(), mr);
        }
        this.mementoRawData = mementoRawBuilder.build();
        this.preprocessManifestFiles();
    }

    @Override
    protected void preprocessManifestFiles() throws Exception {
        for (CompoundTransformer transformer : this.transformers) {
            this.mementoRawData = transformer.transform(this.mementoRawData);
        }
        super.preprocessManifestFiles();
        this.overwritingMaster = true;
    }

    @Override
    protected void rebuildCatalog() {
        this.checkEnteringPhase(2);
    }

    @Override
    protected Collection<String> getMementoRootEntities() {
        return this.memento.getEntityIds();
    }

    @Override
    protected void cleanupOldLocations(Set<String> oldLocations) {
    }

    @Override
    protected void cleanupOldEntities(Set<String> oldEntities) {
    }
}

