/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.rebind;

import brooklyn.basic.AbstractBrooklynObject;
import brooklyn.basic.BrooklynObject;
import brooklyn.entity.rebind.RebindContext;
import brooklyn.entity.rebind.RebindSupport;
import brooklyn.entity.rebind.dto.MementosGenerators;
import brooklyn.mementos.Memento;
import brooklyn.policy.EntityAdjunct;
import brooklyn.policy.basic.AbstractEntityAdjunct;
import brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBrooklynObjectRebindSupport<T extends Memento>
implements RebindSupport<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBrooklynObjectRebindSupport.class);
    private final AbstractBrooklynObject instance;

    public AbstractBrooklynObjectRebindSupport(AbstractBrooklynObject instance) {
        this.instance = instance;
    }

    public T getMemento() {
        Memento memento = MementosGenerators.newBasicMemento(this.instance);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created memento: {}", (Object)memento.toVerboseString());
        }
        return (T)memento;
    }

    public void reconstruct(RebindContext rebindContext, T memento) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reconstructing: {}", (Object)memento.toVerboseString());
        }
        this.instance.setDisplayName(memento.getDisplayName());
        this.addConfig(rebindContext, memento);
        this.addTags(rebindContext, memento);
        this.addCustoms(rebindContext, memento);
        this.doReconstruct(rebindContext, memento);
        if (!rebindContext.isReadOnly((BrooklynObject)this.instance)) {
            this.instance.rebind();
        }
    }

    protected abstract void addConfig(RebindContext var1, T var2);

    protected abstract void addCustoms(RebindContext var1, T var2);

    protected void addTags(RebindContext rebindContext, T memento) {
        if (this.instance instanceof EntityAdjunct && Strings.isNonBlank((CharSequence)memento.getUniqueTag())) {
            ((AbstractEntityAdjunct.AdjunctTagSupport)this.instance.tags()).setUniqueTag(memento.getUniqueTag());
        }
        for (Object tag : memento.getTags()) {
            this.instance.tags().addTag(tag);
        }
    }

    public void addPolicies(RebindContext rebindContext, T Memento2) {
        throw new UnsupportedOperationException();
    }

    public void addEnrichers(RebindContext rebindContext, T Memento2) {
        throw new UnsupportedOperationException();
    }

    public void addFeeds(RebindContext rebindContext, T Memento2) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected void doReconstruct(RebindContext rebindContext, T memento) {
    }
}

