/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.proxying;

import brooklyn.config.ConfigKey;
import brooklyn.entity.proxying.InternalFactory;
import brooklyn.location.Location;
import brooklyn.location.LocationSpec;
import brooklyn.location.basic.AbstractLocation;
import brooklyn.location.basic.LocationInternal;
import brooklyn.management.ManagementContext;
import brooklyn.management.internal.LocalLocationManager;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.FlagUtils;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class InternalLocationFactory
extends InternalFactory {
    @Deprecated
    public static boolean isNewStyleLocation(ManagementContext managementContext, Class<?> clazz) {
        try {
            return InternalLocationFactory.isNewStyleLocation(clazz);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Deprecated
    public static boolean isNewStyleLocation(Class<?> clazz) {
        if (!Location.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz + " is not an location");
        }
        return InternalFactory.isNewStyle(clazz);
    }

    public InternalLocationFactory(ManagementContextInternal managementContext) {
        super(managementContext);
    }

    public <T extends Location> T createLocation(LocationSpec<T> spec) {
        if (spec.getFlags().containsKey("parent")) {
            throw new IllegalArgumentException("Spec's flags must not contain parent; use spec.parent() instead for " + spec);
        }
        if (spec.getFlags().containsKey("id")) {
            throw new IllegalArgumentException("Spec's flags must not contain id; use spec.id() instead for " + spec);
        }
        if (spec.getId() != null && ((LocalLocationManager)this.managementContext.getLocationManager()).isKnownLocationId(spec.getId())) {
            throw new IllegalArgumentException("Entity with id " + spec.getId() + " already exists; cannot create new entity with this explicit id from spec " + spec);
        }
        try {
            Class clazz = spec.getType();
            Location loc = (Location)this.construct(clazz, spec.getFlags());
            if (spec.getId() != null) {
                FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"id", (Object)spec.getId()), loc);
            }
            this.managementContext.prePreManage(loc);
            if (spec.getDisplayName() != null) {
                ((AbstractLocation)loc).setDisplayName(spec.getDisplayName());
            }
            if (spec.getCatalogItemId() != null) {
                ((AbstractLocation)loc).setCatalogItemId(spec.getCatalogItemId());
            }
            loc.tags().addTags((Iterable)spec.getTags());
            if (InternalLocationFactory.isNewStyle(clazz)) {
                ((AbstractLocation)loc).setManagementContext(this.managementContext);
                ((AbstractLocation)loc).configure((Map)ConfigBag.newInstance().putAll(spec.getFlags()).putAll(spec.getConfig()).getAllConfig());
            }
            for (Map.Entry entry : spec.getConfig().entrySet()) {
                ((AbstractLocation)loc).setConfig((ConfigKey)entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : spec.getExtensions().entrySet()) {
                ((LocationInternal)loc).addExtension((Class)entry.getKey(), entry.getValue());
            }
            ((AbstractLocation)loc).init();
            Location parent = spec.getParent();
            if (parent != null) {
                loc.setParent(parent);
            }
            return (T)loc;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public <T extends Location> T constructLocation(Class<T> clazz) {
        return (T)((Location)super.constructNewStyle(clazz));
    }

    @Override
    protected <T> T constructOldStyle(Class<T> clazz, Map<String, ?> flags) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (flags.containsKey("parent") || flags.containsKey("owner")) {
            throw new IllegalArgumentException("Spec's flags must not contain parent or owner; use spec.parent() instead for " + clazz);
        }
        return super.constructOldStyle(clazz, flags);
    }
}

