/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.proxying;

import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.javalang.Reflections;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class InternalFactory {
    protected final ManagementContextInternal managementContext;

    public static boolean isNewStyle(Class<?> clazz) {
        try {
            clazz.getConstructor(new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public InternalFactory(ManagementContextInternal managementContext) {
        this.managementContext = (ManagementContextInternal)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    protected <T> T construct(Class<? extends T> clazz, Map<String, ?> constructorFlags) {
        try {
            if (InternalFactory.isNewStyle(clazz)) {
                return this.constructNewStyle(clazz);
            }
            return this.constructOldStyle(clazz, (Map<String, ?>)MutableMap.copyOf(constructorFlags));
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T constructNewStyle(Class<T> clazz) {
        if (!InternalFactory.isNewStyle(clazz)) {
            throw new IllegalStateException("Class " + clazz + " must have a no-arg constructor");
        }
        try {
            FactoryConstructionTracker.setConstructing();
            try {
                T t = clazz.newInstance();
                return t;
            }
            finally {
                FactoryConstructionTracker.reset();
            }
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T constructOldStyle(Class<T> clazz, Map<String, ?> flags) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Optional v;
        FactoryConstructionTracker.setConstructing();
        try {
            v = Reflections.invokeConstructorWithArgs(clazz, (Object[])new Object[]{MutableMap.copyOf(flags)}, (boolean)true);
        }
        finally {
            FactoryConstructionTracker.reset();
        }
        if (v.isPresent()) {
            return (T)v.get();
        }
        throw new IllegalStateException("No valid constructor defined for " + clazz + " (expected no-arg or single java.util.Map argument)");
    }

    public static class FactoryConstructionTracker {
        private static ThreadLocal<Boolean> constructing = new ThreadLocal();

        public static boolean isConstructing() {
            return constructing.get() == Boolean.TRUE;
        }

        static void reset() {
            constructing.set(Boolean.FALSE);
        }

        static void setConstructing() {
            constructing.set(Boolean.TRUE);
        }
    }
}

