/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.proxying;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.AbstractApplication;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.proxying.EntityInitializer;
import brooklyn.entity.proxying.EntityProxy;
import brooklyn.entity.proxying.EntityProxyImpl;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.EntityTypeRegistry;
import brooklyn.entity.proxying.InternalFactory;
import brooklyn.entity.proxying.InternalPolicyFactory;
import brooklyn.management.internal.LocalEntityManager;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.policy.Enricher;
import brooklyn.policy.EnricherSpec;
import brooklyn.policy.Policy;
import brooklyn.policy.PolicySpec;
import brooklyn.policy.basic.AbstractPolicy;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.javalang.AggregateClassLoader;
import brooklyn.util.task.Tasks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalEntityFactory
extends InternalFactory {
    private static final Logger log = LoggerFactory.getLogger(InternalEntityFactory.class);
    private final EntityTypeRegistry entityTypeRegistry;
    private final InternalPolicyFactory policyFactory;

    public InternalEntityFactory(ManagementContextInternal managementContext, EntityTypeRegistry entityTypeRegistry, InternalPolicyFactory policyFactory) {
        super(managementContext);
        this.entityTypeRegistry = (EntityTypeRegistry)Preconditions.checkNotNull((Object)entityTypeRegistry, (Object)"entityTypeRegistry");
        this.policyFactory = (InternalPolicyFactory)Preconditions.checkNotNull((Object)policyFactory, (Object)"policyFactory");
    }

    @VisibleForTesting
    public <T extends Entity> T createEntityProxy(EntitySpec<T> spec, T entity) {
        LinkedHashSet interfaces = Sets.newLinkedHashSet();
        if (spec.getType().isInterface()) {
            interfaces.add(spec.getType());
        } else {
            log.warn("EntitySpec declared in terms of concrete type " + spec.getType() + "; should be supplied in terms of interface");
        }
        interfaces.addAll(spec.getAdditionalInterfaces());
        return this.createEntityProxy(interfaces, entity);
    }

    protected <T extends Entity> T createEntityProxy(Iterable<Class<?>> interfaces, T entity) {
        MutableSet allInterfaces = MutableSet.builder().add(EntityProxy.class, Entity.class, (Object[])new Class[]{EntityLocal.class, EntityInternal.class}).addAll(interfaces).build();
        LinkedHashSet loaders = Sets.newLinkedHashSet();
        this.addClassLoaders(entity.getClass(), loaders);
        for (Class iface : allInterfaces) {
            loaders.add(iface.getClassLoader());
        }
        AggregateClassLoader aggregateClassLoader = AggregateClassLoader.newInstanceWithNoLoaders();
        for (ClassLoader cl : loaders) {
            aggregateClassLoader.addLast(cl);
        }
        return (T)((Entity)Proxy.newProxyInstance((ClassLoader)aggregateClassLoader, allInterfaces.toArray(new Class[allInterfaces.size()]), (InvocationHandler)new EntityProxyImpl(entity)));
    }

    private void addClassLoaders(Class<?> type, Collection<ClassLoader> loaders) {
        Class<?> superType;
        ClassLoader cl = type.getClassLoader();
        if (cl != null) {
            loaders.add(cl);
        }
        if ((superType = type.getSuperclass()) != null) {
            this.addClassLoaders(superType, loaders);
        }
        for (Class<?> iface : type.getInterfaces()) {
            this.addClassLoaders(iface, loaders);
        }
    }

    public <T extends Entity> T createEntity(EntitySpec<T> spec) {
        MutableMap entitiesByEntityId = MutableMap.of();
        MutableMap specsByEntityId = MutableMap.of();
        T entity = this.createEntityAndDescendantsUninitialized(spec, (Map<String, Entity>)entitiesByEntityId, (Map<String, EntitySpec<?>>)specsByEntityId);
        this.initEntityAndDescendants(entity.getId(), (Map<String, Entity>)entitiesByEntityId, (Map<String, EntitySpec<?>>)specsByEntityId);
        return entity;
    }

    protected <T extends Entity> T createEntityAndDescendantsUninitialized(EntitySpec<T> spec, Map<String, Entity> entitiesByEntityId, Map<String, EntitySpec<?>> specsByEntityId) {
        if (spec.getFlags().containsKey("parent") || spec.getFlags().containsKey("owner")) {
            throw new IllegalArgumentException("Spec's flags must not contain parent or owner; use spec.parent() instead for " + spec);
        }
        if (spec.getFlags().containsKey("id")) {
            throw new IllegalArgumentException("Spec's flags must not contain id; use spec.id() instead for " + spec);
        }
        if (spec.getId() != null) {
            log.warn("Use of deprecated EntitySpec.id ({}); instead let management context pick the random+unique id", spec);
            if (((LocalEntityManager)this.managementContext.getEntityManager()).isKnownEntityId(spec.getId())) {
                throw new IllegalArgumentException("Entity with id " + spec.getId() + " already exists; cannot create new entity with this explicit id from spec " + spec);
            }
        }
        try {
            Class<T> clazz = this.getImplementedBy(spec);
            T entity = this.constructEntity(clazz, spec);
            this.loadUnitializedEntity(entity, spec);
            entitiesByEntityId.put(entity.getId(), (Entity)entity);
            specsByEntityId.put(entity.getId(), spec);
            for (EntitySpec childSpec : spec.getChildren()) {
                if (childSpec.getParent() != null) {
                    if (!childSpec.getParent().equals(entity)) {
                        throw new IllegalStateException("Spec " + childSpec + " has parent " + childSpec.getParent() + " defined, " + "but it is defined as a child of " + entity);
                    }
                    log.warn("Child spec " + childSpec + " is already set with parent " + entity + "; how did this happen?!");
                }
                childSpec.parent(entity);
                T child = this.createEntityAndDescendantsUninitialized(childSpec, entitiesByEntityId, specsByEntityId);
                entity.addChild(child);
            }
            for (Entity member : spec.getMembers()) {
                if (!(entity instanceof Group)) {
                    throw new IllegalStateException("Entity " + entity + " must be a group to add members " + spec.getMembers());
                }
                ((Group)entity).addMember(member);
            }
            for (Group group : spec.getGroups()) {
                group.addMember(entity);
            }
            return entity;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected <T extends Entity> T loadUnitializedEntity(T entity, EntitySpec<T> spec) {
        try {
            if (spec.getDisplayName() != null) {
                ((AbstractEntity)entity).setDisplayName(spec.getDisplayName());
            }
            if (spec.getCatalogItemId() != null) {
                ((AbstractEntity)entity).setCatalogItemId(spec.getCatalogItemId());
            }
            entity.tags().addTags((Iterable)spec.getTags());
            ((AbstractEntity)entity).configure((Map)MutableMap.copyOf((Map)spec.getFlags()));
            for (Map.Entry entry : spec.getConfig().entrySet()) {
                ((EntityLocal)entity).setConfig((ConfigKey)entry.getKey(), entry.getValue());
            }
            Entity parent = spec.getParent();
            if (parent != null) {
                parent = parent instanceof AbstractEntity ? ((AbstractEntity)parent).getProxyIfAvailable() : parent;
                entity.setParent(parent);
            }
            return entity;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected <T extends Entity> void initEntityAndDescendants(String entityId, final Map<String, Entity> entitiesByEntityId, final Map<String, EntitySpec<?>> specsByEntityId) {
        final Entity entity = entitiesByEntityId.get(entityId);
        final EntitySpec<?> spec = specsByEntityId.get(entityId);
        if (entity == null || spec == null) {
            log.debug("Skipping initialization of " + entityId + " found as child of entity being initialized, " + "but this child is not one we created; likely it was created by an initializer, " + "and thus it should be already fully initialized.");
            return;
        }
        ((EntityInternal)entity).getExecutionContext().submit(Tasks.builder().dynamic(false).name("Entity initialization").tag(BrooklynTaskTags.tagForContextEntity(entity)).tag("TRANSIENT").body(new Runnable(){

            @Override
            public void run() {
                ((AbstractEntity)entity).init();
                ((AbstractEntity)entity).addLocations(spec.getLocations());
                for (EntityInitializer initializer : spec.getInitializers()) {
                    initializer.apply((EntityLocal)((EntityInternal)entity));
                }
                for (Enricher enricher : spec.getEnrichers()) {
                    entity.addEnricher(enricher);
                }
                for (EnricherSpec enricherSpec : spec.getEnricherSpecs()) {
                    entity.addEnricher(InternalEntityFactory.this.policyFactory.createEnricher(enricherSpec));
                }
                for (Policy policy : spec.getPolicies()) {
                    entity.addPolicy((Policy)((AbstractPolicy)policy));
                }
                for (PolicySpec policySpec : spec.getPolicySpecs()) {
                    entity.addPolicy(InternalEntityFactory.this.policyFactory.createPolicy(policySpec));
                }
                for (Entity child : entity.getChildren()) {
                    InternalEntityFactory.this.initEntityAndDescendants(child.getId(), entitiesByEntityId, specsByEntityId);
                }
            }
        }).build()).getUnchecked();
    }

    public <T extends Entity> T constructEntity(Class<? extends T> clazz, EntitySpec<T> spec) {
        T entity = this.constructEntityImpl(clazz, spec.getFlags(), spec.getId());
        if (((AbstractEntity)entity).getProxy() == null) {
            ((AbstractEntity)entity).setProxy((Entity)this.createEntityProxy(spec, entity));
        }
        return entity;
    }

    public <T extends Entity> T constructEntity(Class<T> clazz, Iterable<Class<?>> interfaces, String entityId) {
        if (!InternalEntityFactory.isNewStyle(clazz)) {
            throw new IllegalStateException("Cannot construct old-style entity " + clazz);
        }
        Preconditions.checkNotNull((Object)entityId, (Object)"entityId");
        Preconditions.checkState((interfaces != null && !Iterables.isEmpty(interfaces) ? 1 : 0) != 0, (String)"must have at least one interface for entity %s:%s", (Object[])new Object[]{clazz, entityId});
        T entity = this.constructEntityImpl((Class<? extends T>)clazz, (Map<String, ?>)ImmutableMap.of(), entityId);
        if (((AbstractEntity)entity).getProxy() == null) {
            Object proxy = this.managementContext.getEntityManager().getEntity(entity.getId());
            if (proxy == null) {
                proxy = this.createEntityProxy(interfaces, entity);
            }
            ((AbstractEntity)entity).setProxy((Entity)proxy);
        }
        return entity;
    }

    protected <T extends Entity> T constructEntityImpl(Class<? extends T> clazz, Map<String, ?> constructionFlags, String entityId) {
        Entity entity = (Entity)super.construct(clazz, constructionFlags);
        if (entityId != null) {
            FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"id", (Object)entityId), entity);
        }
        if (entity instanceof AbstractApplication) {
            FlagUtils.setFieldsFromFlags(ImmutableMap.of((Object)"mgmt", (Object)this.managementContext), entity);
        }
        this.managementContext.prePreManage(entity);
        ((AbstractEntity)entity).setManagementContext(this.managementContext);
        return (T)entity;
    }

    @Override
    protected <T> T constructOldStyle(Class<T> clazz, Map<String, ?> flags) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (flags.containsKey("parent") || flags.containsKey("owner")) {
            throw new IllegalArgumentException("Spec's flags must not contain parent or owner; use spec.parent() instead for " + clazz);
        }
        return super.constructOldStyle(clazz, flags);
    }

    private <T extends Entity> Class<? extends T> getImplementedBy(EntitySpec<T> spec) {
        if (spec.getImplementation() != null) {
            return spec.getImplementation();
        }
        return this.entityTypeRegistry.getImplementedBy(spec.getType());
    }
}

