/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.proxying;

import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.EntityTransientCopyInternal;
import brooklyn.entity.effector.EffectorWithBody;
import brooklyn.entity.rebind.RebindManagerImpl;
import brooklyn.management.ManagementContext;
import brooklyn.management.TaskAdaptable;
import brooklyn.management.internal.EffectorUtils;
import brooklyn.management.internal.EntityManagerInternal;
import brooklyn.management.internal.ManagementTransitionMode;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.TaskTags;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityProxyImpl
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(EntityProxyImpl.class);
    private Entity delegate;
    private Boolean isMaster;
    private WeakHashMap<Entity, Void> temporaryProxies = new WeakHashMap();
    private static final Set<MethodSignature> OBJECT_METHODS = Sets.newLinkedHashSet();
    private static final Set<MethodSignature> ENTITY_NON_EFFECTOR_METHODS;
    private static final Set<MethodSignature> ENTITY_PERMITTED_READ_ONLY_METHODS;

    public EntityProxyImpl(Entity entity) {
        this.delegate = (Entity)Preconditions.checkNotNull((Object)entity, (Object)"entity");
    }

    public synchronized void resetDelegate(Entity thisProxy, Entity preferredProxy, Entity newDelegate) {
        Entity temporaryProxy;
        if (LOG.isTraceEnabled()) {
            LOG.trace("updating " + Integer.toHexString(System.identityHashCode(thisProxy)) + " to be the same as " + Integer.toHexString(System.identityHashCode(preferredProxy)) + " pointing at " + Integer.toHexString(System.identityHashCode(newDelegate)) + " (" + this.temporaryProxies.size() + " temporary proxies)");
        }
        Entity oldDelegate = this.delegate;
        this.delegate = newDelegate;
        this.isMaster = null;
        if (newDelegate == oldDelegate) {
            return;
        }
        if (oldDelegate != null) {
            temporaryProxy = ((AbstractEntity)oldDelegate).getProxy();
            if (temporaryProxy != null) {
                this.temporaryProxies.put(temporaryProxy, null);
            }
            ((AbstractEntity)oldDelegate).resetProxy(preferredProxy);
        }
        if (newDelegate != null) {
            temporaryProxy = ((AbstractEntity)newDelegate).getProxy();
            if (temporaryProxy != null) {
                this.temporaryProxies.put(temporaryProxy, null);
            }
            ((AbstractEntity)newDelegate).resetProxy(preferredProxy);
        }
        for (Entity tp : this.temporaryProxies.keySet()) {
            if (tp == thisProxy || tp == preferredProxy) continue;
            ((EntityProxyImpl)Proxy.getInvocationHandler(tp)).resetDelegate(tp, preferredProxy, newDelegate);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    protected boolean isMaster() {
        if (this.isMaster != null) {
            return this.isMaster;
        }
        ManagementContext mgmt = ((EntityInternal)this.delegate).getManagementContext();
        ManagementTransitionMode mode = ((EntityManagerInternal)mgmt.getEntityManager()).getLastManagementTransitionMode(this.delegate.getId());
        Boolean ro = ((EntityInternal)this.delegate).getManagementSupport().isReadOnlyRaw();
        if (mode == null || ro == null) {
            return false;
        }
        boolean isMasterX = !mode.isReadOnly();
        if (isMasterX != (ro == false)) {
            LOG.warn("Inconsistent read-only state for " + this.delegate + " (possibly rebinding); " + "management thinks " + isMasterX + " but entity thinks " + (ro == false));
            return false;
        }
        this.isMaster = isMasterX;
        return isMasterX;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result;
        if (proxy == null) {
            throw new IllegalArgumentException("Static methods not supported via proxy on entity " + this.delegate);
        }
        MethodSignature sig = new MethodSignature(m);
        if (OBJECT_METHODS.contains(sig)) {
            result = m.invoke((Object)this.delegate, args);
            return result == this.delegate && this.delegate instanceof AbstractEntity ? ((AbstractEntity)result).getProxy() : result;
        } else if (ENTITY_PERMITTED_READ_ONLY_METHODS.contains(sig)) {
            result = m.invoke((Object)this.delegate, args);
            return result == this.delegate && this.delegate instanceof AbstractEntity ? ((AbstractEntity)result).getProxy() : result;
        } else if (!this.isMaster()) {
            if (this.isMaster != null && !RebindManagerImpl.RebindTracker.isRebinding()) throw new UnsupportedOperationException("Call to '" + sig + "' not permitted on read-only entity " + this.delegate);
            result = m.invoke((Object)this.delegate, args);
            return result == this.delegate && this.delegate instanceof AbstractEntity ? ((AbstractEntity)result).getProxy() : result;
        } else if (ENTITY_NON_EFFECTOR_METHODS.contains(sig)) {
            result = m.invoke((Object)this.delegate, args);
            return result == this.delegate && this.delegate instanceof AbstractEntity ? ((AbstractEntity)result).getProxy() : result;
        } else {
            Object[] nonNullArgs = args == null ? new Object[]{} : args;
            Effector<?> eff = this.findEffector(m, nonNullArgs);
            if (eff != null) {
                Map parameters = EffectorUtils.prepareArgsForEffectorAsMapFromArray(eff, nonNullArgs);
                TaskAdaptable task = ((EffectorWithBody)eff).getBody().newTask(this.delegate, eff, ConfigBag.newInstance(parameters));
                TaskTags.markInessential(task);
                result = DynamicTasks.queueIfPossible(task.asTask()).orSubmitAsync(this.delegate).andWaitForSuccess();
                return result == this.delegate && this.delegate instanceof AbstractEntity ? ((AbstractEntity)result).getProxy() : result;
            } else {
                result = m.invoke((Object)this.delegate, nonNullArgs);
            }
        }
        return result == this.delegate && this.delegate instanceof AbstractEntity ? ((AbstractEntity)result).getProxy() : result;
    }

    private Effector<?> findEffector(Method m, Object[] args) {
        String name = m.getName();
        Set effectors = this.delegate.getEntityType().getEffectors();
        for (Effector contender : effectors) {
            if (!name.equals(contender.getName())) continue;
            return contender;
        }
        return null;
    }

    @VisibleForTesting
    public Entity getDelegate() {
        return this.delegate;
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    static {
        for (Method m : Object.class.getMethods()) {
            OBJECT_METHODS.add(new MethodSignature(m));
        }
        ENTITY_NON_EFFECTOR_METHODS = Sets.newLinkedHashSet();
        for (Method m : Entity.class.getMethods()) {
            ENTITY_NON_EFFECTOR_METHODS.add(new MethodSignature(m));
        }
        for (Method m : EntityLocal.class.getMethods()) {
            ENTITY_NON_EFFECTOR_METHODS.add(new MethodSignature(m));
        }
        for (Method m : EntityInternal.class.getMethods()) {
            ENTITY_NON_EFFECTOR_METHODS.add(new MethodSignature(m));
        }
        ENTITY_PERMITTED_READ_ONLY_METHODS = Sets.newLinkedHashSet();
        for (Method m : EntityTransientCopyInternal.class.getMethods()) {
            ENTITY_PERMITTED_READ_ONLY_METHODS.add(new MethodSignature(m));
        }
        if (!ENTITY_NON_EFFECTOR_METHODS.containsAll(ENTITY_PERMITTED_READ_ONLY_METHODS)) {
            LinkedHashSet<MethodSignature> extras = new LinkedHashSet<MethodSignature>(ENTITY_PERMITTED_READ_ONLY_METHODS);
            extras.removeAll(ENTITY_NON_EFFECTOR_METHODS);
            throw new IllegalStateException("Entity read-only methods contains items not known as Entity methods: " + extras);
        }
        for (Method m : EntityTransientCopyInternal.SpecialEntityTransientCopyInternal.class.getMethods()) {
            ENTITY_PERMITTED_READ_ONLY_METHODS.add(new MethodSignature(m));
        }
    }

    private static class MethodSignature {
        private final String name;
        private final Class<?>[] parameterTypes;

        MethodSignature(Method m) {
            this.name = m.getName();
            this.parameterTypes = m.getParameterTypes();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, Arrays.hashCode(this.parameterTypes)});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodSignature)) {
                return false;
            }
            MethodSignature o = (MethodSignature)obj;
            return this.name.equals(o.name) && Arrays.equals(this.parameterTypes, o.parameterTypes);
        }

        public String toString() {
            return this.name + Arrays.toString(this.parameterTypes);
        }
    }
}

