/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.proxying;

import brooklyn.entity.Entity;
import brooklyn.entity.proxying.EntityTypeRegistry;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.util.exceptions.Exceptions;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicEntityTypeRegistry
implements EntityTypeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(BasicEntityTypeRegistry.class);
    private final BiMap<Class<?>, Class<?>> registry = HashBiMap.create();
    private final BiMap<Class<?>, Class<?>> cache = HashBiMap.create();
    private final Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entity> EntityTypeRegistry registerImplementation(Class<T> type, Class<? extends T> implClazz) {
        Preconditions.checkNotNull(type, (Object)"type");
        Preconditions.checkNotNull(implClazz, (Object)"implClazz");
        this.checkIsImplementation(type, implClazz);
        this.checkIsNewStyleImplementation(implClazz);
        Object object = this.mutex;
        synchronized (object) {
            Class existingType = (Class)this.registry.inverse().get(implClazz);
            if (existingType != null && !type.equals(existingType)) {
                throw new IllegalArgumentException("Implementation " + implClazz + " already registered against type " + existingType + "; cannot also register against " + type);
            }
            LOG.debug("Implementation {} registered against type {}", implClazz, type);
            this.registry.put(type, implClazz);
            this.cache.forcePut(type, implClazz);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entity> Class<? extends T> getImplementedBy(Class<T> type) {
        Object object = this.mutex;
        synchronized (object) {
            Class<T> result = (Class<T>)this.cache.get(type);
            if (result != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Implementation {} returned for type {}", result, type);
                }
                return result;
            }
            result = this.getFromAnnotation(type);
            if (result == null) {
                if (!type.isInterface() && (type.getModifiers() & 0x400) == 0) {
                    result = type;
                } else {
                    throw new IllegalArgumentException("Interface " + type + " is not annotated with @" + ImplementedBy.class.getSimpleName() + ", and no implementation is registered");
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Implementation {} returned for type {}", result, type);
            }
            this.cache.put(type, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entity> Class<? super T> getEntityTypeOf(Class<T> implClazz) {
        Object object = this.mutex;
        synchronized (object) {
            Class<T> result = (Class<T>)this.cache.inverse().get(implClazz);
            if (result != null) {
                return result;
            }
            result = this.getInterfaceWithAnnotationMatching(implClazz);
            this.cache.put(implClazz, result);
            return result;
        }
    }

    private <T extends Entity> Class<? extends T> getFromAnnotation(Class<T> type) {
        ImplementedBy annotation = type.getAnnotation(ImplementedBy.class);
        if (annotation == null) {
            return null;
        }
        Class value = annotation.value();
        this.checkIsImplementation(type, value);
        return value;
    }

    private <T extends Entity> Class<? super T> getInterfaceWithAnnotationMatching(Class<T> implClazz) {
        LinkedHashSet visited = Sets.newLinkedHashSet();
        LinkedList tovisit = new LinkedList();
        tovisit.add(implClazz);
        while (!tovisit.isEmpty()) {
            Class contender = (Class)tovisit.pop();
            if (contender == null || visited.contains(contender)) continue;
            visited.add(contender);
            if (contender.isInterface()) {
                Class value;
                ImplementedBy annotation = contender.getAnnotation(ImplementedBy.class);
                Class clazz = value = annotation == null ? null : annotation.value();
                if (implClazz.equals(value)) {
                    return contender;
                }
            }
            tovisit.addAll(Arrays.asList(contender.getInterfaces()));
            tovisit.add(contender.getSuperclass());
        }
        throw new IllegalArgumentException("Interfaces of " + implClazz + " not annotated with @" + ImplementedBy.class.getSimpleName() + " matching this class");
    }

    private void checkIsImplementation(Class<?> type, Class<?> implClazz) {
        if (!type.isAssignableFrom(implClazz)) {
            throw new IllegalStateException("Implementation " + implClazz + " does not implement " + type);
        }
        if (implClazz.isInterface()) {
            throw new IllegalStateException("Implementation " + implClazz + " is an interface, but must be a non-abstract class");
        }
        if (Modifier.isAbstract(implClazz.getModifiers())) {
            throw new IllegalStateException("Implementation " + implClazz + " is abstract, but must be a non-abstract class");
        }
    }

    private void checkIsNewStyleImplementation(Class<?> implClazz) {
        try {
            implClazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Implementation " + implClazz + " must have a no-argument constructor");
        }
        catch (SecurityException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

