/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.group.zoneaware;

import brooklyn.entity.group.zoneaware.AbstractZoneFailureDetector;
import brooklyn.location.Location;
import brooklyn.util.time.Duration;
import com.google.common.base.Ticker;

public class ProportionalZoneFailureDetector
extends AbstractZoneFailureDetector {
    protected final int minDatapoints;
    protected final long timeToConsider;
    protected final double maxProportionFailures;

    public ProportionalZoneFailureDetector(int minDatapoints, Duration timeToConsider, double maxProportionFailures) {
        this(minDatapoints, timeToConsider, maxProportionFailures, Ticker.systemTicker());
    }

    public ProportionalZoneFailureDetector(int minDatapoints, Duration timeToConsider, double maxProportionFailures, Ticker ticker) {
        super(ticker);
        this.minDatapoints = minDatapoints;
        this.timeToConsider = timeToConsider.toMilliseconds();
        this.maxProportionFailures = maxProportionFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doHasFailed(Location loc, AbstractZoneFailureDetector.ZoneHistory zoneHistory) {
        AbstractZoneFailureDetector.ZoneHistory zoneHistory2 = zoneHistory;
        synchronized (zoneHistory2) {
            zoneHistory.trimOlderThan(this.currentTimeMillis() - this.timeToConsider);
            int numDatapoints = zoneHistory.successes.size() + zoneHistory.failures.size();
            double proportionFailure = (double)zoneHistory.failures.size() / (double)numDatapoints;
            return numDatapoints >= this.minDatapoints && proportionFailure >= this.maxProportionFailures;
        }
    }
}

