/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.group.zoneaware;

import brooklyn.entity.group.zoneaware.AbstractZoneFailureDetector;
import brooklyn.location.Location;
import brooklyn.util.time.Duration;
import com.google.common.base.Predicate;

public class CriticalCauseZoneFailureDetector
extends AbstractZoneFailureDetector {
    protected final long timeToConsider;
    protected final Predicate<? super Throwable> criticalityPredicate;
    private final int numTimes;

    public CriticalCauseZoneFailureDetector(Duration timeToConsider, Predicate<? super Throwable> criticalityPredicate, int numTimes) {
        this.timeToConsider = timeToConsider.toMilliseconds();
        this.criticalityPredicate = criticalityPredicate;
        this.numTimes = numTimes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doHasFailed(Location loc, AbstractZoneFailureDetector.ZoneHistory zoneHistory) {
        AbstractZoneFailureDetector.ZoneHistory zoneHistory2 = zoneHistory;
        synchronized (zoneHistory2) {
            zoneHistory.trimOlderThan(System.currentTimeMillis() - this.timeToConsider);
            int count = 0;
            for (Throwable cause : zoneHistory.causes) {
                if (!this.criticalityPredicate.apply((Object)cause)) continue;
                ++count;
            }
            return count >= this.numTimes;
        }
    }
}

